/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.util.SealEncrypt;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.stamp.CommonSealCollection;
import com.kingdee.eas.cp.stamp.CommonSealFactory;
import com.kingdee.eas.cp.stamp.CommonSealInfo;
import com.kingdee.eas.cp.stamp.CommonSealPermissionCollection;
import com.kingdee.eas.cp.stamp.CommonSealPermissionFactory;
import com.kingdee.eas.cp.stamp.CommonSealPermissionInfo;
import com.kingdee.eas.cp.stamp.EnableCAEnum;
import com.kingdee.eas.cp.stamp.ICommonSeal;
import com.kingdee.eas.cp.stamp.ICommonSealPermission;
import com.kingdee.eas.cp.stamp.IPersonalSeal;
import com.kingdee.eas.cp.stamp.IPersonalSealPermission;
import com.kingdee.eas.cp.stamp.IStampLog;
import com.kingdee.eas.cp.stamp.ManageLogUtil;
import com.kingdee.eas.cp.stamp.PersonalSealFactory;
import com.kingdee.eas.cp.stamp.PersonalSealInfo;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionCollection;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionFactory;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionInfo;
import com.kingdee.eas.cp.stamp.SealStatus;
import com.kingdee.eas.cp.stamp.StampLogCollection;
import com.kingdee.eas.cp.stamp.StampLogFactory;
import com.kingdee.eas.cp.stamp.StoreType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.plt.cp.common.util.CpServiceLocator;
import com.kingdee.portal.plt.cp.module.setting.dto.SealDTO;
import com.kingdee.portal.plt.cp.module.setting.service.CommonSealService;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class CommonSealAction
extends BaseFileUploadAction {
    private CommonSealService commonSealServiceImpl = (CommonSealService)CpServiceLocator.getBean("commonSealService");

    public void loadComSealPageList() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            Map<String, String> paramMap = this.buildParam();
            PagingResult<SealDTO> pagingResult = this.commonSealServiceImpl.getComSealPageList(ctx, paramMap, this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> buildParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comSealName", this.getRequest().getParameter("comSealName"));
        param.put("orgId", this.getRequest().getParameter("orgId"));
        return param;
    }

    public void checkSealAdminPermission() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean result = this.commonSealServiceImpl.isCurrPersonSealAdmin(ctx);
        this.writeObjectData(result, ResponseContentTypeEnum.HTML);
    }

    public void isEnableSafeStamp() {
        boolean flag = false;
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            String paramItemValue = iParam.getParamValueIgnoreGroupControl("safeStamp", (IObjectPK)new ObjectUuidPK(cu.getId()), false);
            if (paramItemValue != null && !"".equals(paramItemValue)) {
                flag = Boolean.valueOf(paramItemValue);
            }
            this.writeObjectData(flag, ResponseContentTypeEnum.HTML);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            this.writeObjectData(false, ResponseContentTypeEnum.HTML);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            this.writeObjectData(false, ResponseContentTypeEnum.HTML);
        }
    }

    public void getComSealDetailById() {
        String sealId = this.getRequest().getParameter("sealId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            SealDTO sealDto = new SealDTO();
            sealDto.setId(sealId);
            ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)ctrlUnit.getValue((IObjectPK)new ObjectUuidPK(currentModel.getBelongOrg().getId()));
            sealDto.setBelongOrgName(ctrlUnitInfo.getName());
            sealDto.setFileName(currentModel.getFileName());
            sealDto.setName(currentModel.getName());
            sealDto.setIsEnableCA(String.valueOf(currentModel.getIsEnableCA().getValue()));
            sealDto.setStoreType(String.valueOf(currentModel.getStoreType().getValue()));
            sealDto.setStatus(String.valueOf(currentModel.getStatus().getValue()));
            sealDto.seteKeyIndex(currentModel.getEKeySealIndex());
            sealDto.seteKeySN(currentModel.getEKeySN());
            byte[] bytesPassword = new SealEncrypt().stringToBytes(currentModel.getPassword());
            String password = new String(SealEncrypt.decode((byte[])bytesPassword));
            sealDto.setNumber(password);
            this.writeAjaxData(true, null, sealDto);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void changeComSealPw() {
        String sealId = this.getRequest().getParameter("sealId");
        String newPw = this.getRequest().getParameter("newPw");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            byte[] passwordByte = SealEncrypt.encode((byte[])newPw.getBytes());
            String Storepw = new SealEncrypt().bytesToString(passwordByte);
            currentModel.setPassword(Storepw);
            iCommonSeal.save((CoreBaseInfo)currentModel);
            ManageLogUtil.beginLog((Context)ctx, (int)3, (CoreBaseInfo)currentModel);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void changeStatusOfCA() {
        String status = this.getRequest().getParameter("status");
        String ids = this.getRequest().getParameter("ids");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] selectId = ids.split(",");
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            if (selectId.length < 0) {
                this.writeAjaxData(false, null, "0");
            } else if (selectId.length == 1) {
                String id = selectId[0];
                CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                int operationType = 7;
                if (status.equals("enable")) {
                    if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.enableCA)) {
                        this.writeAjaxData(false, null, "1");
                        return;
                    }
                    operationType = 7;
                    currentModel.setIsEnableCA(EnableCAEnum.enableCA);
                }
                if (status.equals("disable")) {
                    if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.disableCA)) {
                        this.writeAjaxData(false, null, "2");
                        return;
                    }
                    operationType = 8;
                    currentModel.setIsEnableCA(EnableCAEnum.disableCA);
                }
                iCommonSeal.update((IObjectPK)new ObjectUuidPK(currentModel.getId()), (CoreBaseInfo)currentModel);
                CommonSealInfo commonSealInfo = iCommonSeal.getCommonSealInfo((IObjectPK)new ObjectUuidPK(id));
                ManageLogUtil.beginLog((Context)ctx, (int)operationType, (CoreBaseInfo)commonSealInfo);
                this.writeAjaxData(true, null, null);
            } else {
                int count = 0;
                for (int i = 0; i < selectId.length; ++i) {
                    String id = selectId[i];
                    CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    int operationType = 7;
                    if (status.equals("enable")) {
                        if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.enableCA)) continue;
                        operationType = 7;
                        currentModel.setIsEnableCA(EnableCAEnum.enableCA);
                    }
                    if (status.equals("disable")) {
                        if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.disableCA)) continue;
                        operationType = 8;
                        currentModel.setIsEnableCA(EnableCAEnum.disableCA);
                    }
                    iCommonSeal.update((IObjectPK)new ObjectUuidPK(currentModel.getId()), (CoreBaseInfo)currentModel);
                    CommonSealInfo commonSealInfo = iCommonSeal.getCommonSealInfo((IObjectPK)new ObjectUuidPK(id));
                    ManageLogUtil.beginLog((Context)ctx, (int)operationType, (CoreBaseInfo)commonSealInfo);
                    ++count;
                }
                if (count > 0) {
                    this.writeAjaxData(true, null, null);
                } else {
                    this.writeAjaxData(false, null, "3");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeal() {
        String ids = this.getRequest().getParameter("ids");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] selectId = ids.split(",");
        Statement ps = null;
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            Connection conn = EJBFactory.getConnection((Context)ctx);
            if (selectId.length < 1) {
                this.writeAjaxData(false, null, "\u5220\u9664\u5931\u8d25\uff0c\u6240\u9009\u7684\u6570\u636eID\u4e3a\u7a7a");
            } else if (selectId.length == 1) {
                String id = selectId[0];
                if (this.isStampUsed(id)) {
                    this.writeAjaxData(false, null, "\u6539\u516c\u7ae0\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
                    return;
                }
                CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                if (currentModel.getStoreType().equals((Object)StoreType.server)) {
                    String fileNameID = currentModel.getFileName();
                    String sealSqlstr = "delete T_STA_SealFile where fid ='" + fileNameID + "' ";
                    this.doLogForDeleteSeal(ctx, id, 1);
                    conn.setAutoCommit(false);
                    ps = conn.prepareStatement(sealSqlstr);
                    ps.execute();
                    iCommonSeal.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    conn.commit();
                }
                this.writeAjaxData(true, null, null);
            } else {
                StringBuffer failStr = new StringBuffer();
                for (int i = 0; i < selectId.length; ++i) {
                    String id = selectId[i];
                    CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    String fileNameID = currentModel.getFileName();
                    String sealName = currentModel.getName();
                    String sealSqlstr = "delete T_STA_SealFile where fid ='" + fileNameID + "' ";
                    if (!this.isStampUsed(id)) {
                        if (!currentModel.getStoreType().equals((Object)StoreType.server)) continue;
                        this.doLogForDeleteSeal(ctx, id, 1);
                        conn.setAutoCommit(false);
                        ps = conn.prepareStatement(sealSqlstr);
                        ps.execute();
                        iCommonSeal.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                        conn.commit();
                        continue;
                    }
                    if (failStr.length() <= 0) {
                        failStr.append(sealName);
                        continue;
                    }
                    failStr.append("," + sealName);
                }
                if (failStr.toString().length() > 0) {
                    this.writeAjaxData(false, null, failStr.toString() + "\u516c\u7ae0\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
                } else {
                    this.writeAjaxData(true, null, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), "-1");
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySeal() {
        String ids = this.getRequest().getParameter("ids");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] selectId = ids.split(",");
        Statement ps = null;
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            Connection conn = EJBFactory.getConnection((Context)ctx);
            if (selectId.length < 1) {
                this.writeAjaxData(false, null, "\u9500\u6bc1\u5931\u8d25\uff0c\u6240\u9009\u7684\u6570\u636eID\u4e3a\u7a7a");
            } else {
                for (int i = 0; i < selectId.length; ++i) {
                    String id = selectId[0];
                    CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    String fileNameID = currentModel.getFileName();
                    if (!currentModel.getStoreType().equals((Object)StoreType.server)) continue;
                    String sealSqlstr = "delete T_STA_SealFile where fid ='" + fileNameID + "' ";
                    ps = conn.prepareStatement(sealSqlstr);
                    ps.execute();
                    currentModel.setStatus(SealStatus.destroy);
                    currentModel.setFileName(null);
                    iCommonSeal.save((CoreBaseInfo)currentModel);
                    ManageLogUtil.beginLog((Context)ctx, (int)5, (CoreBaseInfo)currentModel);
                    this.writeAjaxData(true, null, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), "-1");
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void checkSealOldPw() {
        String id = this.getRequest().getParameter("sealId");
        String oldPw = this.getRequest().getParameter("oldPw");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            CommonSealInfo currentModel = (CommonSealInfo)iCommonSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            String pw = currentModel.getPassword();
            byte[] bytesPassword = new SealEncrypt().stringToBytes(pw);
            String password = new String(SealEncrypt.decode((byte[])bytesPassword));
            if (password.equals(oldPw)) {
                this.writeObjectData(true, ResponseContentTypeEnum.HTML);
            } else {
                this.writeObjectData(false, ResponseContentTypeEnum.HTML);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeObjectData(false, ResponseContentTypeEnum.HTML);
        }
    }

    public void getCurrentOrg() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        CtrlUnitInfo ctriUnitinfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String orgId = ctriUnitinfo.getId().toString();
        String orgName = ctriUnitinfo.getName();
        JSONObject obj = new JSONObject();
        obj.put((Object)"orgId", (Object)orgId);
        obj.put((Object)"orgName", (Object)orgName);
        this.writeAjaxData(true, null, obj);
    }

    public void isExistComSealName() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            String comSealName = this.getRequest().getParameter("comSealName");
            String sql = "select id where name = '" + comSealName + "' and status != '" + SealStatus.destroy.getValue() + "'";
            CommonSealCollection csc = iCommonSeal.getCommonSealCollection(sql);
            if (csc.size() > 0) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(true, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void saveComSeal() {
        String fileNameId = this.getRequest().getParameter("fileNameId");
        String sealName = this.getRequest().getParameter("sealName");
        String orgId = this.getRequest().getParameter("orgId");
        String storeType = this.getRequest().getParameter("storeType");
        String isEnableCA = this.getRequest().getParameter("isEnableCA");
        String comsealPw = this.getRequest().getParameter("comsealPw");
        String ekeySN = this.getRequest().getParameter("ekeySN");
        String ekeyIndex = this.getRequest().getParameter("ekeyIndex");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
            ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            File file = this.getUpload();
            if (file != null) {
                this.saveSealPic(storeType, fileNameId, file);
                CommonSealInfo comSealInfo = new CommonSealInfo();
                CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)ctrlUnit.getValue((IObjectPK)new ObjectUuidPK(orgId));
                comSealInfo.setName(sealName);
                comSealInfo.setFileName(fileNameId);
                comSealInfo.setBelongOrg(ctrlUnitInfo);
                comSealInfo.setStatus(SealStatus.normal);
                byte[] passwordByte = SealEncrypt.encode((byte[])comsealPw.getBytes());
                String Storepd = new SealEncrypt().bytesToString(passwordByte);
                comSealInfo.setPassword(Storepd);
                if (isEnableCA.equals("1")) {
                    comSealInfo.setIsEnableCA(EnableCAEnum.enableCA);
                } else {
                    comSealInfo.setIsEnableCA(EnableCAEnum.disableCA);
                }
                if (storeType.equals("1")) {
                    comSealInfo.setStoreType(StoreType.server);
                } else {
                    comSealInfo.setStoreType(StoreType.USBKey);
                    comSealInfo.setEKeySealIndex(ekeyIndex);
                    comSealInfo.setEKeySN(ekeySN);
                }
                iCommonSeal.save((CoreBaseInfo)comSealInfo);
                ManageLogUtil.beginLog((Context)ctx, (int)1, (CoreBaseInfo)comSealInfo);
                this.writeAjaxTextData(true, "");
            } else {
                this.deleteSealFile(fileNameId);
                this.writeAjaxTextData(false, "img file is null");
            }
        }
        catch (Exception e) {
            this.deleteSealFile(fileNameId);
            e.printStackTrace();
            this.writeAjaxTextData(false, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSealPic(String storeType, String fileName, File file) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sql = null;
        if ("1".equals(storeType)) {
            sql = "update T_STA_SealFile set FSealPicture = ? where fid = ? ";
        } else if ("2".equals(storeType)) {
            sql = "Insert into T_STA_SealFile(FSealPicture,FID) values(?,?)";
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            PreparedStatement ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)is, ((InputStream)is).available());
            ps.setString(2, fileName);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSealFile(String FID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sealSqlstr = "delete T_STA_SealFile where fid = ? ";
        PreparedStatement ps = null;
        try {
            ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sealSqlstr);
            ps.setString(1, FID);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean isStampUsed(String id) {
        boolean flag = true;
        StampLogCollection stampLogCol = null;
        IStampLog iStampLog = null;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            iStampLog = StampLogFactory.getLocalInstance((Context)ctx);
            stampLogCol = iStampLog.getStampLogCollection("select id where sealID='" + id + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        flag = stampLogCol != null && stampLogCol.size() != 0;
        return flag;
    }

    private void doLogForDeleteSeal(Context ctx, String sealID, int sealType) {
        try {
            if (sealType == 1) {
                ICommonSeal service = CommonSealFactory.getLocalInstance((Context)ctx);
                CommonSealInfo info = service.getCommonSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                IObjectPK logPK = ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)info);
                ICommonSealPermission sealPermission = CommonSealPermissionFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sealName.id", (Object)sealID));
                view.setFilter(filterInfo);
                CommonSealPermissionCollection permissionColl = sealPermission.getCommonSealPermissionCollection(view);
                if (permissionColl != null && permissionColl.size() > 0) {
                    int j = permissionColl.size();
                    for (int i = 0; i < j; ++i) {
                        CommonSealPermissionInfo permissionInfo = permissionColl.get(i);
                        ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)permissionInfo);
                    }
                }
            } else {
                IPersonalSeal service = PersonalSealFactory.getLocalInstance((Context)ctx);
                PersonalSealInfo info = service.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                IObjectPK logPK = ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)info);
                IPersonalSealPermission sealPermission = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("personalSealName.id", (Object)sealID));
                view.setFilter(filterInfo);
                PersonalSealPermissionCollection permissionColl = sealPermission.getPersonalSealPermissionCollection(view);
                if (permissionColl != null && permissionColl.size() > 0) {
                    int j = permissionColl.size();
                    for (int i = 0; i < j; ++i) {
                        PersonalSealPermissionInfo permissionInfo = permissionColl.get(i);
                        ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)permissionInfo);
                    }
                }
            }
        }
        catch (BOSException e) {
            this.logger.error("LogService Err:" + e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            this.logger.error("LogService Err:" + e.getMessage(), (Throwable)e);
        }
    }

    private void writeAjaxTextData(boolean success, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("result", tempResult);
        this.writeObjectData(JSONObject.fromObject(ajaxData).toString(), ResponseContentTypeEnum.HTML);
    }
}

