/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.odm.FileWordsConfigFactory;
import com.kingdee.eas.cp.odm.FileWordsFactory;
import com.kingdee.eas.cp.odm.FileWordsInfo;
import com.kingdee.eas.cp.odm.IFileWords;
import com.kingdee.eas.cp.odm.IsEnabledEnum;
import com.kingdee.eas.cp.odm.ReservedNoFactory;
import com.kingdee.eas.cp.odm.WordsTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.cp.module.setting.dto.FileWordsDto;
import com.kingdee.portal.plt.cp.module.setting.util.BaseSettingUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FileWordsAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    public void fileWordsList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String fileWordsName = this.getRequest().getParameter("fileWordsName");
        String isEnable = this.getRequest().getParameter("isEnable");
        String orderByField = "";
        String orderType = "";
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        int conditionCount = 0;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        filterItemInfo = new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.LIKE);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (null != fileWordsName && !"".equals(fileWordsName)) {
            filterItemInfo = new FilterItemInfo("fileWordsName", (Object)("%" + fileWordsName + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != isEnable && !"".equals(isEnable)) {
            filterItemInfo = new FilterItemInfo("isEnable", (Object)isEnable, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (conditionCount == 0) {
            filterInfo.setMaskString(" #0 ");
        } else if (conditionCount == 1) {
            filterInfo.setMaskString(" #0 AND #1");
        } else if (conditionCount == 2) {
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.odm.app", "FileWordsQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<FileWordsDto> list = new ArrayList<FileWordsDto>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    FileWordsDto fileWordsDto = new FileWordsDto();
                    fileWordsDto.setId(rowSet.getString("id"));
                    fileWordsDto.setFileWordsName(rowSet.getString("fileWordsName"));
                    fileWordsDto.setFileWordsPreView(rowSet.getString("fileWordsPreView"));
                    int state = rowSet.getInt("isEnable");
                    if (state == 0) {
                        fileWordsDto.setIsEnable("\u542f\u7528");
                    } else {
                        fileWordsDto.setIsEnable("\u7981\u7528");
                    }
                    fileWordsDto.setFileNumberPre(rowSet.getString("fileNumberPre"));
                    fileWordsDto.setFileWordsPre(rowSet.getString("fileWordsPre"));
                    fileWordsDto.setWordsType(rowSet.getString("wordsType"));
                    fileWordsDto.setFileNumberSuf(rowSet.getString("fileNumberSuf"));
                    fileWordsDto.setSeperate(rowSet.getString("seperate"));
                    fileWordsDto.setNumberPre(rowSet.getString("numberPre"));
                    fileWordsDto.setNumberSuf(rowSet.getString("numberSuf"));
                    fileWordsDto.setOrgunits(rowSet.getString("orgunits"));
                    list.add(fileWordsDto);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fileWordsSave() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        if (!BaseSettingUtil.isHasPermission(ctx, "cp_odm_FileWords_edit")) {
            localErr = new LocalErr();
            localErr.setDesc("\u6ca1\u6709\u4fee\u6539\u6743\u9650");
            succ = false;
            this.writeAjaxData(succ, localErr, null);
            return;
        }
        String id = this.getRequest().getParameter("id");
        String fileWordsName = this.getRequest().getParameter("fileWordsName");
        String fileWordsPre = this.getRequest().getParameter("fileWordsPre");
        String fileNumberPre = this.getRequest().getParameter("fileNumberPre");
        String wordsType = this.getRequest().getParameter("wordsType");
        String fileNumberSuf = this.getRequest().getParameter("fileNumberSuf");
        String seperate = this.getRequest().getParameter("seperate");
        String numberPre = this.getRequest().getParameter("numberPre");
        String numberSuf = this.getRequest().getParameter("numberSuf");
        String fileWordsPreView = this.getRequest().getParameter("fileWordsPreView");
        FileWordsInfo info = new FileWordsInfo();
        String result = "";
        info.setFileWordsName(fileWordsName);
        info.setFileWordsPre(fileWordsPre);
        info.setFileNumberPre(fileNumberPre);
        info.setWordsType(WordsTypeEnum.getEnum((int)Integer.parseInt(wordsType)));
        info.setFileNumberSuf(fileNumberSuf);
        info.setSeperate(seperate);
        info.setNumberPre(numberPre);
        info.setNumberSuf(numberSuf);
        info.setFileWordsPreView(fileWordsPreView);
        info.setIsEnable(IsEnabledEnum.ENABLED);
        try {
            IFileWords fileWords = FileWordsFactory.getLocalInstance((Context)ctx);
            if (null == id || "".equals(id)) {
                if (FileWordsAction.isExistsFileWordsName(ctx, fileWordsName, id)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                } else if (this.isExistsFileWordsPreView(ctx, fileWordsName, id)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u9884\u89c8\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                } else {
                    String newId = fileWords.addnew((CoreBaseInfo)info).toString();
                    succ = true;
                    result = newId;
                }
            } else {
                info.setId(BOSUuid.read((String)id));
                if (FileWordsAction.isExistsFileWordsName(ctx, fileWordsName, id)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                } else if (this.isExistsFileWordsPreView(ctx, fileWordsName, id)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u9884\u89c8\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                } else if (ReservedNoFactory.getLocalInstance((Context)ctx).exists(" where fileWords.id='" + id + "'")) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u5df2\u7ecf\u88ab\u9884\u7559\uff0c\u4e0d\u80fd\u4fee\u6539\u3002");
                    succ = false;
                } else if (FileWordsConfigFactory.getLocalInstance((Context)ctx).exists(" where fileWords.id='" + id + "'")) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u6587\u4ef6\u5b57\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002");
                    succ = false;
                } else {
                    fileWords.save((CoreBaseInfo)info);
                    succ = true;
                    result = id;
                }
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void fileWordsDelete() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        String id = this.getRequest().getParameter("id");
        try {
            if (!BaseSettingUtil.isHasPermission(ctx, "cp_odm_FileWords_edit")) {
                localErr = new LocalErr();
                localErr.setDesc("\u6ca1\u6709\u5220\u9664\u6743\u9650");
                succ = false;
                this.writeAjaxData(succ, localErr, null);
                return;
            }
            if (FileWordsConfigFactory.getLocalInstance((Context)ctx).exists(" where fileWords.id='" + id + "'")) {
                localErr = new LocalErr();
                localErr.setDesc("\u6587\u4ef6\u5b57\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002");
                succ = false;
                this.writeAjaxData(succ, localErr, null);
                return;
            }
            if (ReservedNoFactory.getLocalInstance((Context)ctx).exists(" where fileWords.id='" + id + "'")) {
                localErr = new LocalErr();
                localErr.setDesc("\u6587\u4ef6\u5b57\u5df2\u7ecf\u88ab\u9884\u7559");
                succ = false;
                this.writeAjaxData(succ, localErr, null);
                return;
            }
            IFileWords fileWords = FileWordsFactory.getLocalInstance((Context)ctx);
            fileWords.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (UuidException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void fileWordsLoad() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        HashMap<String, String> result = new HashMap<String, String>();
        String id = this.getRequest().getParameter("id");
        try {
            IFileWords fileWords = FileWordsFactory.getLocalInstance((Context)ctx);
            FileWordsInfo info = fileWords.getFileWordsInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            result.put("id", info.getId().toString());
            result.put("fileWordsName", info.getFileWordsName());
            result.put("fileWordsPre", info.getFileWordsPre());
            result.put("fileNumberPre", info.getFileNumberPre());
            result.put("wordsType", String.valueOf(info.getWordsType().getValue()));
            result.put("fileNumberSuf", info.getFileNumberSuf());
            result.put("seperate", info.getSeperate());
            result.put("numberPre", info.getNumberPre());
            result.put("numberSuf", info.getNumberSuf());
            result.put("fileWordsPreView", info.getFileWordsPreView());
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void fileWordsAble() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        boolean isUsed = false;
        String result = "0";
        String id = this.getRequest().getParameter("id");
        String op = this.getRequest().getParameter("op");
        try {
            if (op.equals("1")) {
                isUsed = FileWordsConfigFactory.getLocalInstance((Context)ctx).exists(" where fileWords.id='" + id + "'");
            }
            if (!isUsed) {
                IFileWords fileWords = FileWordsFactory.getLocalInstance((Context)ctx);
                fileWords.setStatus(id, IsEnabledEnum.getEnum((int)Integer.parseInt(op)));
                result = "1";
            }
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (UuidException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void fileWordsCheckPerm() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] perList = new String[]{"cp_odm_FileWords_edit", "cp_odm_ReservedNo_edit", "cp_odm_CodingHistory_view"};
        Map<String, Boolean> perMap = BaseSettingUtil.perListCheck(perList, ctx, this.getRequest());
        this.writeAjaxData(true, null, perMap);
    }

    private boolean isExistsFileWordsPreView(Context ctx, String fileWordsName, String billId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("where cu.id='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' and fileWordsPreView ='" + fileWordsName + "'");
        if (!StringUtils.isEmpty((String)billId)) {
            sql.append(" and id <> '" + billId + "'");
        }
        IFileWords iFileWords = FileWordsFactory.getLocalInstance((Context)ctx);
        return iFileWords.exists(sql.toString());
    }

    private static boolean isExistsFileWordsName(Context ctx, String fileWordsName, String billId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("where cu.id='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' and fileWordsName ='" + fileWordsName + "'");
        if (!StringUtils.isEmpty((String)billId)) {
            sql.append(" and id <> '" + billId + "'");
        }
        IFileWords iFileWords = FileWordsFactory.getLocalInstance((Context)ctx);
        return iFileWords.exists(sql.toString());
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = false;
        return exec;
    }
}

