/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.arcm.IThematic;
import com.kingdee.eas.cp.arcm.ThematicCollection;
import com.kingdee.eas.cp.arcm.ThematicFactory;
import com.kingdee.eas.cp.arcm.ThematicInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.cp.module.setting.util.BaseSettingUtil;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ThematicAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    public void thematicList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String name = this.getRequest().getParameter("name");
        String orderByField = "";
        String orderType = "";
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        int conditionCount = 0;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        filterItemInfo = new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (null != name && !"".equals(name)) {
            filterItemInfo = new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (conditionCount == 0) {
            filterInfo.setMaskString(" #0 ");
        } else {
            filterInfo.setMaskString(" #0 and #1 ");
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.arcm.app", "ThematicQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList list = new ArrayList();
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rowSet.getString("id"));
                    map.put("name", rowSet.getString("name"));
                    list.add(map);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void thematicSave() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        String id = this.getRequest().getParameter("id");
        String thematicName = this.getRequest().getParameter("thematicName");
        ThematicInfo info = new ThematicInfo();
        boolean succ = false;
        String result = "";
        info.setName(thematicName);
        try {
            IThematic thematic = ThematicFactory.getLocalInstance((Context)ctx);
            if (null == id || "".equals(id)) {
                if (this.isExist(info)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u4e3b\u9898\u8bcd\u5df2\u7ecf\u5b58\u5728");
                } else {
                    String newId = thematic.addnew((CoreBaseInfo)info).toString();
                    succ = true;
                    result = newId;
                }
            } else {
                info.setId(BOSUuid.read((String)id));
                if (this.isExist(info)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u4e3b\u9898\u8bcd\u5df2\u7ecf\u5b58\u5728");
                } else {
                    thematic.save((CoreBaseInfo)info);
                    succ = true;
                    result = id;
                }
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void thematicDelete() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        String id = this.getRequest().getParameter("id");
        String[] idArr = id.split(",");
        ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
        try {
            IThematic thematic = ThematicFactory.getLocalInstance((Context)ctx);
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            thematic.delete((IObjectPK[])pkArr);
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (UuidException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void thematicLoad() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        HashMap<String, String> result = new HashMap<String, String>();
        String id = this.getRequest().getParameter("id");
        try {
            IThematic thematic = ThematicFactory.getLocalInstance((Context)ctx);
            ThematicInfo info = thematic.getThematicInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            result.put("id", info.getId().toString());
            result.put("thematicName", info.getName());
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void thematicPermisson() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] perList = new String[]{"cp_arcm_Thematic_View", "cp_arcm_Thematic_Update", "cp_arcm_Thematic_Delete"};
        Map<String, Boolean> result = BaseSettingUtil.perListCheck(perList, ctx, this.getRequest());
        this.writeAjaxData(true, null, result);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private boolean isExist(ThematicInfo curModel) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IThematic thematic = ThematicFactory.getLocalInstance((Context)ctx);
            ThematicCollection col = thematic.getThematicCollection("select * where name = '" + curModel.getName() + "' and cu.id='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "'");
            if (col.size() > 0 && !col.get(0).getId().equals((Object)curModel.getId())) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }
}

