/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.stamp.IPersonalSealPermission;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionCollection;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionFactory;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.module.setting.dto.SealDTO;
import com.kingdee.portal.plt.cp.module.setting.service.PersonalSealService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PersonalSealServiceImpl
implements PersonalSealService {
    @Override
    public IRowSet getPersonalSealList(Context ctx, Map<String, String> param) throws Exception {
        EntityViewInfo entityViewInfo = this.buileComSealViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.PersonalSealAdvanceQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        return countRowSet;
    }

    @Override
    public PagingResult<SealDTO> getPersonalSealPageList(Context ctx, Map<String, String> param, PagingParam pagingParam) throws Exception {
        EntityViewInfo entityViewInfo = this.buileComSealViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.PersonalSealAdvanceQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        int total = 0;
        int totalPage = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        while (countRowSet.next()) {
            ++total;
        }
        totalPage = (total - 1) / pageSize + 1;
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.getEnum((String)SortType.DESCEND.getName()));
        entityViewInfo.getSorter().add(sorterItemInfo);
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<SealDTO> list = new ArrayList<SealDTO>();
        HashSet<String> idSet = new HashSet<String>();
        if (rowSet != null) {
            while (rowSet.next()) {
                SealDTO sealDto = new SealDTO();
                sealDto.setId(rowSet.getString("id"));
                idSet.add(rowSet.getString("id"));
                sealDto.setOwnerName(rowSet.getString("owner.name"));
                sealDto.setCreateTime(rowSet.getString("createTime"));
                sealDto.setCreatorName(rowSet.getString("creator.name"));
                sealDto.setFileName(rowSet.getString("fileName"));
                sealDto.setIsEnableCA(rowSet.getString("isEnableCA"));
                sealDto.setName(rowSet.getString("name"));
                sealDto.setStatus(rowSet.getString("status"));
                sealDto.setStoreType(rowSet.getString("storeType"));
                list.add(sealDto);
            }
            Map<String, PersonalSealPermissionInfo> permissionMap = this.getPersonalPermission(ctx, idSet);
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                SealDTO data = (SealDTO)list.get(i);
                String id = data.getId();
                if (permissionMap.containsKey(id)) {
                    PersonalSealPermissionInfo extInfo = permissionMap.get(id);
                    data.setSealPerUserName(this.getPersonName(ctx, extInfo.getUser().getId()));
                    data.setSealPerStartDate(DateUtil.dateToStr((Date)extInfo.getStartDate(), (String)"yyyy-MM-dd"));
                    data.setSealPerEndDate(DateUtil.dateToStr((Date)extInfo.getEndDate(), (String)"yyyy-MM-dd"));
                    continue;
                }
                data.setSealPerUserName("");
                data.setSealPerStartDate("");
                data.setSealPerEndDate("");
            }
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private EntityViewInfo buileComSealViewInfo(Context ctx, Map<String, String> param) throws Exception {
        FilterItemInfo item;
        FilterItemCollection itemCollection;
        FilterInfo filterInfo;
        String presonalSealName = param.get("presonalSealName");
        String ownerId = param.get("ownerId");
        EntityViewInfo commonEntityViewInfo = new EntityViewInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (this.isCurrPersonSealAdmin(ctx)) {
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("CU.id", (Object)this.getCurrCUID(ctx));
            itemCollection.add(item);
            entityViewInfo.setFilter(filterInfo);
        } else {
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("creator.id", (Object)this.getCurUserID(ctx));
            itemCollection.add(item);
            item = new FilterItemInfo("owner.id", (Object)this.getCurPersonID(ctx));
            itemCollection.add(item);
            item = new FilterItemInfo("CU.id", (Object)this.getCurrCUID(ctx));
            filterInfo.getFilterItems().add(item);
            item = new FilterItemInfo("sealPermission.user.id", (Object)this.getCurPersonID(ctx));
            filterInfo.getFilterItems().add(item);
            item = new FilterItemInfo("sealPermission.startDate", (Object)this.getBeginDate(new Date()), CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(item);
            item = new FilterItemInfo("sealPermission.endDate", (Object)this.getBeginDate(new Date()), CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(item);
            filterInfo.setMaskString("(((#0) or (#1)) and #2) or (#3 and #4 and #5)");
            entityViewInfo.setFilter(filterInfo);
        }
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo1 = new FilterInfo();
        itemCollection = filterInfo1.getFilterItems();
        item = null;
        if (!StringUtil.isEmpty((String)presonalSealName)) {
            item = new FilterItemInfo("name", (Object)("%" + presonalSealName + "%"), CompareType.LIKE);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)ownerId)) {
            item = new FilterItemInfo("owner.id", (Object)ownerId);
            itemCollection.add(item);
        }
        entityViewInfo.setFilter(filterInfo1);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        return commonEntityViewInfo;
    }

    @Override
    public boolean isCurrPersonSealAdmin(Context ctx) {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgCUIDPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU().getId());
        boolean isAdmin = false;
        try {
            isAdmin = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgCUIDPK, "cp_stamp_Seal_Admin");
        }
        catch (Exception e) {
            e.printStackTrace();
            isAdmin = false;
        }
        return isAdmin;
    }

    @Override
    public boolean isPersonalSealCreator(Context ctx, String creatorID) {
        boolean retFlag = false;
        String curUserID = this.getCurUserID(ctx);
        if (curUserID != null && curUserID.equals(creatorID)) {
            retFlag = true;
        }
        return retFlag;
    }

    @Override
    public boolean isPersonalSealOwner(Context ctx, String ownerID) {
        boolean retFlag = false;
        String curUserID = this.getCurPersonID(ctx);
        if (curUserID != null && curUserID.equals(ownerID)) {
            retFlag = true;
        }
        return retFlag;
    }

    private String getCurPersonID(Context ctx) {
        PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (curPerson != null) {
            return curPerson.getId().toString();
        }
        return "";
    }

    private String getCurUserID(Context ctx) {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (curUser != null) {
            return curUser.getId().toString();
        }
        return "";
    }

    private String getCurrCUID(Context ctx) {
        CtrlUnitInfo curUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return curUnit.getId().toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void mergeEntityViewInfo(EntityViewInfo commonEntityViewInfo, EntityViewInfo commonFilter) throws Exception {
        if (FilterUtility.hasFilterItem((FilterInfo)commonEntityViewInfo.getFilter())) {
            commonEntityViewInfo.getFilter().mergeFilter(commonFilter.getFilter(), "AND");
        } else {
            FilterInfo filterInfo = commonFilter.getFilter();
            if (filterInfo != null) {
                commonEntityViewInfo.setFilter((FilterInfo)filterInfo.clone());
            }
        }
        if (commonFilter.getSorter().size() > 0) {
            commonEntityViewInfo.getSorter().clear();
            for (int i = 0; i < commonFilter.getSorter().size(); ++i) {
                commonEntityViewInfo.getSorter().add(commonFilter.getSorter().get(i));
            }
        }
    }

    private Date getBeginDate(Date beginDate) {
        Date begin = beginDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(begin);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(14, 0);
        begin = cal.getTime();
        return begin;
    }

    public Map<String, PersonalSealPermissionInfo> getPersonalPermission(Context ctx, Set<String> idSet) {
        HashMap<String, PersonalSealPermissionInfo> permissionDate = new HashMap<String, PersonalSealPermissionInfo>();
        PersonalSealPermissionCollection permissionColl = this.getPersonalPermissionColl(ctx, idSet);
        if (permissionColl.size() != 0) {
            int j = permissionColl.size();
            for (int i = 0; i < j; ++i) {
                PersonalSealPermissionInfo info = permissionColl.get(i);
                String sealID = info.getPersonalSealName().getId().toString();
                permissionDate.put(sealID, info);
            }
        }
        return permissionDate;
    }

    private PersonalSealPermissionCollection getPersonalPermissionColl(Context ctx, Set<String> idSet) {
        PersonalSealPermissionCollection permissionColl = new PersonalSealPermissionCollection();
        try {
            IPersonalSealPermission sealPermission = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterColl = filterInfo.getFilterItems();
            FilterItemInfo item = new FilterItemInfo("personalSealName.id", idSet, CompareType.INCLUDE);
            filterColl.add(item);
            item = new FilterItemInfo("startDate", (Object)this.getBeginDate(new Date()), CompareType.LESS_EQUALS);
            filterColl.add(item);
            item = new FilterItemInfo("endDate", (Object)this.getBeginDate(new Date()), CompareType.GREATER_EQUALS);
            filterColl.add(item);
            view.setFilter(filterInfo);
            permissionColl = sealPermission.getPersonalSealPermissionCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return permissionColl;
    }

    private String getPersonName(Context ctx, BOSUuid pk) {
        String personName = "";
        try {
            IPerson person = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo info = person.getPersonInfo((IObjectPK)new ObjectUuidPK(pk.toString()));
            personName = info.getName();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return personName;
    }
}

