/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.ireport.module.report.service.impl;

import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportCollection;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeCollection;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustKSQLReport;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustTree;
import com.kingdee.eas.base.reportmeta.ireport.ReportFacadeFactory;
import com.kingdee.eas.base.reportmeta.ireport.SolutionCollection;
import com.kingdee.eas.base.reportmeta.ireport.SolutionFactory;
import com.kingdee.eas.base.reportmeta.ireport.SolutionInfo;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.ireport.common.exception.ReportBizException;
import com.kingdee.portal.plt.ireport.module.report.dao.ReportFavoriteDAO;
import com.kingdee.portal.plt.ireport.module.report.dto.KSQLReportInfoDTO;
import com.kingdee.portal.plt.ireport.module.report.entity.ReportFavorite;
import com.kingdee.portal.plt.ireport.module.report.service.ReportFavoriteService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ReportFavoriteServiceImpl
implements ReportFavoriteService {
    private ReportFavoriteDAO reportFavoriteDAO;

    @Override
    public Map<String, Object> findReportTypes(PortalContext portalContext) throws ReportBizException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<KSQLReportInfoDTO> firstLevelPages = new ArrayList<KSQLReportInfoDTO>();
            HashMap multiTreeNodes = new HashMap();
            ICustTree custTree = CustTreeFactory.getRemoteInstance();
            ICustKSQLReport report = CustKSQLReportFactory.getRemoteInstance();
            CustTreeCollection treeNodes = custTree.getCustTreeCollection();
            for (int i = 0; i < treeNodes.size(); ++i) {
                CustTreeInfo info = treeNodes.get(i);
                String id = info.getId().toString();
                KSQLReportInfoDTO dto = new KSQLReportInfoDTO();
                dto.setName(info.getName());
                dto.setId(id);
                firstLevelPages.add(dto);
                CustKSQLReportCollection reportCollection = report.getCustKSQLReportCollection("where treeNode.id='" + id + "'");
                ArrayList<KSQLReportInfoDTO> nodes = new ArrayList<KSQLReportInfoDTO>();
                for (int j = 0; j < reportCollection.size(); ++j) {
                    CustKSQLReportInfo custReport = reportCollection.get(j);
                    KSQLReportInfoDTO nodeLeaf = new KSQLReportInfoDTO();
                    nodeLeaf.setId(custReport.getId().toString());
                    nodeLeaf.setName(custReport.getName());
                    nodes.add(nodeLeaf);
                }
                multiTreeNodes.put(info.getId().toString(), nodes);
            }
            map.put("firstLevelPages", firstLevelPages);
            map.put("multiTreeNodes", multiTreeNodes);
            return map;
        }
        catch (Exception e) {
            throw new ReportBizException("602", e);
        }
    }

    @Override
    public List<KSQLReportInfoDTO> findReportSolustions(PortalContext portalContext, String id) throws ReportBizException {
        try {
            ArrayList<KSQLReportInfoDTO> list = new ArrayList<KSQLReportInfoDTO>();
            SolutionCollection collection = ReportFacadeFactory.getRemoteInstance().getSolutions(id);
            for (int i = 0; i < collection.size(); ++i) {
                SolutionInfo info = collection.get(i);
                KSQLReportInfoDTO dto = new KSQLReportInfoDTO();
                if (info.getId() != null) {
                    dto.setId(info.getId().toString());
                } else {
                    dto.setRptId(info.getRptId());
                }
                dto.setName(info.getName());
                list.add(dto);
            }
            return list;
        }
        catch (Exception e) {
            throw new ReportBizException("602", e);
        }
    }

    @Override
    public List<KSQLReportInfoDTO> listPersonalFavorite(PortalContext portalContext) throws ReportBizException {
        try {
            ArrayList<KSQLReportInfoDTO> dtoList = new ArrayList<KSQLReportInfoDTO>();
            ReportFavorite report = new ReportFavorite();
            report.setPortalContext(portalContext);
            report.setUserId(portalContext.getLoginUser().getId());
            List list = this.reportFavoriteDAO.findList((Object)report, new Filter[]{new OrderFilter("runCount", OrderEnum.DESC)});
            if (list == null || list.size() == 0) {
                return null;
            }
            HashMap<String, SolutionInfo> solutionMap = new HashMap<String, SolutionInfo>();
            SolutionCollection collection = SolutionFactory.getRemoteInstance().getSolutionCollection();
            for (int i = 0; i < collection.size(); ++i) {
                SolutionInfo info = collection.get(i);
                solutionMap.put(info.getRptId(), info);
            }
            for (ReportFavorite favor : list) {
                String reportId = favor.getReportId();
                SolutionInfo info = (SolutionInfo)solutionMap.get(reportId);
                if (info == null) continue;
                KSQLReportInfoDTO dto = new KSQLReportInfoDTO();
                dto.setRptId(info.getRptId());
                dto.setName(info.getName());
                dto.setId(info.getId().toString());
                dtoList.add(dto);
            }
            return dtoList;
        }
        catch (Exception e) {
            throw new ReportBizException("602", e);
        }
    }

    @Override
    public ReportFavorite createPersonalFavorite(PortalContext portalContext, String reportId) throws ReportBizException {
        try {
            ReportFavorite report = new ReportFavorite();
            report.setPortalContext(portalContext);
            report.setUserId(portalContext.getLoginUser().getId());
            report.setReportId(reportId);
            ReportFavorite favorite = (ReportFavorite)((Object)this.reportFavoriteDAO.findObject((Object)report, null));
            if (favorite == null) {
                report.setRunCount(1);
                return (ReportFavorite)((Object)this.reportFavoriteDAO.create((Object)report));
            }
            report.setRunCount(favorite.getRunCount() + 1);
            return (ReportFavorite)((Object)this.reportFavoriteDAO.update((Object)report));
        }
        catch (DataAccessException e) {
            throw new ReportBizException("601", e);
        }
    }

    @Override
    public void delPersonalFavor(PortalContext portalContext, String id) throws ReportBizException {
        try {
            ReportFavorite report = new ReportFavorite();
            report.setPortalContext(portalContext);
            report.setReportId(id);
            this.reportFavoriteDAO.delete((Object)report);
        }
        catch (DataAccessException e) {
            throw new ReportBizException("603", e);
        }
    }

    @Override
    public List<ReportFavorite> listPersonalFavor(String userId, String reportId) throws ReportBizException {
        try {
            ReportFavorite report = new ReportFavorite();
            report.setUserId(userId);
            return this.reportFavoriteDAO.findList((Object)report, new Filter[]{new FieldFilter("reportId", "=", (Object)reportId)});
        }
        catch (DataAccessException e) {
            throw new ReportBizException("603", e);
        }
    }

    public ReportFavoriteDAO getReportFavoriteDAO() {
        return this.reportFavoriteDAO;
    }

    public void setReportFavoriteDAO(ReportFavoriteDAO reportFavoriteDAO) {
        this.reportFavoriteDAO = reportFavoriteDAO;
    }
}

