/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.ireport.module.report.servlet;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportCollection;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustKSQLReport;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportImgServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ReportImgServlet.class);
    private ServletContext context = null;
    private static final String DEFAULT_COMMON_IMG = "/res/img/global/icons/default-common-img.png";

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        try {
            String id = StringUtil.convNull((String)request.getParameter("id"));
            ICustKSQLReport report = CustKSQLReportFactory.getRemoteInstance();
            CustKSQLReportCollection reportCollection = report.getCustKSQLReportCollection("where id='" + id + "'");
            if (reportCollection != null && reportCollection.size() > 0) {
                CustKSQLReportInfo info = reportCollection.get(0);
                byte[] imgContent = info.getIcon();
                this.writeResponse(response, imgContent);
                return;
            }
            this.response4FileImg(response, portalContext, null, DEFAULT_COMMON_IMG);
        }
        catch (BOSException e) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void response4FileImg(HttpServletResponse response, PortalContext portalContext, String imgPath, String defaultImg) {
        if (StringUtil.isEmpty((String)imgPath)) {
            byte[] imgContent = this.getDefaultImgContent(defaultImg);
            if (imgContent != null) {
                this.writeResponse(response, imgContent);
            } else {
                logger.error("\u9ed8\u8ba4\u56fe\u7247\u4e22\u5931\uff1a" + defaultImg);
            }
            return;
        }
    }

    private byte[] getDefaultImgContent(String imgPath) {
        byte[] imgContent = new byte[0x100000];
        try {
            this.context.getResourceAsStream(imgPath).read(imgContent);
        }
        catch (IOException ioEx) {
            logger.error("\u6ca1\u6709\u627e\u5230\u8d44\u6e90\uff1a" + imgPath);
            ioEx.printStackTrace();
        }
        return imgContent;
    }

    private void writeResponse(HttpServletResponse response, byte[] result) {
        try {
            response.setContentType("image/gif");
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }
}

