/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.plt.iservice.common.util.ServiceLocator;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDocument;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceMarking;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDocumentService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceFavoriteService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceMarkingService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FavoriteAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private ServiceFavoriteService serviceFavoriteService = (ServiceFavoriteService)ServiceLocator.getBean("serviceFavoriteService");
    private ServiceDocumentService serviceDocumentService = (ServiceDocumentService)ServiceLocator.getBean("serviceDocumentService");
    private ServiceMarkingService serviceMarkingService = (ServiceMarkingService)ServiceLocator.getBean("serviceMarkingService");
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
    private ServiceDefinition definition;

    public String findMyServiceDetail() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            ServiceDefinition def = this.serviceFavoriteService.findServiceDefinition(this.getPortalContext(), this.definition.getId());
            PagingResult<ServiceDocument> list = this.serviceDocumentService.findDocListByServDefId(this.getPortalContext(), this.definition.getId(), this.getPagingParam());
            String userCode = this.easService.getUserCodeByUserId(this.getPortalContext(), def.getManagerId());
            List<ServiceMarking> servMarkingList = this.serviceMarkingService.findServiceMarkingList(this.getPortalContext(), this.definition.getId());
            Integer score = 0;
            if (servMarkingList != null && servMarkingList.size() > 0) {
                for (ServiceMarking mark : servMarkingList) {
                    score = score + mark.getScore();
                }
                score = score / servMarkingList.size();
            }
            resultMap.put("score", score);
            resultMap.put("definition", (Object)def);
            resultMap.put("documents", list);
            resultMap.put("servMarkingList", servMarkingList);
            resultMap.put("userCode", userCode);
            this.writeAjaxData(true, null, resultMap);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    public String findMyServiceFlow() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            ServiceDefinition def = this.serviceFavoriteService.findServiceDefinition(this.getPortalContext(), this.definition.getId());
            resultMap.put("icon", def.getWorkflowImg());
            resultMap.put("servDec", def.getDescription());
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        this.writeAjaxData(true, null, resultMap);
        return null;
    }

    public String checkWeibo() {
        try {
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
            String personId = this.getPortalContext().getLoginUser().getId();
            String weiboId = WeiboBizUtil.getWeiboUserIdByUserId((String)personId);
            if (StringUtils.isEmpty((String)weiboId)) {
                resultMap.put("isWeiboOpen", false);
                this.writeAjaxData(true, null, resultMap);
            } else {
                resultMap.put("isWeiboOpen", true);
                this.writeAjaxData(true, null, resultMap);
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    public String sendMessage() {
        try {
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
            String personId = this.getRequest().getParameter("personId");
            String content = this.getRequest().getParameter("content");
            WeiboBizUtil.sendDirectMessage((String)personId, (String)content, (String)"3");
            resultMap.put("isWeiboOpen", true);
            this.writeAjaxData(true, null, resultMap);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    private Context getContext() {
        Map metaMap = this.getPortalContext().getMetaInfo();
        Context ctx = (Context)metaMap.get("eas_context");
        return ctx;
    }

    public void setDefinition(ServiceDefinition definition) {
        this.definition = definition;
    }

    public ServiceDefinition getDefinition() {
        return this.definition;
    }
}

