/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.iservice.common.enums.InsStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.MarkFlagEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.util.ServiceLocator;
import com.kingdee.portal.plt.iservice.facade.workflow.WorkFlowService;
import com.kingdee.portal.plt.iservice.module.service.dto.ServRecDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceMarking;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceInstanceService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceMarkingService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MyServiceRecordAction
extends BaseAction {
    private ServiceInstanceService serviceInstanceService = (ServiceInstanceService)ServiceLocator.getBean("serviceInstanceService");
    private WorkFlowService workflowService = (WorkFlowService)ServiceLocator.getBean("workFlowService");
    private ServiceMarkingService serviceMarkingService = (ServiceMarkingService)ServiceLocator.getBean("serviceMarkingService");

    public String findMyServiceRecord() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = null;
        int startIndex = this.pagingParam.getStartIndex();
        int size = this.pagingParam.getPageSize();
        String state = this.getRequest().getParameter("state");
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(this.pagingParam);
        pagingResult.setRecords(new ArrayList());
        portalContext = this.getPortalContext();
        try {
            List<ServRecDTO> recList = null;
            if (state.equals(InsStateEnum.DRAFT.name())) {
                recList = this.serviceInstanceService.getServRec(portalContext, InsStateEnum.DRAFT, startIndex, size);
                int draftCount = this.serviceInstanceService.getServRecTotalCount(portalContext, InsStateEnum.DRAFT, null);
                pagingResult.setTotalCount(draftCount);
            } else if (state.equals(InsStateEnum.RUNNING.name())) {
                recList = this.serviceInstanceService.getServRec(portalContext, InsStateEnum.RUNNING, startIndex, size);
                this.setCurrNodeAndHandler(recList);
                int runningCount = this.serviceInstanceService.getServRecTotalCount(portalContext, InsStateEnum.RUNNING, null);
                pagingResult.setTotalCount(runningCount);
            } else if (state.equals(InsStateEnum.COMPLETE.name())) {
                recList = this.serviceInstanceService.getServRec(portalContext, InsStateEnum.COMPLETE, startIndex, size);
                this.setSerInstanScore(portalContext, recList);
                int compCount = this.serviceInstanceService.getServRecTotalCount(portalContext, InsStateEnum.COMPLETE, null);
                pagingResult.setTotalCount(compCount);
            } else if (state.equals("EVAL")) {
                recList = this.serviceInstanceService.getEvalServRec(portalContext, startIndex, size);
                int evalCount = this.serviceInstanceService.getServRecTotalCount(portalContext, InsStateEnum.COMPLETE, MarkFlagEnum.NO);
                pagingResult.setTotalCount(evalCount);
            } else if (state.equals("ALL")) {
                recList = this.serviceInstanceService.getAllServRec(portalContext, startIndex, size);
                this.setCurrNodeAndHandler(recList);
                this.setSerInstanScore(portalContext, recList);
                int totalCount = this.serviceInstanceService.getServRecTotalCount(portalContext, null, null);
                pagingResult.setTotalCount(totalCount);
            }
            pagingResult.setRecords(recList);
        }
        catch (ServiceBizException e) {
            success = false;
            localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(success, localErr, pagingResult);
            return null;
        }
        this.writePagingResult(pagingResult);
        return null;
    }

    private void setCurrNodeAndHandler(List<ServRecDTO> recList) throws ServiceBizException {
        for (int i = 0; i < recList.size(); ++i) {
            String procInstId;
            AssignCollection asColl;
            ServRecDTO rec = recList.get(i);
            if (!rec.getState().equals((Object)InsStateEnum.RUNNING) || null == (asColl = this.workflowService.getCurrNodeAndHanlerByProcinstId(procInstId = rec.getProcInstId()))) continue;
            String str = "";
            for (int j = 0; j < asColl.size(); ++j) {
                AssignInfo as = asColl.get(j);
                String actdefName = as.getActdefName();
                if (StringUtil.isEmptyString((String)actdefName) || !actdefName.contains("\u5ba1\u6279")) continue;
                str = str + as.getActdefName() + " " + as.getPersonUserName() + "; ";
            }
            if (StringUtil.isEmptyString((String)str)) {
                try {
                    Map metaMap = this.getPortalContext().getMetaInfo();
                    Context ctx = (Context)metaMap.get("eas_context");
                    IEnactmentService en = EnactmentServiceFactory.createEnactService((Context)ctx);
                    if ("open.not_running.suspended".equals(en.getProcessInstInfo(procInstId).getState())) {
                        str = "\u5df2\u6302\u8d77";
                    }
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            rec.setCurrentNode(str);
        }
    }

    private void setSerInstanScore(PortalContext portalContext, List<ServRecDTO> recList) throws ServiceBizException {
        for (int i = 0; i < recList.size(); ++i) {
            ServRecDTO rec = recList.get(i);
            String markFlag = rec.getMarkFlag();
            if (!rec.getState().equals((Object)InsStateEnum.COMPLETE) || !"YES".equals(markFlag)) continue;
            String serviceInstanceId = rec.getServiceInstancefid();
            ServiceMarking serviceMarking = this.serviceMarkingService.getScroeBySerInstanceID(portalContext, serviceInstanceId);
            rec.setScore(String.valueOf(serviceMarking.getScore() == null ? "0" : serviceMarking.getScore()));
        }
    }

    public void updateMyServiceState() {
        String fid = this.getRequest().getParameter("fid");
        String markFlag = this.getRequest().getParameter("markFlag");
        boolean result = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            result = this.serviceInstanceService.updateMarkFlag(portalContext, fid, markFlag);
        }
        catch (ServiceBizException e) {
            result = false;
            localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, false);
        }
        this.writeAjaxData(true, localErr, result);
    }

    public void delMyServiceInstanceByid() {
        String fid = this.getRequest().getParameter("fid");
        boolean result = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            result = this.serviceInstanceService.delMyServiceInstanceByid(portalContext, fid);
        }
        catch (ServiceBizException e) {
            result = false;
            localErr = this.handleErr((Exception)((Object)e));
            this.writeAjaxData(false, localErr, false);
        }
        this.writeAjaxData(true, localErr, result);
    }
}

