/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.enums.ServiceStateEnum;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceDefinitionDAO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import java.util.List;

public class ServiceDefinitionDAOImpl
extends BaseDAOImpl<ServiceDefinition>
implements ServiceDefinitionDAO {
    private static String JPQL_UPDATE_CHILD_STATE = "UPDATE FROM ServiceDefinition t SET t.state = '{state}' WHERE t.nodePath LIKE '%/{pId}/%'";
    private static String JPQL_HAS_EXISTED_SERVICE = "SELECT t FROM ServiceDefinition t WHERE t.state != '" + (Object)((Object)ServiceStateEnum.DELETED) + "' AND t.nodePath LIKE '%/{pId}/%'";

    @Override
    public int updateChildState(String pId, ServiceStateEnum state) throws DataAccessException {
        try {
            String jpql = StringUtil.merge((String)JPQL_UPDATE_CHILD_STATE, (String[])new String[]{state.toString(), pId});
            int updated = this.executeUpdate(jpql, new Object[0]);
            return updated;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public boolean hasExistedService(String pId) throws DataAccessException {
        try {
            String jpql = StringUtil.merge((String)JPQL_HAS_EXISTED_SERVICE, (String[])new String[]{pId});
            List list = this.findList(jpql, new Object[0]);
            return list != null && list.size() > 0;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public void updateServiceScore(PortalContext ctx, String defId) throws DataAccessException {
        String sql = "update ServiceDefinition t set t.serviceScore=( select avg(score) from ServiceMarking where serviceId='" + defId + "') where id='" + defId + "'";
        this.executeUpdate(sql, new Object[0]);
    }

    @Override
    public IRowSet findPresetFavPageList(PortalContext ctx, String presetId) throws DataAccessException {
        try {
            String sql = "select a.fid ,a.displayName,b.description,a.sourceId from (select p.fid,p.fdisplayName displayName,pf.fid pid,pf.fsourceId sourceId from T_JP_PresetFavPageList pf ,T_JP_ServiceDefinition p where (pf.fpFId='{presetId}' and p.fid=pf.fpageId)) a,(select p.fid,p.fdisplayName description,pf.fid pid from T_JP_PresetFavPageList pf ,T_JP_ServiceDefinition p where (pf.fpFId='{presetId}' and p.fid=pf.fsourceId)) b  where a.pid=b.pid";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{presetId, presetId});
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            return DbUtil.executeQuery((Context)context, (String)jpql);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }
}

