/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.biz.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.frame.dto.QuickStartMenuDto;
import com.kingdee.portal.biz.module.frame.entity.QuickStartMenu;
import com.kingdee.portal.biz.module.frame.enums.QuickStartTypeEnum;
import com.kingdee.portal.biz.module.frame.service.QuickStartMenuService;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class QuickStartAction
extends BaseAction {
    private QuickStartMenuService quickStartMenuService = (QuickStartMenuService)PortalServiceLocator.getBean((String)"quickStartMenuService");
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");

    public String findMenuList() {
        HttpServletRequest request = this.getRequest();
        String insId = request.getParameter("insId");
        boolean success = true;
        LocalErr localErr = null;
        ArrayList<QuickStartMenuDto> list = new ArrayList<QuickStartMenuDto>();
        try {
            List qkmList = this.quickStartMenuService.getAllMenuByPortetInsID(insId);
            if (qkmList != null && qkmList.size() > 0) {
                String[] ids = new String[qkmList.size()];
                HashMap<String, Page> map = new HashMap<String, Page>(ids.length);
                for (int i = 0; i < qkmList.size(); ++i) {
                    ids[i] = ((QuickStartMenu)qkmList.get(i)).getMenuID();
                }
                List pages = this.pageService.getPageByIdsAndOrder(this.getPortalContext(), ids, OrderEnum.ASC);
                for (Page page : pages) {
                    map.put(page.getId(), page);
                }
                for (int i = 0; i < qkmList.size(); ++i) {
                    QuickStartMenuDto dto = new QuickStartMenuDto();
                    dto.setId(((QuickStartMenu)qkmList.get(i)).getId());
                    dto.setType(((QuickStartMenu)qkmList.get(i)).getType().toString());
                    if (QuickStartTypeEnum.MENU.equals((Object)((QuickStartMenu)qkmList.get(i)).getType())) {
                        Page page = (Page)map.get(((QuickStartMenu)qkmList.get(i)).getMenuID());
                        if (page == null) continue;
                        dto.setMenuID(page.getId());
                        ELinkNodeExt nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                        dto.setUrl(nodeExt.getUrl());
                        dto.setMenuName(page.getDisplayName());
                        dto.setPageType(page.getNodeType());
                        dto.setNodeExt(page.getNodeExt());
                        dto.setPermEditCtrl(page.getPermEditCtrl());
                        dto.setPicSrc("/portal/res/img/ui/grid/default_48_48.png?v=1.0");
                    } else {
                        dto.setMenuName(((QuickStartMenu)qkmList.get(i)).getMenuName());
                        dto.setPicSrc(((QuickStartMenu)qkmList.get(i)).getIcon());
                        dto.setUrl(((QuickStartMenu)qkmList.get(i)).getOpenUrl());
                    }
                    list.add(dto);
                }
            }
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, list);
        return null;
    }

    public String managerQuickStartMenu() {
        HttpServletRequest request = this.getRequest();
        boolean success = true;
        LocalErr localErr = null;
        String insId = request.getParameter("insId");
        String toAdd = request.getParameter("toAdd");
        String toDel = request.getParameter("toDel");
        try {
            if (insId != null) {
                String[] toAddMenus = toAdd.split(",");
                String[] toDelMenus = toDel.split(",");
                this.quickStartMenuService.managerQuickStartMenu(this.getPortalContext(), insId, toAddMenus, toDelMenus);
            }
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String addQuickStartLink() {
        HttpServletRequest request = this.getRequest();
        boolean success = true;
        LocalErr localErr = null;
        String insId = request.getParameter("insId");
        String toAdd = request.getParameter("toAdd");
        try {
            if (insId != null && toAdd != null) {
                JSONObject linkObject = JSONObject.fromObject((Object)toAdd);
                QuickStartMenu quickStartLink = new QuickStartMenu();
                quickStartLink.setMenuName(linkObject.getString("menuName"));
                quickStartLink.setOpenUrl(linkObject.getString("url"));
                quickStartLink.setIcon(linkObject.getString("picSrc"));
                quickStartLink.setPortletInstanceId(insId);
                quickStartLink.setType(QuickStartTypeEnum.LINK);
                quickStartLink.setPortalContext(this.getPortalContext());
                ArrayList<QuickStartMenu> qs = new ArrayList<QuickStartMenu>();
                qs.add(quickStartLink);
                this.quickStartMenuService.addList(qs);
            }
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String finishEditQuickStartMenu() {
        HttpServletRequest request = this.getRequest();
        boolean success = true;
        LocalErr localErr = null;
        String insId = request.getParameter("insId");
        String list = request.getParameter("list");
        try {
            if (insId != null && list != null) {
                JSONArray menuItems = JSONArray.fromObject((Object)list);
                ArrayList<QuickStartMenu> qs = new ArrayList<QuickStartMenu>();
                for (int i = 0; i < menuItems.size(); ++i) {
                    JSONObject tmp = menuItems.getJSONObject(i);
                    QuickStartMenu menuItem = new QuickStartMenu();
                    menuItem.setPortletInstanceId(insId);
                    if ("MENU".equalsIgnoreCase(tmp.getString("type"))) {
                        menuItem.setMenuID(tmp.getString("id"));
                        menuItem.setType(QuickStartTypeEnum.MENU);
                    } else {
                        menuItem.setMenuName(tmp.getString("menuName"));
                        menuItem.setOpenUrl(tmp.getString("url"));
                        menuItem.setIcon(tmp.getString("picSrc"));
                        menuItem.setType(QuickStartTypeEnum.LINK);
                    }
                    menuItem.setOrder(Integer.valueOf(i));
                    menuItem.setPortalContext(this.getPortalContext());
                    qs.add(menuItem);
                }
                this.quickStartMenuService.resetByList(this.getPortalContext(), insId, qs);
            }
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String deleteQuickStartMenu() {
        HttpServletRequest request = this.getRequest();
        boolean success = true;
        LocalErr localErr = null;
        String id = request.getParameter("id");
        try {
            this.quickStartMenuService.deleteById(id);
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String deleteQuickStartPortlet() {
        HttpServletRequest request = this.getRequest();
        boolean success = true;
        LocalErr localErr = null;
        String id = request.getParameter("insId");
        try {
            this.quickStartMenuService.deleteByInsId(this.getPortalContext(), id);
        }
        catch (PortalBizException e) {
            success = false;
            localErr = e.getLocalErr(this.getPortalContext());
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String menuManager() {
        HttpServletRequest request = this.getRequest();
        String curIds = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("curIds"));
        if (StringUtils.isEmpty((String)curIds)) {
            request.setAttribute("selected", (Object)new String[0]);
        } else {
            request.setAttribute("selected", (Object)curIds.split(","));
        }
        return "success";
    }
}

