/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.biz.portlet;

import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.frame.dto.QuickStartMenuDto;
import com.kingdee.portal.biz.module.frame.enums.QuickStartTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.common.util.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class QuickStartPortlet
extends GenericPortlet {
    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletPreferences pf = request.getPreferences();
        Map preferencesMap = pf.getMap();
        String[] items = new String[]{};
        ArrayList<QuickStartMenuDto> list = new ArrayList<QuickStartMenuDto>();
        if (preferencesMap != null && preferencesMap.get("items") != null) {
            PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
            items = (String[])preferencesMap.get("items");
            HashSet<String> ids = new HashSet<String>();
            for (String item : items) {
                JSONObject tmp = JSONObject.fromObject((Object)item);
                if (!"MENU".equalsIgnoreCase(tmp.getString("type"))) continue;
                ids.add(tmp.getString("id"));
            }
            try {
                HashMap<String, Page> map = new HashMap<String, Page>();
                if (ids.size() > 0) {
                    List pages = pageService.getPageByIdsAndOrder(PortalContextUtil.getPortalContext((RenderRequest)request), ids.toArray(new String[0]), OrderEnum.ASC);
                    for (Page page : pages) {
                        map.put(page.getId(), page);
                    }
                }
                for (String item : items) {
                    JSONObject tmp = JSONObject.fromObject((Object)item);
                    QuickStartMenuDto dto = new QuickStartMenuDto();
                    dto.setType(tmp.getString("type"));
                    if (QuickStartTypeEnum.MENU.toString().equals(tmp.getString("type"))) {
                        Page page = (Page)map.get(tmp.getString("id"));
                        if (page == null) continue;
                        dto.setId(page.getId());
                        dto.setMenuID(page.getId());
                        ELinkNodeExt nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                        dto.setUrl(nodeExt.getUrl());
                        dto.setMenuName(page.getDisplayName());
                        dto.setPageType(page.getNodeType());
                        dto.setNodeExt(page.getNodeExt());
                        dto.setPermEditCtrl(page.getPermEditCtrl());
                        dto.setPicSrc("/portal/imgServlet?type=COMMON_IMG&id=" + page.getIcon());
                    } else {
                        dto.setMenuName(tmp.getString("menuName"));
                        dto.setPicSrc(tmp.getString("picSrc"));
                        dto.setUrl(tmp.getString("url"));
                    }
                    list.add(dto);
                }
            }
            catch (PortalBizException e) {
                throw new PortletException((Throwable)e);
            }
        }
        JSONArray fromObject = JSONArray.fromObject(list);
        ArrayList<Object> listNew = new ArrayList<Object>();
        for (int i = 0; i < fromObject.size(); ++i) {
            Object object = fromObject.get(i);
            listNew.add(object);
        }
        request.setAttribute("items", (Object)JSONUtil.getJson4List(listNew).toString());
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/biz/quickStart/QuickStart_view.jsp");
        dispatcher.include(request, response);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String list = request.getParameter("list");
        JSONArray menuItems = JSONArray.fromObject((Object)list);
        String[] items = new String[menuItems.size()];
        for (int i = 0; i < menuItems.size(); ++i) {
            JSONObject tmp = menuItems.getJSONObject(i);
            items[i] = tmp.toString();
        }
        PortletPreferences preferences = request.getPreferences();
        preferences.setValues("items", items);
        preferences.store();
    }
}

