/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.cloud.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class CloudCommunityAction
extends BaseAction {
    private static Logger logger = Logger.getLogger(CloudCommunityAction.class);
    public static final String SERVER_NAME = "http://api.kingdee.com";
    public static final String SEARCH_SERVER_NAME = "http://knowledge.kingdee.com";
    private static LicenseBaseInfo baseInfo = null;
    private static String ACCESS_TOKEN = "access_token";
    private static String CLOUD_COURSE = "/clouduser/course?";
    private static String CLOUD_ACTIVITY = "/clouduser/activity?";
    private static String CLOUD_KNOW = "/clouduser/knowledge?";
    private static String CLOUD_SEARCH = "/product/11/search?";
    private static int OTHER_TIMEOUT_MAX = 8000;
    private static int SEARCH_TIMEOUT_MAX = 8000;
    private static String CATEGORY_CODE = "C22";
    private static String SERIES_CODE = "S078";
    private static String SIZE = "6";
    private static String VISIT_SOUTCE = "QD020";
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private static int total_elements_count = 0;

    public void getCloudCourseData() {
        Map<String, String> params = this.createParams();
        params.put("size", SIZE);
        StringBuilder url = new StringBuilder();
        url.append(SERVER_NAME).append(CLOUD_COURSE).append(this.getQueryString(params));
        String stringResponse = this.getHttpResponseResult(url.toString(), OTHER_TIMEOUT_MAX);
        this.writeAjaxData(!"error".equalsIgnoreCase(stringResponse), null, stringResponse);
    }

    public void getCloudActivityData() {
        Map<String, String> params = this.createParams();
        params.put("isActivityCard", "1");
        params.put("status", "doing");
        params.put("pageSize", SIZE);
        params.put("image_size", "554*311");
        StringBuilder url = new StringBuilder();
        url.append(SERVER_NAME).append(CLOUD_ACTIVITY).append(this.getQueryString(params));
        String stringResponse = this.getHttpResponseResult(url.toString(), OTHER_TIMEOUT_MAX);
        this.writeAjaxData(!"error".equalsIgnoreCase(stringResponse), null, stringResponse);
    }

    public void getCloudKnowledgeData() {
        Map<String, String> params = this.createParams();
        params.put("size", SIZE);
        params.put("status", "doing");
        params.put("series_code", "");
        StringBuilder url = new StringBuilder();
        url.append(SERVER_NAME).append(CLOUD_KNOW).append(this.getQueryString(params));
        String stringResponse = this.getHttpResponseResult(url.toString(), OTHER_TIMEOUT_MAX);
        this.writeAjaxData(!"error".equalsIgnoreCase(stringResponse), null, stringResponse);
    }

    public void getKnowSearchResult() {
        Map<String, String> params = this.createParams();
        params.put("pageSize", "50");
        String pageId = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("pageId"));
        String pageNumber = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("pageNumber"));
        String requestType = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("requestType"));
        if (StringUtils.isEmpty((String)pageNumber)) {
            pageNumber = "1";
        }
        params.put("page", pageNumber);
        params.put("terminal", "H5");
        params.put("allowHtml", "true");
        params.put("location", "pageHelp");
        params.put("restrictIn", "fifthDegree");
        try {
            if (!StringUtils.isEmpty((String)pageId)) {
                String number = "";
                Page page = this.pageService.findPageById(this.getPortalContext(), pageId);
                if (page == null) {
                    if ("794be440-6c72-4de7-9ee2-4125795e3005".equals(pageId)) {
                        number = "PROCESSCENTER";
                    }
                } else if (NodeTypeEnum.EXTERNAL_LINK.equals((Object)page.getNodeType())) {
                    ELinkNodeExt nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                    String externalId = nodeExt == null ? "" : nodeExt.getExternalId();
                    String sql = "SELECT FNUMBER  FROM t_pm_mainmenuitem where  FId = '" + externalId + "'";
                    Context context = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
                    IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql);
                    if (rs != null && rs.next()) {
                        number = rs.getString("FNUMBER");
                    }
                } else {
                    number = page.getPageNumber();
                }
                params.put("fifthDegree", number);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder url = new StringBuilder();
        url.append(SEARCH_SERVER_NAME).append(CLOUD_SEARCH).append(this.getQueryString(params));
        logger.info((Object)("1****" + url));
        String stringResponse = this.getHttpResponseResult(url.toString(), SEARCH_TIMEOUT_MAX);
        if ("error".equalsIgnoreCase(stringResponse)) {
            this.writeAjaxData(false, null, stringResponse);
            return;
        }
        if ("getTotal".equalsIgnoreCase(requestType)) {
            total_elements_count = Integer.parseInt(JSON.parseObject((String)stringResponse).getString("totalElements"));
            this.writeAjaxData(true, null, stringResponse);
            return;
        }
        String isLast = JSON.parseObject((String)stringResponse).getString("last");
        int totalElements = Integer.parseInt(JSON.parseObject((String)stringResponse).getString("totalElements"));
        logger.info((Object)("****xjw*****totalElements:" + totalElements));
        logger.info((Object)("****xjw*****total_elements_count:" + total_elements_count));
        JSONObject obj = new JSONObject();
        obj.put("pageId", (Object)pageId);
        if (totalElements + 100 >= total_elements_count) {
            obj.put(pageNumber, (Object)stringResponse);
            this.writeAjaxData(true, null, obj);
            return;
        }
        obj.put(pageNumber, (Object)stringResponse);
        Integer pageNumberInt = Integer.parseInt(pageNumber);
        while ("false".equalsIgnoreCase(isLast)) {
            Integer n = pageNumberInt;
            Integer n2 = pageNumberInt = Integer.valueOf(pageNumberInt + 1);
            url = new StringBuilder();
            params.put("page", pageNumberInt.toString());
            url.append(SEARCH_SERVER_NAME).append(CLOUD_SEARCH).append(this.getQueryString(params));
            System.out.println("*****xjw**" + pageNumberInt + "****" + url);
            stringResponse = this.getHttpResponseResult(url.toString(), SEARCH_TIMEOUT_MAX);
            if ("error".equalsIgnoreCase(stringResponse)) {
                this.writeAjaxData(true, null, obj);
                return;
            }
            obj.put(pageNumberInt.toString(), (Object)stringResponse);
            isLast = JSON.parseObject((String)stringResponse).getString("last");
        }
        this.writeAjaxData(!"error".equalsIgnoreCase(stringResponse), null, obj);
    }

    public void getCloudCommunityAuthCode() {
        Context context = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        String uid = userInfo.getUid();
        try {
            JSONObject rs;
            String userAuthCode = "";
            if (!StringUtils.isEmpty((String)uid) && (rs = EasCloud.cloudErpAccessToken((String)uid, (String)(StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID()))) != null && rs.getIntValue("errcode") == 0) {
                String userAccessToken = rs.getJSONObject("data").getString(ACCESS_TOKEN);
                userAuthCode = EasCloud.getUserAuthCode((String)userAccessToken).getJSONObject("data").getString("auth_code");
            }
            this.writeAjaxData(!"".equalsIgnoreCase(userAuthCode), null, userAuthCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> createParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        try {
            Context context = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
            String uid = userInfo.getUid();
            LicenseBaseInfo licenseBaseInfo = baseInfo = baseInfo == null ? LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo() : baseInfo;
            if (!StringUtils.isEmpty((String)uid)) {
                params.put("uid", uid);
                JSONObject rs = EasCloud.cloudErpAccessToken((String)uid, (String)(StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID()));
                if (rs != null && rs.getIntValue("errcode") == 0) {
                    String userAccessToken = rs.getJSONObject("data").getString(ACCESS_TOKEN);
                    String userAuthCode = EasCloud.getUserAuthCode((String)userAccessToken).getJSONObject("data").getString("auth_code");
                    params.put(ACCESS_TOKEN, userAccessToken);
                    params.put("auth_code", userAuthCode);
                }
            }
            String prod_sn = StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum();
            String prod_version = baseInfo.getVersion();
            params.put("category_code", CATEGORY_CODE);
            params.put("series_code", SERIES_CODE);
            params.put("visit_source", VISIT_SOUTCE);
            params.put("prod_sn", prod_sn);
            params.put("prod_version", prod_version);
            params.put("client_id", EasCloud.CLIENT_ID);
            params.put("client_secret", EasCloud.CLIENT_SECRET);
        }
        catch (Exception e) {
            logger.error((Object)"createParams error !!!");
            e.printStackTrace();
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponseResult(String url, int maxTimeout) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(maxTimeout).setConnectionRequestTimeout(maxTimeout).setSocketTimeout(maxTimeout).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            String stringResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                httpGet.abort();
                logger.info((Object)MessageFormat.format("doExecuteHttpGet state fail url is {0},response content is{1},status code is{2}", url, stringResponse, httpResponse.getStatusLine().getStatusCode()));
                String string = "error";
                return string;
            }
            String string = stringResponse;
            return string;
        }
        catch (ConnectTimeoutException e) {
            logger.error((Object)"HTTP Connect  Timeout !!!");
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.info((Object)(" getHttpResponseResult " + url + " error!!!"));
            e.printStackTrace();
        }
        finally {
            httpGet.releaseConnection();
        }
        return "error";
    }

    private String getQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value != null && value.contains("+")) {
                value = value.replaceAll("\\+", "");
            }
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

