/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.page.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.ResTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.BizPageNodeExt;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.ViewTmplPreferences;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dto.AppCenterCacheDTO;
import com.kingdee.portal.biz.module.page.dto.MenuItemInfo;
import com.kingdee.portal.biz.module.page.dto.PageDTO;
import com.kingdee.portal.biz.module.page.entity.AppCenterCache;
import com.kingdee.portal.biz.module.page.entity.AppCenterMenuJson;
import com.kingdee.portal.biz.module.page.entity.AppCenterPersonal;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.AppCenterPersonalService;
import com.kingdee.portal.biz.module.page.service.AppCenterService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.page.service.PageSpacePersonalExtService;
import com.kingdee.portal.biz.module.perm.common.enums.PermTypeEnum;
import com.kingdee.portal.biz.module.perm.dto.EASRoleDTO;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.service.PermRefResService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.portal.biz.module.personal.service.PresetService;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PageAction
extends BaseAction {
    private static final long serialVersionUID = -5587441272318412930L;
    private PageDTO pageDto;
    private PermService permService = (PermService)PortalServiceLocator.getBean((String)"permService");
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
    private PageSpacePersonalExtService spaceExtService = (PageSpacePersonalExtService)PortalServiceLocator.getBean((String)"spaceExtService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private AppCenterService appCenterService = (AppCenterService)PortalServiceLocator.getBean((String)"appCenterService");
    private PresetService presetService = (PresetService)PortalServiceLocator.getBean((String)"presetService");
    private PersonalFavoriteService personalFavoriteService = (PersonalFavoriteService)PortalServiceLocator.getBean((String)"personalFavoriteService");
    private AppCenterPersonalService appCenterPersonalService = (AppCenterPersonalService)PortalServiceLocator.getBean((String)"appCenterPersonalService");
    private PermRefResService permRefResService = (PermRefResService)PortalServiceLocator.getBean((String)"permRefResService");
    private List<EASRoleDTO> easRoleList;
    private List<GroupDTO> groupList;
    private PermRefRes perm;

    public PermRefRes getPerm() {
        return this.perm;
    }

    public void setPerm(PermRefRes perm) {
        this.perm = perm;
    }

    public List<EASRoleDTO> getEasRoleList() {
        return this.easRoleList;
    }

    public void setEasRoleList(List<EASRoleDTO> easRoleList) {
        this.easRoleList = easRoleList;
    }

    public PageDTO getPageDto() {
        return this.pageDto;
    }

    public void setPageDto(PageDTO pageDto) {
        this.pageDto = pageDto;
    }

    public String nav() {
        return "success";
    }

    public String searchPageList() {
        JSONArray array = null;
        List<Object> pages = new ArrayList();
        try {
            pages = "0858ad87-d6d6-4916-bb3d-c776fd0a7e8a".equals(this.pageDto.getPage().getParentNodeId()) ? this.pageService.searchPlanList(this.getPortalContext(), this.pageDto.getPage().getDisplayName(), NodeTypeEnum.PLAN, this.pageDto.getPage().getStatus()) : this.execSearch(this.pageDto.getPage().getParentNodeId(), this.pageDto.getPage().getDisplayName(), this.pageDto.getPage().getNodeType());
            array = this.buildPageListArr(this.pageDto.getPage().getParentNodeId(), pages, true, "", "");
        }
        catch (PortalBizException e) {
            this.logger.error("\u83b7\u53d6\u9875\u7b7e\u6811\u6570\u636e\u51fa\u9519", (Throwable)e);
            array = new JSONArray();
        }
        this.writeData2Response(this.getResponse(), array.toString());
        return null;
    }

    private List<Page> execSearch(String rootId, String name, NodeTypeEnum t) throws PortalBizException {
        return this.pageService.searchPageList(this.getPortalContext(), rootId, name, t);
    }

    public String findPageList() {
        HttpServletRequest request = this.getRequest();
        String pageId = request.getParameter("id");
        String sourceId = request.getParameter("sourceId");
        String leafCanAddLeaf = request.getParameter("leafCanAddLeaf");
        String maxLevel = request.getParameter("maxLevel");
        JSONArray array = null;
        try {
            List pages = null;
            if ("0858ad87-d6d6-4916-bb3d-c776fd0a7e8a".equals(pageId)) {
                PagingResult result = this.pageService.findPageListByType(this.getPortalContext(), NodeTypeEnum.NEW_PAGE, new PagingParam(1, PagingParam.MAX_PAGE_SIZE));
                pages = result.getRecords();
                leafCanAddLeaf = "true";
                maxLevel = "100";
            } else {
                pages = this.getPageList(pageId, sourceId);
            }
            array = this.buildPageListArr(sourceId, pages, false, leafCanAddLeaf, maxLevel);
        }
        catch (PortalBizException e) {
            this.logger.error("\u83b7\u53d6\u9875\u7b7e\u6811\u6570\u636e\u51fa\u9519", (Throwable)e);
            array = new JSONArray();
        }
        this.writeData2Response(this.getResponse(), array.toString());
        return null;
    }

    public void findPageFolderLevel() {
        boolean success = true;
        LocalErr localErr = null;
        String pageId = this.getRequest().getParameter("id");
        String sourceId = this.getRequest().getParameter("sourceId");
        int count = 1;
        try {
            List<Page> pages = this.getPageList(pageId, sourceId);
            for (Page page : pages) {
                if (!(page.getNodeType().equals((Object)NodeTypeEnum.FOLDER) || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_G) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_OA) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false) && (!page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_SHR) || new ELinkNodeExt(page.getNodeExt()).getLeaf().booleanValue())) continue;
                ++count;
                break;
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, count);
    }

    private List<Page> getPageList(String parentId, String sourceId) throws PortalBizException {
        if (StringUtil.isEmpty((String)parentId)) {
            return this.getBaseNodeArr(sourceId);
        }
        Page page = this.pageService.findPageById(this.getPortalContext(), parentId);
        if (NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType())) {
            return this.pageService.findPageListByParentIdAndUserIds(this.getPortalContext(), parentId, new String[]{"portal_template_user"});
        }
        return this.pageService.findPageListByParentId(this.getPortalContext(), parentId);
    }

    private List<Page> getBaseNodeArr(String sourceId) throws PortalBizException {
        ArrayList<Page> pages = new ArrayList<Page>();
        Page page = this.pageService.findPageById(this.getPortalContext(), sourceId);
        pages.add(page);
        return pages;
    }

    private String getDefaultPageId(PortalContext ctx, String sourceId) throws PortalBizException {
        Page page = this.pageService.findPageById(this.getPortalContext(), sourceId);
        if (page == null) {
            return null;
        }
        return page.getDefaultPageId();
    }

    private JSONArray buildPageListArr(String sourceId, List<Page> pages, boolean isSearch, String leafCanAddLeaf, String maxLevel) throws PortalBizException {
        PortalContext ctx = this.getPortalContext();
        String defaultId = this.getDefaultPageId(ctx, sourceId);
        JSONArray array = new JSONArray();
        JSONObject treeNode = null;
        int size = pages.size();
        for (int i = 0; i < size; ++i) {
            Page page = pages.get(i);
            NodeTypeEnum t = page.getNodeType();
            treeNode = new JSONObject();
            treeNode.put((Object)"id", (Object)page.getId());
            if (!isSearch) {
                int iMaxLevel = 0;
                if (!StringUtil.isEmpty((String)maxLevel)) {
                    iMaxLevel = Integer.parseInt(maxLevel);
                }
                boolean isParent = true;
                if (iMaxLevel < page.getNodeLevel()) {
                    isParent = false;
                }
                if (leafCanAddLeaf != null && leafCanAddLeaf.equals("true")) {
                    treeNode.put((Object)"isParent", (Object)isParent);
                } else {
                    treeNode.put((Object)"isParent", (Object)this.isParentNode(t, page.getNodeExt()));
                }
                treeNode.put((Object)"pId", (Object)page.getParentNodeId());
            }
            treeNode.put((Object)"name", (Object)this.getFinalDisplayName(ctx, defaultId, page));
            treeNode.put((Object)"open", (Object)false);
            treeNode.put((Object)"t", (Object)t);
            treeNode.put((Object)"icon", (Object)this.getIconByType(t));
            treeNode.put((Object)"isLeaf", (Object)this.getIsLeaf(t, page.getNodeExt()));
            array.add((Object)treeNode);
        }
        return array;
    }

    private boolean getIsLeaf(NodeTypeEnum nt, String nodeExt) {
        boolean isLeaf = false;
        if (nt.equals((Object)NodeTypeEnum.PAGE) || nt.equals((Object)NodeTypeEnum.LINK) || nt.equals((Object)NodeTypeEnum.EXTERNAL_LINK) && new ELinkNodeExt(nodeExt).getLeaf() == true || nt.equals((Object)NodeTypeEnum.EXTERNAL_LINK_G) && new ELinkNodeExt(nodeExt).getLeaf() == true || nt.equals((Object)NodeTypeEnum.EXTERNAL_LINK_OA) && new ELinkNodeExt(nodeExt).getLeaf() == true || nt.equals((Object)NodeTypeEnum.EXTERNAL_LINK_SHR) && new ELinkNodeExt(nodeExt).getLeaf().booleanValue()) {
            isLeaf = true;
        }
        return isLeaf;
    }

    private String getFinalDisplayName(PortalContext ctx, String defaultId, Page page) throws PortalBizException {
        String name = this.getLocaleDisplayName(ctx.getLocale().toString(), page.getDisplayName());
        StringBuilder str = new StringBuilder(name);
        if (!StringUtil.isEmpty((String)defaultId) && defaultId.equals(page.getId())) {
            str.append("(").append(this.i18nService.getText(ctx, "res.portal.i18n.page.nav.Nav", "Nav.label.defaultopen"));
            str.append(")");
        }
        return str.toString();
    }

    private String getIconByType(NodeTypeEnum t) {
        String iconName = "page.gif";
        switch (t) {
            case PAGE: {
                iconName = "page.gif";
                break;
            }
            case SPACE: 
            case BIZ_PAGE: 
            case SYS_NAV: 
            case FOLDER: {
                iconName = "folder_Open.gif";
                break;
            }
            case EXTERNAL_LINK: 
            case EXTERNAL_LINK_G: 
            case EXTERNAL_LINK_OA: {
                iconName = "icon_menu.png";
                break;
            }
            case EXTERNAL_LINK_SHR: {
                iconName = "icon_menu.png";
                break;
            }
            case LINK: {
                iconName = "icon_link.png";
            }
        }
        return "/portal/res/img/ui/ztree/" + iconName;
    }

    private boolean isParentNode(NodeTypeEnum nodeType, String ext) {
        ELinkNodeExt t;
        if (NodeTypeEnum.PAGE.equals((Object)nodeType) || NodeTypeEnum.LINK.equals((Object)nodeType) || NodeTypeEnum.NEW_PAGE.equals((Object)nodeType) || NodeTypeEnum.PLAN.equals((Object)nodeType)) {
            return false;
        }
        if ((NodeTypeEnum.EXTERNAL_LINK.equals((Object)nodeType) || NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)nodeType) || NodeTypeEnum.EXTERNAL_LINK_OA.equals((Object)nodeType) || NodeTypeEnum.EXTERNAL_LINK_SHR.equals((Object)nodeType)) && (t = new ELinkNodeExt(ext)).getLeaf() != null) {
            return t.getLeaf() == false;
        }
        return true;
    }

    private String getLocaleDisplayName(String locale, String displayName) {
        DisplayName dn = new DisplayName(displayName, locale);
        return dn.getLocaleText();
    }

    public String savePage() {
        Page page = this.pageDto.getPage();
        boolean succ = false;
        LocalErr localErr = null;
        if (page.getNodeType().equals((Object)NodeTypeEnum.SPACE) && !this.pageService.checkDisplayName(page)) {
            succ = true;
            this.writeAjaxData(succ, localErr, "nameHasExisted");
            return null;
        }
        String viewTmpl = this.getRequest().getParameter("viewTmpl");
        String mutiTab = this.getRequest().getParameter("mutiTab");
        String showPath = this.getRequest().getParameter("showPath");
        if (viewTmpl != null) {
            String leafCanAddLeaf = this.getRequest().getParameter("leafCanAddLeaf");
            ViewTmplPreferences pre = new ViewTmplPreferences();
            boolean muti = false;
            boolean spath = false;
            if (mutiTab != null && mutiTab.equals("true")) {
                muti = true;
            }
            if (showPath != null && showPath.equals("true")) {
                spath = true;
            }
            pre.setViewTmpl(viewTmpl);
            pre.setMutiTab(Boolean.valueOf(muti));
            pre.setShowPath(Boolean.valueOf(spath));
            boolean addLeaf = false;
            if (leafCanAddLeaf != null && leafCanAddLeaf.equals("true")) {
                addLeaf = true;
            }
            pre.setLeafCanAddLeaf(Boolean.valueOf(addLeaf));
            String description = FilterSpecialCharactersTool.cleanXSS((String)page.getDescription());
            page.setDescription(description);
            page.setPreferences(pre.toString());
        }
        try {
            if (StringUtil.isEmpty((String)page.getId())) {
                if (NodeTypeEnum.BIZ_PAGE.equals((Object)page.getNodeType())) {
                    page.setStatus(StatusEnum.ENABLE);
                }
                page = this.pageService.createPage(this.getPortalContext(), this.pageDto);
            } else {
                page = this.pageService.updatePage(this.getPortalContext(), this.pageDto);
            }
            succ = true;
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(succ, localErr, page.getId());
        return null;
    }

    public String renamePage() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.pageService.renamePage(this.getPortalContext(), this.pageDto.getPage());
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String removePage() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.pageService.deletePageById(this.getPortalContext(), this.pageDto.getPage().getId(), this.pageDto.getPage().getSettingInfo());
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String preAddPage() {
        HttpServletRequest request = this.getRequest();
        request.setAttribute("folderInfo", (Object)this.folderInfo(this.pageDto.getSource(), this.pageDto.getPage()));
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        request.setAttribute("hasLicence", (Object)PortalCache.getLicenseFlag((Context)ctx));
        this.reSetPageParams(this.pageDto);
        return "success";
    }

    private String folderInfo(String source, Page page) {
        int maxLevel = 2;
        if (!StringUtil.isEmpty((String)page.getPreferences())) {
            maxLevel = Integer.parseInt(page.getPreferences()) - 1;
        }
        if (this.isLevelUnExpected(maxLevel, page)) {
            ++maxLevel;
            try {
                String sup = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.page.nav.Nav", "Nav.label.supt");
                String dires = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.page.nav.Nav", "Nav.label.dires");
                return sup + maxLevel + " " + dires;
            }
            catch (PortalBizException e) {
                this.logger.error("\u83b7\u53d6i18n\u8d44\u6e90\u6587\u4ef6\u9519\u8bef");
            }
        }
        return null;
    }

    private boolean isLevelUnExpected(int level, Page page) {
        return page.getNodeLevel() >= level;
    }

    private void reSetPageParams(PageDTO pageDto) {
        Page selectPage = pageDto.getPage();
        Page page = new Page();
        page.setParentNodeId(selectPage.getId());
        page.setNodeLevel(selectPage.getNodeLevel());
        pageDto.setPage(page);
    }

    public String findPage() {
        Page page = null;
        try {
            page = this.getPageObj(this.pageDto.getPage());
            if (StringUtil.isEmpty((String)page.getId())) {
                page.setPageNumber(PageHelper.generatePageNumber());
            }
            String description = page.getDescription();
            page.setDescription(FilterSpecialCharactersTool.cleanXSS((String)description));
            this.pageDto.setPage(page);
            if (StringUtil.isEmpty((String)this.pageDto.getParentNodeName())) {
                PortletDefinition portletDefinition;
                Page parent = this.pageService.findPageById(this.getPortalContext(), page.getParentNodeId());
                DisplayName name = new DisplayName(parent.getDisplayName(), this.getPortalContext().getLocale().toString());
                this.pageDto.setParentNodeName(name.getLocaleText());
                if (page.getId() != null && (portletDefinition = this.portletDefinitionService.findPltByPageId(this.getPortalContext(), page.getId())) != null) {
                    this.pageDto.setCategoryId(portletDefinition.getCategoryId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            return "error";
        }
        return this.getNodeTypeStr(page);
    }

    private String getNodeTypeStr(Page page) {
        NodeTypeEnum t = page.getNodeType();
        if (StringUtil.isEmpty((String)page.getId()) && (t == NodeTypeEnum.EXTERNAL_LINK || t == NodeTypeEnum.EXTERNAL_LINK_G || t == NodeTypeEnum.EXTERNAL_LINK_OA || t == NodeTypeEnum.EXTERNAL_LINK_SHR)) {
            return "external_link_import";
        }
        return t.toString().toLowerCase();
    }

    private Page getPageObj(Page page) throws PortalBizException {
        if (StringUtil.isEmpty((String)page.getId())) {
            return this.buildDefaultPage(page);
        }
        return this.pageService.findPageById(this.getPortalContext(), page.getId());
    }

    private Page buildDefaultPage(Page page) {
        this.setDefaultPermCtrl(page);
        this.setDefaultParentId(page);
        this.setDefaultNodeExt(page);
        page.setStatus(StatusEnum.ENABLE);
        return page;
    }

    private void setDefaultPermCtrl(Page page) {
        switch (page.getNodeType()) {
            case PAGE: {
                page.setPermViewCtrl(Boolean.valueOf(false));
                page.setPermEditCtrl(Boolean.valueOf(true));
                break;
            }
            default: {
                page.setPermViewCtrl(Boolean.valueOf(false));
                page.setPermEditCtrl(Boolean.valueOf(false));
            }
        }
    }

    private void setDefaultParentId(Page page) {
        if (page.getNodeType() == NodeTypeEnum.BIZ_PAGE || page.getNodeType() == NodeTypeEnum.SPACE) {
            page.setParentNodeId("2f9ef722-255b-4e4b-8d07-5277e353a321");
        }
    }

    private void setDefaultNodeExt(Page page) {
        if (page.getNodeType() == NodeTypeEnum.LINK) {
            page.setNodeExt(new LinkNodeExt().toString());
        } else if (page.getNodeType() == NodeTypeEnum.BIZ_PAGE) {
            page.setNodeExt(new BizPageNodeExt().toString());
        }
    }

    private void writeData2Response(HttpServletResponse response, String data) {
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public void sortPages() {
        HttpServletRequest request = this.getRequest();
        String pageId = request.getParameter("pageId");
        String parentId = request.getParameter("parentId");
        String sortIds = request.getParameter("sortIds");
        try {
            if (StringUtil.isEmpty((String)sortIds)) {
                this.movePage1(pageId, parentId, null);
            } else {
                this.movePage1(pageId, parentId, sortIds.split(","));
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        this.writeAjaxData(true, null, null);
    }

    private void movePage1(String pageId, String parentId, String[] sorts) throws PortalBizException {
        this.pageService.movePage(this.getPortalContext(), pageId, parentId, sorts);
    }

    public String findExternalLinkList() {
        HttpServletRequest request = this.getRequest();
        if (FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)request)) {
            this.logger.error("exists SQL SpecialCharacters !!!");
            return null;
        }
        String parentLevel = request.getParameter("bizLevel");
        String type = request.getParameter("type");
        String isSys = request.getParameter("isSys");
        String longnumber = request.getParameter("longnumber");
        int level = 0;
        if (!StringUtil.isEmpty((String)parentLevel)) {
            level = Integer.parseInt(parentLevel);
        }
        String result = "";
        try {
            List list = this.easService.getExternalLinkList(this.getPortalContext(), NodeTypeEnum.valueOf((String)type), longnumber, level, Boolean.valueOf(isSys).booleanValue());
            result = this.buildExternalLinkStr(list);
        }
        catch (Exception e1) {
            this.logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u6570\u636e\u51fa\u9519", (Throwable)e1);
        }
        this.writeData2Response(this.getResponse(), result);
        return null;
    }

    private String buildExternalLinkStr(List<MenuItemInfo> list) throws UnsupportedEncodingException {
        JSONArray array = new JSONArray();
        for (MenuItemInfo info : list) {
            JSONObject treeNode = new JSONObject();
            treeNode.put((Object)"id", (Object)info.getId());
            treeNode.put((Object)"name", (Object)info.getName());
            treeNode.put((Object)"pId", (Object)info.getParentId());
            treeNode.put((Object)"link", (Object)info.getUiClassName());
            treeNode.put((Object)"longnumber", (Object)info.getLongNumber());
            treeNode.put((Object)"isLeaf", (Object)info.isLeaf());
            treeNode.put((Object)"isParent", (Object)(!info.isLeaf() ? 1 : 0));
            treeNode.put((Object)"bizLevel", (Object)info.getLevel());
            array.add((Object)treeNode);
        }
        return array.toString();
    }

    public String createExternalLink() {
        HttpServletRequest request = this.getRequest();
        if (FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)request)) {
            this.logger.error("exists SQL SpecialCharacters !!!");
            return null;
        }
        boolean succ = true;
        LocalErr localErr = null;
        Page page = null;
        try {
            page = this.pageService.importExternalLink(this.getPortalContext(), this.pageDto.getSource(), this.pageDto.getPage(), this.pageDto.getElink());
        }
        catch (PortalBizException pe) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)pe));
            page = new Page();
            this.logger.error("importExternalLink  error===== " + (Object)((Object)pe));
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
            page = new Page();
            this.logger.error("importExternalLink  error===== " + e);
        }
        this.writeAjaxData(succ, localErr, page.getId());
        return null;
    }

    public String setDefault() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.pageService.setDefault(this.getPortalContext(), this.pageDto.getPage());
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String findBizPageList() {
        PagingResult pagingResult;
        try {
            pagingResult = this.pageService.findPageDTOListByType(this.getPortalContext(), NodeTypeEnum.BIZ_PAGE, this.pagingParam);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5bfc\u822a\u6570\u636e\u51fa\u9519", (Throwable)e);
            pagingResult = new PagingResult();
        }
        this.writePagingResult(pagingResult);
        return null;
    }

    public void getBizPageData() {
        String pageId = this.getRequest().getParameter("pageId");
        String getBizType = this.getRequest().getParameter("getBizType");
        boolean success = false;
        LocalErr localErr = null;
        String bizPages = "";
        List pages = null;
        try {
            pages = this.pageService.findBizPageList(this.getPortalContext(), pageId, this.getPermMap());
            Page page = this.pageService.findPageById(this.getPortalContext(), pageId);
            String defaultPageId = "";
            if (page != null) {
                defaultPageId = page.getDefaultPageId();
            }
            bizPages = this.getJSON4BizPage(pages, defaultPageId, getBizType);
            success = true;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5bfc\u822a\u914d\u7f6e\u8282\u70b9\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(success, localErr, bizPages);
    }

    private List<Page> removeEmptyNode(List<Page> pages) {
        ArrayList<Page> list = new ArrayList<Page>();
        block0: for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            String id = page.getId();
            if (page.getNodeType().toString().equals("FOLDER")) {
                for (int j = 0; j < pages.size(); ++j) {
                    Page page_ = pages.get(j);
                    if (!id.equals(page_.getParentNodeId())) continue;
                    list.add(page);
                    continue block0;
                }
                continue;
            }
            if (page.getNodeType().toString().equals("EXTERNAL_LINK")) {
                String nodeExt = page.getNodeExt();
                JSONObject nodeExtObj = JSONObject.fromObject((Object)nodeExt);
                Object leaf = nodeExtObj.get("leaf");
                boolean isLeaf = false;
                if (leaf instanceof Boolean) {
                    isLeaf = (Boolean)leaf;
                } else if (leaf instanceof String) {
                    isLeaf = Boolean.valueOf((String)leaf);
                }
                if (!isLeaf) {
                    for (int j = 0; j < pages.size(); ++j) {
                        Page page_ = pages.get(j);
                        if (!id.equals(page_.getParentNodeId())) continue;
                        list.add(page);
                        continue block0;
                    }
                    continue;
                }
                list.add(page);
                continue;
            }
            list.add(page);
        }
        return list;
    }

    private String getJSON4BizPage(List<Page> pages, String defaultPageId, String getBizType) {
        String locale = this.getPortalContext().getLocale().toString();
        JSONArray arr = new JSONArray();
        JSONObject obj = null;
        List<Page> newPages = new ArrayList<Page>();
        newPages.addAll(pages);
        for (int j = 0; j < 3; ++j) {
            newPages = this.removeEmptyNode(newPages);
        }
        for (int i = 0; i < newPages.size(); ++i) {
            Page page = newPages.get(i);
            obj = new JSONObject();
            obj.put((Object)"id", (Object)page.getId());
            obj.put((Object)"pId", (Object)page.getParentNodeId());
            obj.put((Object)"t", (Object)page.getNodeType().toString());
            obj.put((Object)"nodeExt", (Object)page.getNodeExt());
            obj.put((Object)"name", (Object)this.getLocaleDisplayName(locale, page.getDisplayName()));
            obj.put((Object)"permEditCtrl", (Object)page.getPermEditCtrl());
            if (i == 0) {
                obj.put((Object)"defaultPageId", (Object)defaultPageId);
            }
            obj.put((Object)"pathInfo", (Object)page.getNodePath());
            if (getBizType != null && getBizType.equals("tree")) {
                obj.put((Object)"icon", (Object)this.getIconByType(page.getNodeType()));
            } else {
                obj.put((Object)"icon", (Object)page.getIcon());
            }
            obj.put((Object)"preferences", (Object)page.getPreferences());
            arr.add((Object)obj);
        }
        return arr.toString();
    }

    public void getAppCenterData() {
        boolean success = false;
        LocalErr localErr = null;
        AppCenterCache appcenterCache = null;
        AppCenterCacheDTO appCenterCacheDTO = new AppCenterCacheDTO();
        try {
            Context context = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            String lang = context.getLocale().toString();
            appcenterCache = this.appCenterService.getAppCenterData(this.getPortalContext());
            if (lang.equals("l1")) {
                appCenterCacheDTO.setTreeContent(new String(appcenterCache.getTreeContentL1()));
            } else if (lang.equals("l3")) {
                appCenterCacheDTO.setTreeContent(new String(appcenterCache.getTreeContentL3()));
            } else {
                appCenterCacheDTO.setTreeContent(new String(appcenterCache.getTreeContentL2()));
            }
            appCenterCacheDTO.setOneToTwoMenuId(new String(appcenterCache.getOneToTowMemuId()));
            appCenterCacheDTO.setTwoToThreeMemuId(new String(appcenterCache.getTwoToThreeMemuId()));
            appCenterCacheDTO.setTreeToFourMemuId(new String(appcenterCache.getTreeToFourMemuId()));
            success = true;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5bfc\u822a\u914d\u7f6e\u8282\u70b9\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(success, localErr, appCenterCacheDTO);
    }

    public String getMenuManager() {
        try {
            HttpServletRequest request = this.getRequest();
            String type = request.getParameter("type");
            if ("class".equalsIgnoreCase(type)) {
                return "class";
            }
            if ("addMenu".equalsIgnoreCase(type)) {
                return "menuManager";
            }
            if ("menuEdit".equalsIgnoreCase(type)) {
                String pageId = request.getParameter("pageId");
                Page page = this.pageService.findPageById(this.getPortalContext(), pageId);
                this.pageDto.setPage(page);
                this.perm.setPermInfo("VIEW");
                Map member = this.permRefResService.findAuthorizeByPageId(this.getPortalContext(), this.perm);
                StringBuilder permIds = new StringBuilder();
                StringBuilder names = new StringBuilder();
                this.easRoleList = (List)member.get("easRoleList");
                for (EASRoleDTO role : this.easRoleList) {
                    permIds.append(role.getId()).append(",");
                    names.append(role.getName()).append(",");
                }
                String permIdsStr = "";
                String namesStr = "";
                if (permIds.toString().length() > 1) {
                    permIdsStr = permIds.toString().substring(0, permIds.length() - 1);
                    namesStr = names.toString().substring(0, names.length() - 1);
                }
                request.setAttribute("role_permIds", (Object)permIdsStr);
                request.setAttribute("role_names", (Object)namesStr);
                this.groupList = (List)member.get("groupList");
                permIds = new StringBuilder();
                names = new StringBuilder();
                for (GroupDTO group : this.groupList) {
                    permIds.append(group.getId()).append(",");
                    names.append(group.getName()).append(",");
                }
                if (permIds.toString().length() > 1) {
                    permIdsStr = permIds.toString().substring(0, permIds.length() - 1);
                    namesStr = names.toString().substring(0, names.length() - 1);
                }
                request.setAttribute("org_permIds", (Object)permIdsStr);
                request.setAttribute("org_names", (Object)namesStr);
                return "menuManager";
            }
            if ("classEdit".equalsIgnoreCase(type) || "classAdd".equalsIgnoreCase(type)) {
                return "classManager";
            }
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void getPageCenterClass() {
        try {
            List classList = this.pageService.findPageListByParentId(this.getPortalContext(), "793e3c69-d245-4fa1-ac95-df9bd30586e3");
            this.writeAjaxData(true, null, classList);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void getSwitchClassList() {
        try {
            List pageList = this.pageService.findPageListByParentId(this.getPortalContext(), "793e3c69-d245-4fa1-ac95-df9bd30586e3");
            int total = pageList.size();
            String inputValue = null;
            List classList = this.pageService.findClassListByPagingParam(this.getPortalContext(), this.pagingParam, pageList, inputValue);
            PagingResult pagingResult = new PagingResult();
            pagingResult.setRecords(classList);
            pagingResult.setTotalCount(total);
            pagingResult.setPagingParam(this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void getAppCenterTree() {
        AppCenterCache appcenterCache = this.appCenterService.getAppCenterData(this.getPortalContext());
        try {
            String appcenterTreeJson = new String(appcenterCache.getAppcenterTree());
            List favMenuList = this.personalFavoriteService.findPersonalFavoriteList(this.getPortalContext(), this.getPermMap());
            JSONObject obj = new JSONObject();
            obj.put((Object)"pageList", (Object)appcenterTreeJson);
            obj.put((Object)"favList", (Object)favMenuList);
            this.writeAjaxData(true, null, obj);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void getThirdAndForthPages() {
        AppCenterMenuJson appcenterMenuJson;
        Context context = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        String secondMenuID = this.getRequest().getParameter("secondMenuID");
        secondMenuID = this.pageService.findMenuIDByNewPageID(context, secondMenuID);
        AppCenterCache appcenterCache = this.appCenterService.getAppCenterData(this.getPortalContext());
        String twoToThreeMemuId = new String(appcenterCache.getTwoToThreeMemuId());
        String threeToFourMemuId = new String(appcenterCache.getTreeToFourMemuId());
        JSONArray twoToThreeMemuIdArray = JSONArray.fromObject((Object)twoToThreeMemuId);
        JSONArray threeToFourMemuIdArray = JSONArray.fromObject((Object)threeToFourMemuId);
        List thirdPageIds = new LinkedList();
        LinkedList firthPageIds = new LinkedList();
        for (Object object : twoToThreeMemuIdArray) {
            JSONObject twoToThreeObject = JSONObject.fromObject(object);
            appcenterMenuJson = (AppCenterMenuJson)JSONUtil.getObject4Json((String)twoToThreeObject.toString(), AppCenterMenuJson.class);
            if (!appcenterMenuJson.getMenuId().equalsIgnoreCase(secondMenuID)) continue;
            thirdPageIds = appcenterMenuJson.getSubMenuId();
            break;
        }
        int flag = 0;
        for (Object object : threeToFourMemuIdArray) {
            JSONObject threeToFourObject = JSONObject.fromObject(object);
            appcenterMenuJson = (AppCenterMenuJson)JSONUtil.getObject4Json((String)threeToFourObject.toString(), AppCenterMenuJson.class);
            if (thirdPageIds.contains(appcenterMenuJson.getMenuId())) {
                firthPageIds.addAll(appcenterMenuJson.getSubMenuId());
                ++flag;
            }
            if (thirdPageIds.size() > flag) continue;
            break;
        }
        firthPageIds.addAll(thirdPageIds);
        try {
            List pageList = this.pageService.getPageByIdsAndOrder(this.getPortalContext(), firthPageIds.toArray(new String[firthPageIds.size()]), OrderEnum.ASC);
            JSONObject obj = new JSONObject();
            obj.put((Object)"pageList", (Object)pageList);
            this.writeAjaxData(true, null, obj);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void createNewPageCenter() {
        HttpServletRequest request = this.getRequest();
        String displayName = request.getParameter("displayName");
        String description = request.getParameter("description");
        String parentNodeId = request.getParameter("parentId");
        Page page = new Page();
        page.setDisplayName(displayName);
        page.setDescription(description);
        page.setParentNodeId(parentNodeId);
        this.pageService.saveNewPageCenter(this.getPortalContext(), page);
    }

    public void getFirstAndSecondPages() {
        try {
            boolean isAdminAppCenter;
            List resultList = new ArrayList();
            boolean isPersonalAppCenter = this.appCenterPersonalService.getIsPersonalAppCenter(this.getPortalContext());
            if (isPersonalAppCenter) {
                resultList = this.appCenterPersonalService.getPageByIdsAndOrder(this.getPortalContext(), "personal", OrderEnum.ASC);
            }
            if ((resultList == null || resultList.size() == 0) && (isAdminAppCenter = this.appCenterPersonalService.getIsAdminAppCenter(this.getPortalContext()))) {
                resultList = this.appCenterPersonalService.getPageByIdsAndOrder(this.getPortalContext(), "admin", OrderEnum.ASC);
            }
            if (resultList == null || resultList.size() == 0) {
                String classId = "";
                List pageClassList = this.pageService.findPageCenterList(this.getPortalContext(), 3);
                List newPageList = this.pageService.findPageCenterList(this.getPortalContext(), 4);
                for (Page pageClass : pageClassList) {
                    ArrayList<Page> pageList = new ArrayList<Page>();
                    classId = pageClass.getId();
                    for (Page page : newPageList) {
                        if (!classId.equalsIgnoreCase(page.getParentNodeId())) continue;
                        pageList.add(page);
                    }
                    if (pageList.size() <= 0) continue;
                    pageList.add(0, pageClass);
                    resultList.add(pageList);
                }
            }
            this.writeAjaxData(true, null, resultList);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void resetAppcenterPersonal() {
        this.appCenterPersonalService.deleteAppcenterPersonalByUserID(this.getPortalContext());
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(this.getPortalContext().getLoginUser().getId())) {
            this.pageService.deleteNotSysPortalPages(this.getPortalContext());
        }
        this.writeAjaxData(true, null, null);
    }

    public void saveAppcenterPersonal() {
        ArrayList<AppCenterPersonal> arrayList = new ArrayList<AppCenterPersonal>();
        String parameter = this.getRequest().getParameter("pageInfo");
        JSONArray pageInfo = JSONArray.fromObject((Object)parameter);
        String pageId = "";
        String parentId = "";
        String icon = "";
        String pageNumber = "";
        HashMap<String, String> classIdsMap = new HashMap<String, String>();
        Page pageTemp = new Page();
        try {
            for (Object pagePersonal : pageInfo) {
                JSONObject pageObject = JSONObject.fromObject(pagePersonal);
                AppCenterPersonal appCenterPersonal = new AppCenterPersonal();
                String name = pageObject.get("name").toString();
                String description = pageObject.get("description").toString();
                pageId = pageObject.get("pageID").toString();
                parentId = pageObject.get("nodeParentID").toString();
                pageNumber = pageObject.get("pageNumber") == null ? "" : pageObject.get("pageNumber").toString();
                String string = icon = pageObject.get("icon") == null ? "" : pageObject.get("icon").toString();
                if (pageId.contains("temp_firstmenu_id")) {
                    pageTemp.setDisplayName(name);
                    pageTemp.setDescription(description);
                    pageTemp.setParentNodeId("793e3c69-d245-4fa1-ac95-df9bd30586e3");
                    pageTemp.setPageNumber(pageObject.get("pageNumber").toString());
                    pageId = this.pageService.saveNewPageCenterClass(this.getPortalContext(), pageTemp);
                    classIdsMap.put(pageObject.get("pageNumber").toString(), pageId);
                }
                String permIds = "";
                PermRefRes perm = new PermRefRes();
                perm.setPermInfo("VIEW");
                perm.setSourceType("PAGE");
                perm.setResType(ResTypeEnum.NEW_PAGE);
                if ("temp_id".equalsIgnoreCase(pageId)) {
                    if (parentId.contains("temp_firstmenu_id")) {
                        String[] split = parentId.split("temp_firstmenu_id");
                        parentId = (String)classIdsMap.get(split[1]);
                    }
                    pageTemp.setParentNodeId(parentId);
                    pageTemp.setDisplayName(name);
                    pageTemp.setDescription(description);
                    pageTemp.setIcon(icon);
                    pageId = this.pageService.saveNewPageCenter(this.getPortalContext(), pageTemp);
                    permIds = pageObject.get("role_permIds").toString();
                    perm.setResId(pageId);
                    perm.setPermType(PermTypeEnum.EAS_ROLE);
                    this.permRefResService.batchCreatePermRefRes(this.getPortalContext(), perm, permIds.split(","), new String[0]);
                    permIds = pageObject.get("org_permIds").toString();
                    perm.setPermType(PermTypeEnum.GROUP);
                    this.permRefResService.batchCreatePermRefRes(this.getPortalContext(), perm, permIds.split(","), new String[0]);
                } else if (pageObject.get("role_permIds") != null) {
                    perm.setResId(pageId);
                    perm.setPermType(PermTypeEnum.EAS_ROLE);
                    this.permRefResService.delPermRefResAll(this.getPortalContext(), perm);
                    permIds = pageObject.get("role_permIds").toString();
                    this.permRefResService.batchCreatePermRefRes(this.getPortalContext(), perm, permIds.split(","), new String[0]);
                } else if (pageObject.get("org_permIds") != null) {
                    perm.setResId(pageId);
                    perm.setPermType(PermTypeEnum.GROUP);
                    this.permRefResService.delPermRefResAll(this.getPortalContext(), perm);
                    permIds = pageObject.get("org_permIds").toString();
                    this.permRefResService.batchCreatePermRefRes(this.getPortalContext(), perm, permIds.split(","), new String[0]);
                }
                appCenterPersonal.setPageID(pageId);
                appCenterPersonal.setDisplayName(name);
                appCenterPersonal.setDescription(description);
                appCenterPersonal.setIcon(icon);
                appCenterPersonal.setPageNumber(pageNumber);
                appCenterPersonal.setUserId(this.getPortalContext().getLoginUser().getId());
                appCenterPersonal.setNodeOrder((Integer)pageObject.get("nodeOrder"));
                appCenterPersonal.setParentNodeId(parentId);
                appCenterPersonal.setNodeLevel((Integer)pageObject.get("nodeLevel"));
                arrayList.add(appCenterPersonal);
            }
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
        this.appCenterPersonalService.saveAppCenterPersonalPages(arrayList);
    }

    public void getFavAndRightPage() {
        try {
            String subMenuIds = this.getRequest().getParameter("subMenuIds");
            if (!StringUtil.isEmpty((String)subMenuIds)) {
                String[] menuIds = subMenuIds.split(";");
                List pageList = this.pageService.getPageByIdsAndOrder(this.getPortalContext(), menuIds, OrderEnum.ASC);
                this.presetService.configPresetFav(this.getPortalContext(), this.getPermMap(), "function");
                List list = this.personalFavoriteService.findPersonalFavoriteList(this.getPortalContext(), this.getPermMap());
                JSONObject obj = new JSONObject();
                obj.put((Object)"pageList", (Object)pageList);
                obj.put((Object)"favList", (Object)list);
                this.writeAjaxData(true, null, obj);
            } else {
                this.writeAjaxData(false, this.handleErr(new Exception("subMenuIds is empty!")), null);
            }
        }
        catch (PortalBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    private List<Map> getList4AppPage(List<Page> pages) {
        ArrayList<Map> _pages = new ArrayList<Map>();
        for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("parentNodeId", page.getParentNodeId());
            p.put("id", page.getId());
            p.put("nodeType", page.getNodeType());
            p.put("nodeExt", page.getNodeExt());
            p.put("displayName", page.getDisplayName());
            p.put("permEditCtrl", page.getPermEditCtrl());
            p.put("icon", page.getIcon());
            p.put("preferences", page.getPreferences());
            p.put("nodeLevel", page.getNodeLevel());
            _pages.add(p);
        }
        return _pages;
    }

    private Map<String, List<Map>> buildAppForthLevelMenu(List<Map> pages) {
        List firstLevelMenu = new ArrayList<Map>();
        List<Map> secondLevelMenu = new ArrayList();
        List<Map> thirdLevelMenu = new ArrayList();
        ArrayList<Map> forthLevelMenu = new ArrayList<Map>();
        block6: for (int i = 0; i < pages.size(); ++i) {
            Map page = pages.get(i);
            switch ((Integer)page.get("nodeLevel")) {
                case 2: {
                    firstLevelMenu.add(page);
                    continue block6;
                }
                case 3: {
                    secondLevelMenu.add(page);
                    continue block6;
                }
                case 4: {
                    thirdLevelMenu.add(page);
                    continue block6;
                }
                case 5: {
                    forthLevelMenu.add(page);
                }
            }
        }
        thirdLevelMenu = this.markDisplayForThirdMenu(thirdLevelMenu, forthLevelMenu);
        secondLevelMenu = this.markDisplay(secondLevelMenu, thirdLevelMenu);
        firstLevelMenu = this.markDisplay(firstLevelMenu, secondLevelMenu);
        HashMap<String, List<Map>> appCenterMenu = new HashMap<String, List<Map>>();
        appCenterMenu.put("firstLevelMenu", firstLevelMenu);
        appCenterMenu.put("secondLevelMenu", secondLevelMenu);
        appCenterMenu.put("thirdLevelMenu", thirdLevelMenu);
        appCenterMenu.put("forthLevelMenu", forthLevelMenu);
        return appCenterMenu;
    }

    private List markDisplay(List list, List subList) {
        block0: for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String firstId = (String)map.get("id");
            for (int j = 0; j < subList.size(); ++j) {
                Map subMap = (Map)subList.get(j);
                String subId = (String)subMap.get("parentNodeId");
                String display = (String)subMap.get("display");
                if (!firstId.equals(subId) || !"block".equals(display)) continue;
                map.put("display", "block");
                continue block0;
            }
        }
        return list;
    }

    private List markDisplayForThirdMenu(List list, List subList) {
        block0: for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String firstId = (String)map.get("id");
            for (int j = 0; j < subList.size(); ++j) {
                Map subMap = (Map)subList.get(j);
                String subId = (String)subMap.get("parentNodeId");
                if (!firstId.equals(subId)) continue;
                map.put("display", "block");
                continue block0;
            }
        }
        return list;
    }

    public String importPage() {
        boolean succ = false;
        LocalErr localErr = null;
        List pageList = null;
        int maxLevel = 0;
        if (StringUtil.isEmpty((String)this.pageDto.getMaxLevel())) {
            localErr = new LocalErr();
            localErr.setDesc("MaxLevel is null!");
            this.writeAjaxData(false, localErr, null);
            return null;
        }
        maxLevel = Integer.parseInt(this.pageDto.getMaxLevel());
        try {
            pageList = this.pageService.importPage(this.getPortalContext(), this.pageDto, true, maxLevel);
            succ = true;
        }
        catch (PortalBizException pe) {
            localErr = this.handleErr((Exception)((Object)pe));
            this.logger.error("importPage  error===== " + (Object)((Object)pe));
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            this.logger.error("importPage  error===== " + e);
        }
        this.writeAjaxData(succ, localErr, pageList);
        return null;
    }

    public void findSpaceList() {
        PagingResult pagingResult;
        try {
            pagingResult = this.pageService.findSpaceList(this.getPortalContext(), this.pagingParam);
        }
        catch (PortalBizException e) {
            this.logger.error("findSpaceList  err===== " + (Object)((Object)e));
            pagingResult = new PagingResult();
        }
        this.writePagingResult(pagingResult);
    }

    public void sortSpaceList() {
        boolean succ = false;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        String sortType = request.getParameter("sortType");
        String id = request.getParameter("id");
        try {
            this.pageService.sortSpaceList(this.getPortalContext(), sortType, id);
            succ = true;
        }
        catch (PortalBizException pe) {
            localErr = this.handleErr((Exception)((Object)pe));
            this.logger.error("sortSpaceList  error===== " + (Object)((Object)pe));
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void lockPageToTabbar() {
        boolean succ = false;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        String pageId = request.getParameter("pageId");
        String pageUrl = request.getParameter("pageUrl");
        String displayName = request.getParameter("displayName");
        String spaceId = request.getParameter("spaceId");
        String secondPageID = request.getParameter("secondPageID");
        PortalContext ctx = this.getPortalContext();
        try {
            if (pageId == null || pageId.indexOf("'") > -1 || pageId.indexOf("(") > -1) {
                succ = false;
                localErr = new LocalErr();
                localErr.setDesc(this.i18nService.getText(ctx, "res.portal.i18n.page.viewtmpl.viewtmpl", "pagelock.info.pageIdErr"));
            } else if (pageUrl == null || pageUrl.indexOf("'") > -1 || pageUrl.indexOf("(") > -1) {
                succ = false;
                localErr = new LocalErr();
                localErr.setDesc(this.i18nService.getText(ctx, "res.portal.i18n.page.viewtmpl.viewtmpl", "pagelock.info.pageUrlErr"));
            } else {
                succ = this.pageService.lockPageToTabbar(ctx, pageId, pageUrl, displayName, spaceId, secondPageID);
            }
        }
        catch (PortalBizException pe) {
            localErr = this.handleErr((Exception)((Object)pe));
            this.logger.error("lockPageToTabbar  error===== " + (Object)((Object)pe));
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void lockPageToHeader() {
        boolean succ = false;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        String pageId = request.getParameter("pageId");
        String displayName = request.getParameter("displayName");
        String spaceId = request.getParameter("spaceId");
        PortalContext ctx = this.getPortalContext();
        try {
            if (pageId == null || pageId.indexOf("'") > -1 || pageId.indexOf("(") > -1) {
                succ = false;
                localErr = new LocalErr();
                localErr.setDesc(this.i18nService.getText(ctx, "res.portal.i18n.page.viewtmpl.viewtmpl", "pagelock.info.pageIdErr"));
            } else {
                succ = this.pageService.lockPageToHeader(ctx, pageId, displayName, spaceId);
            }
        }
        catch (PortalBizException pe) {
            localErr = this.handleErr((Exception)((Object)pe));
            this.logger.error("lockPageToTabbar  error===== " + (Object)((Object)pe));
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void changePortalLayoutType() {
        boolean succ = false;
        HttpServletRequest request = this.getRequest();
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String layoutType = request.getParameter("layoutType");
        try {
            if (!StringUtils.isEmpty((String)layoutType) && FilterSpecialCharactersTool.checkParamsValid((String)layoutType)) {
                this.pageService.updatePortalLayoutType(ctx, layoutType);
                layoutType = this.pageService.findPortalLayoutType(ctx);
                succ = true;
            }
        }
        catch (Exception e) {
            this.logger.error("updatePortalLayoutType Error !!!", (Throwable)e);
        }
        this.writeAjaxData(succ, null, layoutType);
    }

    public void findPortalLayoutType() {
        String layoutType = "common";
        try {
            HttpServletRequest request = this.getRequest();
            PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
            Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
            layoutType = this.pageService.findPortalLayoutType(ctx);
        }
        catch (Exception e) {
            this.logger.error("findPortalLayoutType Error !!!", (Throwable)e);
        }
        this.writeAjaxData(true, null, layoutType);
    }
}

