/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.perm.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.dto.OrgAdminDTO;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.biz.module.perm.service.OrgAdminService;
import com.kingdee.portal.biz.module.perm.service.OrgAdminTreeService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class OrgF7Action
extends BaseAction {
    private static final long serialVersionUID = -323378251031593793L;
    private GroupService groupService = (GroupService)PortalServiceLocator.getBean((String)"groupService");
    private OrgAdminService orgAminService = (OrgAdminService)PortalServiceLocator.getBean((String)"orgAminService");
    private OrgAdminTreeService orgAminTreeService = (OrgAdminTreeService)PortalServiceLocator.getBean((String)"orgAminTreeService");
    private OrgAdminDTO oaDto;

    public void getOrgAdminJsonData() {
        int currentPage = StringUtils.isEmpty((String)this.getRequest().getParameter("currentPage")) ? 1 : Integer.parseInt(this.getRequest().getParameter("currentPage"));
        int pageSize = StringUtils.isEmpty((String)this.getRequest().getParameter("pageSize")) ? 1 : Integer.parseInt(this.getRequest().getParameter("pageSize"));
        this.pagingParam.setPageSize(pageSize);
        this.pagingParam.setPageNo(currentPage);
        this.writeObjectData(JSONUtil.getJson4Object((Object)this.orgAminService.getJsonData(this.getPortalContext(), this.pagingParam, this.oaDto)), ResponseContentTypeEnum.JSON);
    }

    public void getOrgAdminSearchData() {
        int currentPage = StringUtils.isEmpty((String)this.getRequest().getParameter("currentPage")) ? 1 : Integer.parseInt(this.getRequest().getParameter("currentPage"));
        int pageSize = StringUtils.isEmpty((String)this.getRequest().getParameter("pageSize")) ? 1 : Integer.parseInt(this.getRequest().getParameter("pageSize"));
        this.pagingParam.setPageSize(pageSize);
        this.pagingParam.setPageNo(currentPage);
        this.writeObjectData(JSONUtil.getJson4Object((Object)this.orgAminService.getSearchData(this.getPortalContext(), this.pagingParam, this.oaDto)), ResponseContentTypeEnum.JSON);
    }

    public void getOrgAdminSelectedData() {
        this.writeObjectData(JSONUtil.getJson4Object((Object)this.orgAminService.getSelectedData(this.getPortalContext(), this.oaDto.getSeletedIds())), ResponseContentTypeEnum.JSON);
    }

    public void getOrgAdminTreeJsonData() {
        this.writeObjectData(JSONUtil.getJson4Object((Object)this.orgAminTreeService.getJsonData(this.getPortalContext(), this.oaDto)), ResponseContentTypeEnum.JSON);
    }

    public void findOrgTree() {
        PortalContext ctx = this.getPortalContext();
        String id = this.getRequest().getParameter("id");
        JSONArray array = null;
        try {
            this.logger.info("Org Parent ====   " + id);
            if (!StringUtil.isEmpty((String)id)) {
                id = id.replaceAll("@", "+");
                this.logger.info("Org Parent replace ====   " + id);
            }
            List orgList = this.groupService.findGroupListByParentId(ctx, id);
            this.logger.info("orgList===" + orgList);
            array = this.buildOrgTreeArr(ctx, orgList, false);
        }
        catch (Exception e) {
            this.logger.info("Org Parent err ====   " + id);
            this.handleErr(e);
            array = new JSONArray();
        }
        this.writeData2Response(this.getResponse(), array.toString());
    }

    public void searchOrgTree() {
        PortalContext ctx = this.getPortalContext();
        JSONArray array = null;
        try {
            List orgList = this.groupService.searchGroupListByName(ctx, this.getRequest().getParameter("name"));
            array = this.buildOrgTreeArr(ctx, orgList, true);
        }
        catch (Exception e) {
            this.handleErr(e);
            array = new JSONArray();
        }
        this.writeData2Response(this.getResponse(), array.toString());
    }

    public String orgF7WrapPage() {
        String uid = StringUtil.convNull((String)this.getRequest().getParameter("uid"));
        this.getRequest().setAttribute("uid", (Object)uid);
        String checkStyle = StringUtil.convNull((String)this.getRequest().getParameter("checkStyle"));
        if (StringUtil.isEmpty((String)checkStyle)) {
            checkStyle = "checkbox";
        }
        this.getRequest().setAttribute("checkStyle", (Object)checkStyle);
        return "success";
    }

    private JSONArray buildOrgTreeArr(PortalContext ctx, List<GroupDTO> orgList, boolean isSearch) throws PortalBizException {
        JSONArray array = new JSONArray();
        JSONObject treeNode = null;
        for (GroupDTO org : orgList) {
            treeNode = new JSONObject();
            treeNode.put((Object)"id", (Object)org.getId());
            if (!isSearch) {
                treeNode.put((Object)"isParent", (Object)(!org.isLeaf() ? 1 : 0));
                treeNode.put((Object)"pId", (Object)org.getParentId());
                treeNode.put((Object)"open", (Object)false);
            }
            String name = "";
            String desc = "";
            if (org.getName() != null) {
                name = org.getName();
            }
            if (org.getDesc() != null) {
                name = org.getDesc();
            }
            treeNode.put((Object)"name", (Object)name);
            treeNode.put((Object)"desc", (Object)desc);
            array.add((Object)treeNode);
        }
        return array;
    }

    private void writeData2Response(HttpServletResponse response, String data) {
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public OrgAdminDTO getOaDto() {
        return this.oaDto;
    }

    public void setOaDto(OrgAdminDTO oaDto) {
        this.oaDto = oaDto;
    }
}

