/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.perm.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.perm.common.enums.PermBlackTypeEnum;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.dto.RoleDTO;
import com.kingdee.portal.biz.module.perm.dto.UserDTO;
import com.kingdee.portal.biz.module.perm.entity.Role;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.biz.module.perm.service.RoleService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleManageAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RoleManageAction.class);
    private RoleService roleService = (RoleService)PortalServiceLocator.getBean((String)"roleService");
    private RoleDTO roleDto;
    private List<UserDTO> userList;
    private List<GroupDTO> groupList;
    private GroupService groupService = (GroupService)PortalServiceLocator.getBean((String)"groupService");

    public RoleDTO getRoleDto() {
        return this.roleDto;
    }

    public void setRoleDto(RoleDTO roleDto) {
        this.roleDto = roleDto;
    }

    public List<UserDTO> getUserList() {
        return this.userList;
    }

    public void setUserList(List<UserDTO> userList) {
        this.userList = userList;
    }

    public List<GroupDTO> getGroupList() {
        return this.groupList;
    }

    public void setGroupList(List<GroupDTO> groupList) {
        this.groupList = groupList;
    }

    public void findRoleList() {
        PortalContext ctx = this.getPortalContext();
        PagingResult roles = null;
        try {
            roles = this.roleService.findRoleList(ctx, this.getPagingParam(), this.roleDto.getRole().getName());
        }
        catch (Exception ex) {
            this.handleErr(ex);
            roles = new PagingResult();
        }
        this.writePagingResult(roles);
    }

    public String findRole() {
        Role findRole = null;
        try {
            findRole = this.getRoleObj(this.roleDto.getRole());
        }
        catch (Exception e) {
            this.handleErr(e);
            return "error";
        }
        this.roleDto.setRole(findRole);
        return "success";
    }

    private Role getRoleObj(Role role) throws PortalBizException {
        if (role == null || StringUtil.isEmpty((String)role.getId())) {
            return new Role();
        }
        return this.roleService.findRoleById(this.getPortalContext(), role.getId());
    }

    public void saveRole() {
        try {
            String description = FilterSpecialCharactersTool.cleanXSS((String)this.roleDto.getRole().getDescription());
            this.roleDto.getRole().setDescription(description);
            Role role = this.innerSaveRole(this.getPortalContext(), this.roleDto.getRole());
            this.writeAjaxData(true, null, role.getId());
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private Role innerSaveRole(PortalContext ctx, Role saveRole) throws PortalBizException {
        if (StringUtil.isEmpty((String)saveRole.getId())) {
            return this.roleService.createRole(ctx, saveRole);
        }
        return this.roleService.updateRole(ctx, saveRole);
    }

    public void deleteRole() {
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.deleteRoleById(this.getPortalContext(), this.roleDto.getRole().getId());
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }

    public String manageRoleMember() {
        try {
            Map member = this.roleService.findRoleMember(this.getPortalContext(), this.roleDto.getRole().getId());
            this.userList = (List)member.get("userList");
            this.groupList = (List)member.get("groupList");
        }
        catch (Exception e) {
            this.handleErr(e);
            this.userList = new ArrayList<UserDTO>();
            this.groupList = new ArrayList<GroupDTO>();
        }
        return "success";
    }

    public void createRefRoleUser() {
        String userIds = this.getRequest().getParameter("userIds");
        String roleId = this.getRequest().getParameter("roleId");
        String delIds = this.getRequest().getParameter("delIds");
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.createRefRoleUser(this.getPortalContext(), roleId, userIds.split(","));
            this.roleService.deleteRefRoleUser(this.getPortalContext(), roleId, delIds.split(","));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }

    public void deleteRefRoleUser() {
        String userIds = this.getRequest().getParameter("userIds");
        String roleId = this.getRequest().getParameter("roleId");
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.deleteRefRoleUser(this.getPortalContext(), roleId, userIds.split(","));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }

    public void createRefRoleGroup() {
        String permIds = this.getRequest().getParameter("groupIds");
        String roleId = this.getRequest().getParameter("roleId");
        String delIds = this.getRequest().getParameter("delIds");
        boolean succ = true;
        LocalErr err = null;
        HashMap<String, String> idsMap = new HashMap<String, String>();
        try {
            if (delIds == null) {
                delIds = "";
            }
            this.roleService.createRefRoleGroup(this.getPortalContext(), roleId, permIds.split(","));
            this.roleService.deleteRefRoleGroup(this.getPortalContext(), roleId, delIds.split(","));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        idsMap.put("permIds", permIds);
        idsMap.put("delIds", delIds);
        this.writeAjaxData(succ, err, idsMap);
    }

    public void deleteRefRoleGroup() {
        String groupIds = this.getRequest().getParameter("groupIds");
        String roleId = this.getRequest().getParameter("roleId");
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.deleteRefRoleGroup(this.getPortalContext(), roleId, groupIds.split(","));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }

    public String findRoleBlack() {
        try {
            Map black = this.roleService.findBlackList(this.getPortalContext(), this.roleDto.getRole().getId());
            this.userList = (List)black.get("userList");
            this.groupList = (List)black.get("groupList");
        }
        catch (Exception e) {
            this.handleErr(e);
            this.userList = new ArrayList<UserDTO>();
            this.groupList = new ArrayList<GroupDTO>();
        }
        return "success";
    }

    public void createBlack() {
        String blackIds = this.getRequest().getParameter("blackIds");
        String roleId = this.getRequest().getParameter("roleId");
        String blackType = this.getRequest().getParameter("blackType");
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.createBlack(this.getPortalContext(), roleId, blackIds.split(","), this.transBlackType(blackType));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }

    private PermBlackTypeEnum transBlackType(String type) {
        if (PermBlackTypeEnum.ROLE_BLACK_USER.toString().equals(type)) {
            return PermBlackTypeEnum.ROLE_BLACK_USER;
        }
        return PermBlackTypeEnum.ROLE_BLACK_GROUP;
    }

    public void deleteBlack() {
        String blackIds = this.getRequest().getParameter("blackIds");
        String roleId = this.getRequest().getParameter("roleId");
        boolean succ = true;
        LocalErr err = null;
        try {
            this.roleService.deleteBlack(this.getPortalContext(), roleId, blackIds.split(","));
        }
        catch (Exception e) {
            succ = false;
            err = this.handleErr(e);
        }
        this.writeAjaxData(succ, err, null);
    }
}

