/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.personal.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.json.FavExtInfo;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.personal.dto.PersonalFavoriteDTO;
import com.kingdee.portal.biz.module.personal.entity.PersonalCountClick;
import com.kingdee.portal.biz.module.personal.entity.PersonalFavorite;
import com.kingdee.portal.biz.module.personal.service.PersonalCountClickService;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PersonalFavoriteAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private PersonalFavoriteService personalFavoriteService = (PersonalFavoriteService)PortalServiceLocator.getBean((String)"personalFavoriteService");
    private PersonalCountClickService personalCountClickService = (PersonalCountClickService)PortalServiceLocator.getBean((String)"personalCountClickService");
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private PersonalFavorite favorite;
    private FavExtInfo favExtInfo;
    private PersonalCountClick click;

    public void findPersonalFavoriteList() {
        try {
            List list = this.personalFavoriteService.findPersonalFavoriteList(this.getPortalContext(), this.getPermMap());
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void createPersonalFavorite() {
        try {
            String permEditCtrl = this.getRequest().getParameter("permEditCtrl");
            if (NodeTypeEnum.YOUSHANG.equals((Object)this.favorite.getPageType())) {
                String ext = this.favExtInfo.toString();
                this.favorite.setFavExtInfo(ext);
            }
            PersonalFavoriteDTO fav = this.personalFavoriteService.createPersonalFavorite(this.getPortalContext(), this.favorite, permEditCtrl);
            this.writeAjaxData(true, null, fav);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void deletePersonalFavorite() {
        try {
            this.personalFavoriteService.deletePersonalFavoriteById(this.getPortalContext(), this.favorite.getId());
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void PersonalCountClick() {
        PortalContext portalContext = this.getPortalContext();
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        try {
            String menuId;
            String userId = userInfo.getId().toString();
            String id = menuId = this.click.getComFunctionId();
            this.personalCountClickService.savePersonalCountClick(userId, id);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findFavAndServiceList() {
        try {
            Map favList = this.personalFavoriteService.findFavMapForTopFav(this.getPortalContext(), this.getPermMap());
            HashMap<String, Map> map = new HashMap<String, Map>();
            map.put("favList", favList);
            this.writeAjaxData(true, null, map);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findCommonList() {
        PortalContext portalContext = this.getPortalContext();
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        String numberRecently = this.getRequest().getParameter("numberRecently") == null ? "" : this.getRequest().getParameter("numberRecently");
        try {
            String userId = userInfo.getId().toString();
            Pattern p = Pattern.compile("^[1-9]+\\d*$");
            Matcher matcher = p.matcher(numberRecently);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (matcher.matches()) {
                Object[] openedPageIds = this.personalFavoriteService.findOpenedPagesRecently(context, userId);
                int number = Integer.valueOf(numberRecently);
                number = number > openedPageIds.length ? openedPageIds.length : number;
                openedPageIds = (String[])Arrays.copyOf((Object[])openedPageIds, (int)number);
                List openedList = this.pageService.findPageListByIds(portalContext, (String[])openedPageIds);
                ArrayList<Page> openedListResult = new ArrayList<Page>();
                for (int i = 0; i < openedPageIds.length; ++i) {
                    for (Page page : openedList) {
                        if (!((String)openedPageIds[i]).equalsIgnoreCase(page.getId())) continue;
                        openedListResult.add(page);
                    }
                }
                map.put("openedList", openedListResult);
            }
            Map favList = this.personalFavoriteService.findFavForTopFav(this.getPortalContext(), context, userId, this.getPermMap());
            map.put("favList", favList);
            this.writeAjaxData(true, null, map);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void recordOpenedPage() {
        PortalContext portalContext = this.getPortalContext();
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        try {
            String userId = userInfo.getId().toString();
            String pageId = this.getRequest().getParameter("pageId");
            if (!StringUtils.isEmpty((String)pageId)) {
                this.personalFavoriteService.updateOpenedPagesRecently(portalContext, context, userId, pageId);
            }
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void sortPersonalFavorite() {
        try {
            this.personalFavoriteService.sortPersonalFavorite(this.getPortalContext(), this.favorite.getId().split(","));
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public FavExtInfo getFavExtInfo() {
        return this.favExtInfo;
    }

    public void setFavExtInfo(FavExtInfo favExtInfo) {
        this.favExtInfo = favExtInfo;
    }

    public void setFavorite(PersonalFavorite favorite) {
        this.favorite = favorite;
    }

    public PersonalFavorite getFavorite() {
        return this.favorite;
    }

    public PersonalCountClick getClick() {
        return this.click;
    }

    public void setClick(PersonalCountClick click) {
        this.click = click;
    }
}

