/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.personal.action;

import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.entity.Role;
import com.kingdee.portal.biz.module.perm.service.RoleService;
import com.kingdee.portal.biz.module.personal.dto.PresetInfoDTO;
import com.kingdee.portal.biz.module.personal.entity.PresetFav;
import com.kingdee.portal.biz.module.personal.entity.PresetFavPageList;
import com.kingdee.portal.biz.module.personal.service.PresetService;
import com.kingdee.portal.biz.module.pub.dto.AddedPageDTO;
import com.kingdee.portal.plt.iservice.common.enums.NodeTypeEnum;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PresetFavoriteAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private PresetService presetService = (PresetService)PortalServiceLocator.getBean((String)"presetService");
    private PresetInfoDTO presetInfoDTO;
    private PresetFav presetFav;
    private String presetFavPageList;
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private RoleService roleService = (RoleService)PortalServiceLocator.getBean((String)"roleService");

    public void findPresetMap() {
        try {
            HashMap<String, Object> presetMap = new HashMap<String, Object>();
            if ("function".equals(this.presetInfoDTO.getPresetFav().getFavType())) {
                presetMap.put("treeList", this.presetService.getTreeList(this.getPortalContext(), this.presetInfoDTO));
            }
            presetMap.put("addList", this.getAddedFav(this.presetInfoDTO.getPresetFav().getFavType(), presetMap));
            this.writeAjaxData(true, null, presetMap);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private String getJSON4BizPage(PortalContext ctx, List<ServiceDefinition> svList, String getBizType) {
        JSONArray arr = new JSONArray();
        JSONObject obj = null;
        for (int i = 0; i < svList.size(); ++i) {
            ServiceDefinition sd = svList.get(i);
            if ("65d3a274-3739-40a4-8522-7ead1b238d01".equals(sd.getId())) continue;
            obj = new JSONObject();
            obj.put((Object)"id", (Object)sd.getId());
            obj.put((Object)"pId", (Object)sd.getParentNodeId());
            obj.put((Object)"t", (Object)sd.getNodeType().toString());
            obj.put((Object)"name", (Object)this.getLocaleDisplayName(ctx, sd.getDisplayName()));
            obj.put((Object)"pathInfo", (Object)sd.getNodePath());
            obj.put((Object)"icon", null);
            boolean bl = false;
            if (!sd.getNodeType().equals((Object)NodeTypeEnum.ROOT) && !sd.getNodeType().equals((Object)NodeTypeEnum.CATEGORY)) {
                bl = true;
            }
            obj.put((Object)"isLeaf", (Object)bl);
            arr.add((Object)obj);
        }
        return arr.toString();
    }

    private List<AddedPageDTO> getAddedFav(String favType, Map<String, Object> presetMap) {
        ArrayList<AddedPageDTO> addList = new ArrayList<AddedPageDTO>();
        try {
            PresetFav entity = new PresetFav();
            entity.setRoleId(this.presetInfoDTO.getPresetFav().getRoleId());
            entity.setFavType(favType);
            PresetFav pf = this.presetService.findPresetFav(this.getPortalContext(), entity);
            if (pf != null) {
                IRowSet rs = null;
                if ("function".equals(favType)) {
                    rs = this.pageService.findPresetFavPageList(this.getPortalContext(), pf.getId());
                }
                if (rs != null) {
                    while (rs.next()) {
                        AddedPageDTO ap = new AddedPageDTO();
                        ap.setId(rs.getString("fid"));
                        ap.setDisplayName(this.getLocaleDisplayName(this.getPortalContext(), rs.getString("displayName")));
                        ap.setSourceName(this.getLocaleDisplayName(this.getPortalContext(), rs.getString("description")));
                        ap.setSourceId(rs.getString("sourceId"));
                        addList.add(ap);
                    }
                }
                presetMap.put("activeType", pf.getActiveType());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return addList;
    }

    private String getLocaleDisplayName(PortalContext ctx, String displayName) {
        String locale = ctx.getLocale().toString();
        DisplayName dn = new DisplayName(displayName, locale);
        return dn.getLocaleText();
    }

    public void findRoleAndSource() {
        try {
            HashMap<String, List> presetMap = new HashMap<String, List>();
            presetMap.put("roleList", this.getRoleList(this.getPortalContext()));
            if ("function".equals(this.presetInfoDTO.getPresetFav().getFavType())) {
                List pageList = this.pageService.findBizList4PresetFav(this.getPortalContext());
                presetMap.put("sourceList", pageList);
            }
            this.writeAjaxData(true, null, presetMap);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private List<Role> getRoleList(PortalContext ctx) {
        PagingParam pagingParam = new PagingParam();
        pagingParam.setPageNo(1);
        pagingParam.setPageSize(1000);
        try {
            return this.roleService.findRoleList(ctx, pagingParam, null).getRecords();
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void getTreeList() {
        try {
            if ("function".equals(this.presetInfoDTO.getPresetFav().getFavType())) {
                this.writeAjaxData(true, null, this.presetService.getTreeList(this.getPortalContext(), this.presetInfoDTO));
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void savePresetFav() {
        try {
            ArrayList<PresetFavPageList> pageList = new ArrayList<PresetFavPageList>();
            if (!StringUtil.isEmpty((String)this.presetFavPageList)) {
                String[] favPageList = this.presetFavPageList.split(";");
                for (int i = 0; i < favPageList.length; ++i) {
                    PresetFavPageList pf = new PresetFavPageList();
                    String[] favPage = favPageList[i].split(",");
                    pf.setPageId(favPage[0]);
                    pf.setOrderNumber(Integer.valueOf(Integer.parseInt(favPage[1])));
                    pf.setIsNew(Boolean.valueOf("true".equals(favPage[2])));
                    pf.setPortalContext(this.getPortalContext());
                    pf.setSourceId(favPage[3]);
                    pageList.add(pf);
                }
            }
            this.writeAjaxData(true, null, this.presetService.savePresetFav(this.getPortalContext(), this.presetFav, pageList));
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public PresetInfoDTO getPresetInfoDTO() {
        return this.presetInfoDTO;
    }

    public void setPresetInfoDTO(PresetInfoDTO presetInfoDTO) {
        this.presetInfoDTO = presetInfoDTO;
    }

    public PresetFav getPresetFav() {
        return this.presetFav;
    }

    public void setPresetFav(PresetFav presetFav) {
        this.presetFav = presetFav;
    }

    public String getPresetFavPageList() {
        return this.presetFavPageList;
    }

    public void setPresetFavPageList(String presetFavPageList) {
        this.presetFavPageList = presetFavPageList;
    }
}

