/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.portlet.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.dto.PortletModel;
import com.kingdee.portal.biz.module.portlet.entity.PortletApp;
import com.kingdee.portal.biz.module.portlet.service.PortletAppService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletAppAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(PortletAppAction.class);
    private static final long serialVersionUID = 5348374510095606008L;
    private PortletModel portletModel;
    private String retCode;
    private PortletAppService portletAppService = (PortletAppService)PortalServiceLocator.getBean((String)"portletAppService");
    private PortletService portletService = (PortletService)PortalServiceLocator.getBean((String)"portletService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");

    public String registerPortalApp() throws Exception {
        Integer iresult = 0;
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.success");
            String appName = this.getRequest().getParameter("appName");
            String categoryName = this.getRequest().getParameter("categoryName");
            PortletApp app = new PortletApp();
            app.setName(appName);
            this.portletAppService.createPortletApp(this.getPortalContext(), app, categoryName);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            String sresult = this.errCodeTransfer(PE.getMessage());
            this.writeData("result", sresult);
            return null;
        }
        return null;
    }

    public String findPortletAppList() throws Exception {
        try {
            String sortField = this.pagingParam.getSortField();
            sortField = StringEscapeUtils.escapeSql((String)sortField);
            this.pagingParam.setSortField(sortField);
            PagingResult pagingResult = this.portletAppService.findPortletAppList(this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        return null;
    }

    public String modifyPortletAppStatus() throws Exception {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.enable");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.enableerr");
            String appId = this.getRequest().getParameter("appId");
            PortletApp app = this.portletAppService.modifyPortletAppStatus(this.getPortalContext(), appId);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            String sresult = this.errCodeTransfer(PE.getMessage());
            this.writeData("result", resultErr + " " + sresult);
            return null;
        }
        return null;
    }

    private String getPortletDisplayName(String jsonStr) {
        if (StringUtil.isEmpty((String)jsonStr)) {
            return "\u65e0\u540d\u79f0";
        }
        DisplayName name = new DisplayName(jsonStr);
        name.setLocale(this.getPortalContext().getLocale().toString());
        return name.getLocaleText();
    }

    public String updatePortletApp() throws Exception {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.refresh");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.refresherr");
            String appId = this.getRequest().getParameter("appId");
            this.portletAppService.updatePortletApp(this.getPortalContext(), appId, "");
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        catch (Exception E) {
            logger.error(E.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String deletePortletApp() throws Exception {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.uninstall");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.uninstallerr");
            String appId = this.getRequest().getParameter("appId");
            String appName = this.getRequest().getParameter("appName");
            this.portletAppService.removePortletApp(this.getPortalContext(), appId, appName);
            this.writeData("result", result);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            this.writeAjaxData(false, pe.getLocalErr(this.getPortalContext()), "");
            return null;
        }
        catch (Exception E) {
            logger.error(E.getMessage());
            this.writeData("result", resultErr + E.getMessage());
            return null;
        }
        return null;
    }

    private void writeData(String skey, String svalue) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private String errCodeTransfer(String errMessage) throws Exception {
        String sresult = "";
        if (errMessage.matches("[0-9]*")) {
            int iresult = Integer.valueOf(errMessage);
            switch (iresult) {
                case 301: {
                    sresult = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.notdelete");
                    break;
                }
                case 302: {
                    sresult = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.isexit");
                    break;
                }
                case 303: {
                    sresult = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.notexit");
                }
            }
        } else {
            sresult = errMessage;
        }
        return sresult;
    }

    private JSONArray getJSONArr(List records) {
        DisplayName displayName = new DisplayName();
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        for (int i = 0; i < records.size(); ++i) {
            PortletApp p = (PortletApp)records.get(i);
            obj.put((Object)"id", (Object)p.getId());
            obj.put((Object)"name", (Object)p.getName());
            obj.put((Object)"description", (Object)p.getDescription());
            obj.put((Object)"contextPath", (Object)p.getContextPath());
            obj.put((Object)"status", (Object)p.getStatus());
            arr.add((Object)obj);
        }
        return arr;
    }

    public String findAppNameList() throws Exception {
        try {
            List allList = this.portletAppService.findAppNameListFromXML("unregister");
            JSONObject jsonObj = new JSONObject();
            JSONArray arr = new JSONArray();
            for (int i = 0; i < allList.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"name", (Object)((PortletApp)allList.get(i)).getName());
                arr.add((Object)obj);
            }
            jsonObj.put((Object)"result", (Object)arr);
            this.writeData2Response(jsonObj.toString());
        }
        catch (PortalBizException e) {
            logger.error(e.getMessage());
            return null;
        }
        return null;
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public PortletModel getPortletModel() {
        return this.portletModel;
    }

    public void setPortletModel(PortletModel portletModel) {
        this.portletModel = portletModel;
    }
}

