/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.portlet.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletCategoryAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(PortletCategoryAction.class);
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private PortletService portletService = (PortletService)PortalServiceLocator.getBean((String)"portletService");
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private PortletCategory category = new PortletCategory();

    public void findCategoryList() {
        try {
            JSONObject jsonObj = new JSONObject();
            List pc = this.portletCategoryService.findCategoryList(this.getPortalContext(), "categoryName", "ASC");
            JSONArray category = new JSONArray();
            for (int i = 0; i < pc.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"categoryId", (Object)((PortletCategory)pc.get(i)).getId());
                obj.put((Object)"cname", (Object)this.getDisplayName(((PortletCategory)pc.get(i)).getCategoryName()));
                obj.put((Object)"pltKeyword", (Object)((PortletCategory)pc.get(i)).getPortletKeywords());
                category.add((Object)obj);
            }
            jsonObj.put((Object)"cnameList", (Object)category);
            this.writeData2Response(this.getResponse(), jsonObj.toString());
        }
        catch (PortalBizException e) {
            logger.error("\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    private String getDisplayName(String jsonStr) {
        if (StringUtil.isEmpty((String)jsonStr)) {
            return "\u65e0\u540d\u79f0";
        }
        DisplayName name = new DisplayName(jsonStr);
        name.setLocale(this.getPortalContext().getLocale().toString());
        return name.getLocaleText();
    }

    public String loadCategoryList() throws PortalBizException {
        String pageNo = this.getRequest().getParameter("pageNum");
        String pageSize = this.getRequest().getParameter("pageSize");
        String categoryName = this.getRequest().getParameter("categoryName");
        String isFuzzy = this.getRequest().getParameter("isFuzzy");
        try {
            JSONObject category = this.portletCategoryService.findCategoryList(this.getPortalContext(), pageNo, pageSize, categoryName, Boolean.valueOf(Boolean.valueOf(isFuzzy)));
            this.writeData2Response(this.getResponse(), category.toString());
        }
        catch (PortalBizException e) {
            logger.error("\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    public String deleteCategory() throws PortalBizException {
        HttpServletRequest request = this.getRequest();
        String categoryIds = request.getParameter("categoryIds");
        try {
            this.portletCategoryService.batchDeleteCategory(this.getPortalContext(), categoryIds);
        }
        catch (PortalBizException e) {
            logger.error("\u5220\u9664\u5206\u7c7b\u51fa\u9519", (Throwable)e);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)"success", (Object)true);
        this.writeData2Response(this.getResponse(), obj.toString());
        return null;
    }

    public String updateCategory() throws PortalBizException {
        this.category = this.portletCategoryService.editByCategory(this.category);
        return "edit";
    }

    public String saveCategory() throws PortalBizException {
        String id = this.getRequest().getParameter("id");
        String categoryName = this.getRequest().getParameter("categoryName");
        String portletKeywords = this.getRequest().getParameter("portletKeywords");
        JSONObject obj = new JSONObject();
        boolean isCategoryNameDuplicated = false;
        boolean isKeyWordsDuplicated = false;
        try {
            isCategoryNameDuplicated = StringUtil.isEmpty((String)id) ? this.portletCategoryService.checkDuplicateCategoryName(this.getPortalContext(), categoryName) : this.portletCategoryService.checkDuplicateCategoryName(this.getPortalContext(), id, categoryName);
            isKeyWordsDuplicated = StringUtil.isEmpty((String)id) ? this.portletCategoryService.checkDuplicateKeyWords(null, portletKeywords) : this.portletCategoryService.checkDuplicateKeyWords(id, portletKeywords);
            if (isCategoryNameDuplicated) {
                obj.put((Object)"success", (Object)false);
                obj.put((Object)"msg", (Object)"\u8be5\u5206\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            } else if (isKeyWordsDuplicated) {
                obj.put((Object)"success", (Object)false);
                obj.put((Object)"msg", (Object)"\u8be5\u5206\u7c7b\u6807\u7b7e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            } else {
                String categoryId = this.portletCategoryService.saveCategory(this.getPortalContext(), id, categoryName, portletKeywords);
                obj.put((Object)"success", (Object)true);
                obj.put((Object)"id", (Object)categoryId);
            }
            this.writeData2Response(this.getResponse(), obj.toString());
        }
        catch (PortalBizException e) {
            logger.error("\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    private void writeData2Response(HttpServletResponse response, String data) {
        logger.info("-----------------------data:" + data);
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public PortletCategory getCategory() {
        return this.category;
    }

    public void setCategory(PortletCategory category) {
        this.category = category;
    }
}

