/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.pub.action;

import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.pub.common.enums.FileTypeEnum;
import com.kingdee.portal.biz.module.pub.common.json.FileMetaInfo;
import com.kingdee.portal.biz.module.pub.common.util.PubConstant;
import com.kingdee.portal.biz.module.pub.dto.CropModel;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.biz.module.pub.dto.ImgDTO;
import com.kingdee.portal.biz.module.pub.entity.PubFile;
import com.kingdee.portal.biz.module.pub.service.PubFileService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.ImageUtil;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageManageAction
extends BaseFileUploadAction {
    private PubFileService pubFileService = (PubFileService)PortalServiceLocator.getBean((String)"pubFileService");
    private ImgDTO imgDTO;
    private CropModel cropModel;

    public String openWin4ImageManageList() {
        String imgManage = this.imgDTO.getImgManage();
        if ("admin_icon_manage".equalsIgnoreCase(imgManage)) {
            this.imgDTO.setCanDelImg(true);
            this.imgDTO.setShowPltTab(false);
            this.imgDTO.setShowTitle(true);
            this.imgDTO.setCanClick(false);
        } else if ("page_icon_manage".equalsIgnoreCase(imgManage)) {
            this.imgDTO.setCanDelImg(false);
            this.imgDTO.setShowPltTab(false);
            this.imgDTO.setShowTitle(false);
            this.imgDTO.setCanClick(true);
        } else if ("portlet_icon_manage".equalsIgnoreCase(imgManage)) {
            this.imgDTO.setCanDelImg(false);
            this.imgDTO.setShowPltTab(false);
            this.imgDTO.setShowTitle(false);
            this.imgDTO.setCanClick(true);
        }
        String iconId = StringUtil.convNull((String)this.imgDTO.getId());
        if (iconId.startsWith("sys_")) {
            this.imgDTO.setDefaultTab("sys_icon");
        } else if (iconId.startsWith("app_")) {
            this.imgDTO.setDefaultTab("quick_icon");
        } else {
            this.imgDTO.setDefaultTab("upload_icon");
        }
        PortalContext ctx = this.getPortalContext();
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getLoginUser().getId())) {
            this.imgDTO.setCanUploadIcon(true);
        } else {
            this.imgDTO.setCanUploadIcon(false);
        }
        this.getRequest().setAttribute("imgDTO", (Object)this.imgDTO);
        return "success";
    }

    public String openWin4UploadImg() {
        if (FileTypeEnum.COMMON_IMG.toString().equalsIgnoreCase(this.imgDTO.getFileType4Upload())) {
            this.imgDTO.setShowDisplayName4Upload(true);
        } else if (FileTypeEnum.USER_LOGO.toString().equalsIgnoreCase(this.imgDTO.getFileType4Upload())) {
            this.imgDTO.setShowDisplayName4Upload(false);
            String userCode = this.getPortalContext().getLoginUser().getCode();
            try {
                PubFile pubFile = this.pubFileService.findUserLogoByUserCode(this.getPortalContext(), userCode);
                if (pubFile != null && pubFile.getOrigImgContent() != null) {
                    this.getRequest().setAttribute("hasOrigImg", (Object)true);
                    FileMetaInfo fileMetaInfo = (FileMetaInfo)JSONUtil.getObject4Json((String)pubFile.getMetaInfo(), FileMetaInfo.class);
                    this.getRequest().setAttribute("fileMetaInfo", (Object)fileMetaInfo);
                    FileModel fileModel = this.buildFileModel4DB(pubFile);
                    this.getRequest().getSession().setAttribute("last_upload_img", (Object)fileModel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return "success";
    }

    public String uploadTempImg() {
        boolean success = true;
        LocalErr localErr = null;
        FileModel fileModel = null;
        try {
            this.copyFile2UploadFolder();
            fileModel = this.buildFileModel4Upload();
        }
        catch (Exception ex) {
            localErr = this.handleErr(ex);
            success = false;
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"uploadTempImg");
        this.getRequest().getSession().setAttribute("last_upload_img", (Object)fileModel);
        this.getRequest().setAttribute("localErr", (Object)localErr);
        return "success";
    }

    public String showTempImg() {
        FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("last_upload_img");
        File tempTempImg = new File(fileModel.getUploadFilePath());
        byte[] fileContent = this.getFileContent(tempTempImg);
        this.writeResponse(this.getResponse(), fileModel.getUploadContentType(), fileContent);
        return null;
    }

    public String showLoginUserOrigImg() {
        String userCode = this.getPortalContext().getLoginUser().getCode();
        try {
            PubFile pubFile = this.pubFileService.findUserLogoByUserCode(this.getPortalContext(), userCode);
            if (pubFile != null && pubFile.getOrigImgContent() != null) {
                this.writeResponse(this.getResponse(), pubFile.getContentType(), pubFile.getOrigImgContent());
            }
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String saveImg() {
        boolean success = true;
        try {
            FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("last_upload_img");
            DisplayName displayName = new DisplayName();
            String displayNameStr = this.getRequest().getParameter("displayName");
            String fileType4Upload = this.getRequest().getParameter("fileType4Upload");
            FileTypeEnum fileType = FileTypeEnum.valueOf((String)fileType4Upload);
            if (StringUtil.isEmpty((String)displayNameStr) && FileTypeEnum.USER_LOGO.equals((Object)fileType)) {
                displayName = new DisplayName();
                displayName.setEn("USER_LOGO");
                displayName.setZh_CN("USER_LOGO");
                displayName.setZh_TW("USER_LOGO");
            }
            if (!StringUtil.isEmpty((String)displayNameStr)) {
                displayNameStr = new String(displayNameStr.getBytes("iso8859-1"), "UTF-8");
                displayName = new DisplayName(displayNameStr);
            }
            PubFile pubFile = this.pubFileService.createPubFile4Img(this.getPortalContext(), fileModel, this.cropModel, displayName, fileType);
            this.getRequest().setAttribute("id", (Object)pubFile.getId());
        }
        catch (Exception ex) {
            System.out.println("----saveImg error --------");
            ex.printStackTrace();
            this.handleErr(ex);
            success = false;
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"saveImg");
        return "success";
    }

    public String findPubImageList() {
        String imgTab = this.imgDTO.getImgTab();
        String displayName = this.imgDTO.getDisplayName();
        try {
            PagingResult<PubFile> pagingResult = null;
            if ("upload_icon".equals(imgTab)) {
                pagingResult = this.findPubImageList4Upload(displayName);
            } else if ("sys_icon".equals(imgTab)) {
                pagingResult = this.findPubImageList4SysIcon(displayName);
            } else if (!"portlet_icon".equals(imgTab) && "quick_icon".equals(imgTab)) {
                pagingResult = this.findPubImageList4Portlet(displayName);
            }
            this.writePagingResult(pagingResult);
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return null;
    }

    public String hasUsed4Img() {
        boolean success = true;
        LocalErr localErr = null;
        boolean result = false;
        try {
            String id = this.imgDTO.getId();
            result = this.pubFileService.hasUsed4Img(this.getPortalContext(), id);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String deletePubImg() {
        boolean success = true;
        LocalErr localErr = null;
        try {
            String id = this.imgDTO.getId();
            this.pubFileService.deletePubFileById(this.getPortalContext(), id);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    private FileModel buildFileModel4DB(PubFile pubFile) throws FileNotFoundException, IOException {
        String fileSuffix = StringUtil.convNull((String)pubFile.getFileSuffix());
        if (StringUtil.isEmpty((String)fileSuffix)) {
            fileSuffix = ".jpg";
        }
        String fileName = pubFile.getId() + fileSuffix;
        String imgFilePath = this.getTargetDirectory() + fileName;
        byte[] origImgContent = pubFile.getOrigImgContent();
        if (origImgContent == null) {
            origImgContent = pubFile.getContent();
        }
        ImageUtil.writeImgFile((byte[])origImgContent, (String)imgFilePath);
        FileModel fileModel = new FileModel();
        fileModel.setUploadFilePath(imgFilePath);
        fileModel.setUploadFileName(fileName);
        fileModel.setUploadContentType(pubFile.getContentType());
        fileModel.setLength(Long.valueOf(origImgContent.length));
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(new File(imgFilePath));
            BufferedImage image = ImageIO.read(fileInputStream);
            fileModel.setHeight(Integer.valueOf(image.getHeight()));
            fileModel.setWidth(Integer.valueOf(image.getWidth()));
            FileModel fileModel2 = fileModel;
            return fileModel2;
        }
    }

    private FileModel buildFileModel4Upload() throws FileNotFoundException, IOException, PortalBizException {
        FileModel fileModel = null;
        fileModel = new FileModel();
        fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
        fileModel.setUploadFileName(this.getUploadFileName());
        fileModel.setUploadContentType(this.getUploadContentType());
        fileModel.setLength(Long.valueOf(this.getUpload().length()));
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(this.getUpload());
            BufferedImage image = ImageIO.read(fileInputStream);
            if (image == null) {
                throw new PortalBizException("405");
            }
            fileModel.setHeight(Integer.valueOf(image.getHeight()));
            fileModel.setWidth(Integer.valueOf(image.getWidth()));
            FileModel fileModel2 = fileModel;
            return fileModel2;
        }
    }

    private PagingResult<PubFile> findPubImageList4Upload(String displayName) throws PortalBizException {
        PubFile pubFile = new PubFile();
        pubFile.setFileType(FileTypeEnum.COMMON_IMG);
        PagingResult pagingResult = new PagingResult();
        pagingResult = this.pubFileService.findPubFileList(this.getPortalContext(), pubFile, this.pagingParam, displayName);
        if (pagingResult != null && pagingResult.getRecords() != null && !pagingResult.getRecords().isEmpty()) {
            for (PubFile tempPubFile : pagingResult.getRecords()) {
                tempPubFile.setContent(null);
            }
        }
        return pagingResult;
    }

    private PagingResult<PubFile> findPubImageList4SysIcon(String searchText) throws PortalBizException {
        File sysIconDir = new File(Constant.SYSTEM_ROOT_PATH + PubConstant.SYS_ICONS_PATH);
        if (!sysIconDir.exists() || !sysIconDir.isDirectory()) {
            throw new PortalBizException("404");
        }
        String[] imgList = sysIconDir.list();
        ArrayList<PubFile> pubFileList = new ArrayList<PubFile>();
        for (String img : imgList) {
            if (img.endsWith(".svn") || img.endsWith(".txt") || img.endsWith(".db")) continue;
            PubFile pubFile = new PubFile();
            pubFile.setId(img);
            String displayNameStr = this.getDisplayName4Sys(img);
            if (!StringUtil.isEmpty((String)searchText) && !displayNameStr.contains(searchText)) continue;
            DisplayName displayName = new DisplayName();
            displayName.setEn(displayNameStr);
            displayName.setZh_CN(displayNameStr);
            displayName.setZh_TW(displayNameStr);
            pubFile.setDisplayName(displayName.toString());
            pubFileList.add(pubFile);
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setTotalCount(pubFileList.size());
        pagingResult.setPagingParam(this.pagingParam);
        int fromIndex = this.pagingParam.getStartIndex();
        int toIndex = fromIndex + this.pagingParam.getPageSize();
        if (toIndex > pubFileList.size()) {
            toIndex = pubFileList.size();
        }
        List subPubFileList = pubFileList.subList(fromIndex, toIndex);
        pagingResult.setRecords(subPubFileList);
        return pagingResult;
    }

    private PagingResult<PubFile> findPubImageList4Portlet(String searchText) throws PortalBizException {
        File sysIconDir = new File(Constant.SYSTEM_ROOT_PATH + PubConstant.QUICK_ICONS_PATH);
        if (!sysIconDir.exists() || !sysIconDir.isDirectory()) {
            throw new PortalBizException("404");
        }
        String[] imgList = sysIconDir.list();
        ArrayList<PubFile> pubFileList = new ArrayList<PubFile>();
        for (String img : imgList) {
            if (img.endsWith(".svn") || img.endsWith(".txt") || img.endsWith(".db")) continue;
            PubFile pubFile = new PubFile();
            pubFile.setId(img);
            String displayNameStr = this.getDisplayName4Quick(img);
            if (!StringUtil.isEmpty((String)searchText) && !displayNameStr.contains(searchText)) continue;
            DisplayName displayName = new DisplayName();
            displayName.setEn(displayNameStr);
            displayName.setZh_CN(displayNameStr);
            displayName.setZh_TW(displayNameStr);
            pubFile.setDisplayName(displayName.toString());
            pubFileList.add(pubFile);
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setTotalCount(pubFileList.size());
        pagingResult.setPagingParam(this.pagingParam);
        int fromIndex = this.pagingParam.getStartIndex();
        int toIndex = fromIndex + this.pagingParam.getPageSize();
        if (toIndex > pubFileList.size()) {
            toIndex = pubFileList.size();
        }
        List subPubFileList = pubFileList.subList(fromIndex, toIndex);
        pagingResult.setRecords(subPubFileList);
        return pagingResult;
    }

    private String getDisplayName4Sys(String img) {
        String displayName = StringUtil.convNull((String)img);
        if (displayName.startsWith("sys_")) {
            displayName = displayName.substring("sys_".length());
        }
        displayName = displayName.substring(0, displayName.lastIndexOf("."));
        return displayName;
    }

    private String getDisplayName4Quick(String img) {
        String displayName = StringUtil.convNull((String)img);
        if (displayName.startsWith("app_")) {
            displayName = displayName.substring("app_".length());
        }
        displayName = displayName.substring(0, displayName.lastIndexOf("."));
        return displayName;
    }

    public void setCropModel(CropModel cropModel) {
        this.cropModel = cropModel;
    }

    public CropModel getCropModel() {
        return this.cropModel;
    }

    public ImgDTO getImgDTO() {
        return this.imgDTO;
    }

    public void setImgDTO(ImgDTO imgDTO) {
        this.imgDTO = imgDTO;
    }
}

