/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.setting.action;

import com.kingdee.eas.base.license.EditionTypeEnum;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.biz.module.setting.dto.PortalProfileModel;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import com.kingdee.portal.biz.module.setting.service.LogoSettingService;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.FileUtil;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalSettingAction
extends BaseFileUploadAction {
    private static final long serialVersionUID = -2503118130374158270L;
    private static final Logger logger = LoggerFactory.getLogger(PersonalSettingAction.class);
    private SettingService settingService = (SettingService)PortalServiceLocator.getBean((String)"settingService");
    private LogoSettingService logoSettingService = (LogoSettingService)PortalServiceLocator.getBean((String)"logoSettingService");
    private String[] types = new String[]{"top", "login", "bg1", "big_bg1", "full_bg1"};
    private String[] langs = new String[]{"ch", "tw", "en"};

    public String findPersonalSetting() throws Exception {
        try {
            PortalProfileModel pf = this.settingService.getPortalProfileModel(this.getPortalContext());
            this.writeAjaxData(true, null, pf);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            this.writeData("result", pe.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", e.getMessage());
            return null;
        }
        return null;
    }

    public String uploadLogo() {
        HashMap<String, String> logoMap;
        boolean success = true;
        FileModel fileModel = null;
        String insId = this.getRequest().getParameter("insId");
        String type = this.getRequest().getParameter("type");
        String chooseLang = this.getRequest().getParameter("chooseLanguage_" + type);
        String dataCenter = this.getRequest().getParameter("dataCenter");
        logger.info("upload insId:" + insId + ",chooseLanguage:" + chooseLang + ",dataCenter:" + dataCenter + ",type=" + type);
        try {
            this.copyFile2UploadFolder();
            fileModel = new FileModel();
            fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
            fileModel.setUploadFileName(this.getUploadFileName());
            fileModel.setUploadContentType(this.getUploadContentType());
            File file = this.getUpload();
            if (file != null) {
                logger.info("fileName:" + file.getAbsolutePath());
            }
            this.getRequest().setAttribute("logoName", (Object)this.getUpload().getName());
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"uploadTempImg");
        this.getRequest().setAttribute("insId", (Object)insId);
        this.getRequest().setAttribute("chooseLang", (Object)chooseLang);
        this.getRequest().setAttribute("dataCenter", (Object)dataCenter);
        this.getRequest().setAttribute("type", (Object)(type + "Logo"));
        HashMap<String, HashMap<String, String>> logoMaps = (HashMap<String, HashMap<String, String>>)this.getRequest().getSession().getAttribute("logoMaps");
        if (logoMaps == null) {
            logoMaps = new HashMap<String, HashMap<String, String>>();
        }
        if ((logoMap = (HashMap<String, String>)logoMaps.get(insId)) == null) {
            logoMap = new HashMap<String, String>();
        }
        logoMap.put(type + "Logo_" + chooseLang, this.getUpload().getPath());
        logoMaps.put(insId, logoMap);
        this.getRequest().getSession().setAttribute("logoMaps", logoMaps);
        logger.info("upload " + type + "Logo_" + chooseLang + ":" + this.getUpload().getPath());
        return "success";
    }

    public String modifyPersonalSetting() throws Exception {
        String resultErr = "";
        try {
            String result = "true";
            resultErr = "false";
            String insId = this.getRequest().getParameter("insId");
            String dataCenter = this.getRequest().getParameter("dataCenter");
            String plttmpl = this.getRequest().getParameter("plttmpl");
            String plttheme = this.getRequest().getParameter("plttheme");
            String pagetheme = this.getRequest().getParameter("pagetheme");
            String bgShowType = this.getRequest().getParameter("bgShowType");
            if (StringUtils.isEmpty((String)bgShowType)) {
                bgShowType = "PART_BG;PART_BG;PART_BG";
            }
            logger.error("insId:" + insId + ",plttmpl:" + plttmpl + ",plttheme:" + plttheme + ",bgShowType:" + bgShowType);
            PortalProfileModel portalProfileModel = new PortalProfileModel();
            portalProfileModel.setDefaultPortletTmpl(plttmpl);
            portalProfileModel.setDefaultPortletTheme(plttheme);
            portalProfileModel.setDefaultBackgroundShowType(bgShowType);
            portalProfileModel.setDefaultPageTheme(pagetheme);
            this.settingService.updatePortalProfile(this.getPortalContext(), portalProfileModel);
            this.copySessionLogos(insId, dataCenter);
            this.clearSession(insId);
            PortalCache.freshPortalProfileMap();
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        catch (Exception E) {
            logger.error(E.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    private String getFilePrePath(String type) {
        if ("top".equals(type)) {
            return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "img" + Constant.SYSTEM_PATH_SEPARATOR + "global" + Constant.SYSTEM_PATH_SEPARATOR + "common" + Constant.SYSTEM_PATH_SEPARATOR;
        }
        int lIndex = Constant.SYSTEM_ROOT_PATH.indexOf("portal.ear");
        String tempPath = Constant.SYSTEM_ROOT_PATH.substring(0, lIndex);
        return tempPath + "eas.ear" + Constant.SYSTEM_PATH_SEPARATOR + "sso_web.war" + Constant.SYSTEM_PATH_SEPARATOR + "images" + Constant.SYSTEM_PATH_SEPARATOR + "newlogin1" + Constant.SYSTEM_PATH_SEPARATOR;
    }

    private String getUploadFilePath() {
        return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "file" + Constant.SYSTEM_PATH_SEPARATOR + "upload" + Constant.SYSTEM_PATH_SEPARATOR;
    }

    public String restoreLogin() throws Exception {
        String result = "\u64cd\u4f5c\u6210\u529f";
        try {
            HashMap<String, String> logoMap;
            String insId = this.getRequest().getParameter("insId");
            String lang = this.getRequest().getParameter("lang");
            String dataCenter = this.getRequest().getParameter("dataCenter");
            logger.info("insId:" + insId + ",lang:" + lang);
            String srcFile = this.getFilePrePath("login") + "login_logo_default_" + lang + ".png";
            String targetFile = this.getUploadFilePath() + "login_logo_default_" + lang + ".png";
            FileUtils.copyFile((File)new File(srcFile), (File)new File(targetFile));
            HashMap<String, HashMap<String, String>> logoMaps = (HashMap<String, HashMap<String, String>>)this.getRequest().getSession().getAttribute("logoMaps");
            if (logoMaps == null) {
                logoMaps = new HashMap<String, HashMap<String, String>>();
            }
            if ((logoMap = (HashMap<String, String>)logoMaps.get(insId)) == null) {
                logoMap = new HashMap<String, String>();
            }
            logoMap.put("loginLogo_" + lang, targetFile);
            logoMaps.put(insId, logoMap);
            this.getRequest().getSession().setAttribute("logoMaps", logoMaps);
        }
        catch (Exception e) {
            logger.error("restoreLogin error", (Throwable)e);
        }
        this.writeData("result", result);
        return null;
    }

    public String restoreTop() throws Exception {
        String result = "\u64cd\u4f5c\u6210\u529f";
        try {
            HashMap<String, String> logoMap;
            String insId = this.getRequest().getParameter("insId");
            String lang = this.getRequest().getParameter("lang");
            String dataCenter = this.getRequest().getParameter("dataCenter");
            logger.info("insId:" + insId + ",lang:" + lang + ",dataCenter:" + dataCenter);
            String srcFileName = "top_logo_default_" + lang + ".png";
            ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
            EditionTypeEnum editionType = iLicenseSrvAgent.getEditionType();
            if (editionType != null) {
                if (EditionTypeEnum.ENTERPRISE_LIMIT.compareTo((Object)editionType) == 0) {
                    srcFileName = "top_logo_default_time_" + lang + ".png";
                } else if (EditionTypeEnum.EDUCATION.compareTo((Object)editionType) == 0) {
                    srcFileName = "top_logo_default_tech_" + lang + ".png";
                } else if (EditionTypeEnum.EDUCATION_LIMIT.compareTo((Object)editionType) == 0) {
                    srcFileName = "top_logo_default_tech_" + lang + ".png";
                }
            }
            String srcFile = this.getFilePrePath("top") + srcFileName;
            String targetFile = this.getUploadFilePath() + "top_logo_default_" + lang + ".png";
            FileUtils.copyFile((File)new File(srcFile), (File)new File(targetFile));
            HashMap<String, HashMap<String, String>> logoMaps = (HashMap<String, HashMap<String, String>>)this.getRequest().getSession().getAttribute("logoMaps");
            if (logoMaps == null) {
                logoMaps = new HashMap<String, HashMap<String, String>>();
            }
            if ((logoMap = (HashMap<String, String>)logoMaps.get(insId)) == null) {
                logoMap = new HashMap<String, String>();
            }
            logoMap.put("topLogo_" + lang, targetFile);
            logoMap.put("del_topLogo_" + lang, targetFile);
            logoMaps.put(insId, logoMap);
            this.getRequest().getSession().setAttribute("logoMaps", logoMaps);
        }
        catch (Exception e) {
            logger.error("restoreTop error", (Throwable)e);
        }
        this.writeData("result", result);
        return null;
    }

    public String restoreBG() throws Exception {
        HashMap<String, String> logoMap;
        HashMap logoMaps;
        String result = "\u64cd\u4f5c\u6210\u529f";
        String insId = this.getRequest().getParameter("insId");
        String lang = this.getRequest().getParameter("lang");
        String dataCenter = this.getRequest().getParameter("dataCenter");
        logger.info("insId:" + insId + ",lang:" + lang + ",dataCenter:" + dataCenter);
        String restoreType = this.getRequest().getParameter("restoreType");
        if (StringUtils.isEmpty((String)restoreType)) {
            restoreType = "part";
        }
        if ((logoMaps = (HashMap)this.getRequest().getSession().getAttribute("logoMaps")) == null) {
            logoMaps = new HashMap();
        }
        if ((logoMap = (HashMap<String, String>)logoMaps.get(insId)) == null) {
            logoMap = new HashMap<String, String>();
        }
        if ("part".equals(restoreType)) {
            for (int i = 2; i < this.types.length - 1; ++i) {
                String srcFile = this.getFilePrePath(this.types[i]) + this.types[i] + "_logo_default_" + lang + ".png";
                String targetFile = this.getUploadFilePath() + this.types[i] + "_logo_default_" + lang + ".png";
                FileUtils.copyFile((File)new File(srcFile), (File)new File(targetFile));
                logoMap.put(this.types[i] + "Logo_" + lang, targetFile);
            }
        } else if ("full".equals(restoreType)) {
            int i = this.types.length - 1;
            String srcFile = this.getFilePrePath(this.types[i]) + this.types[i] + "_logo_default_" + lang + ".png";
            String targetFile = this.getUploadFilePath() + this.types[i] + "_logo_default_" + lang + ".png";
            FileUtils.copyFile((File)new File(srcFile), (File)new File(targetFile));
            logoMap.put(this.types[i] + "Logo_" + lang, targetFile);
        }
        logoMap.put("bgMode_" + lang, "3");
        logoMaps.put(insId, logoMap);
        this.getRequest().getSession().setAttribute("logoMaps", logoMaps);
        this.writeData("result", result);
        return null;
    }

    public String clearSession() throws Exception {
        String result = "\u64cd\u4f5c\u6210\u529f";
        String insId = this.getRequest().getParameter("insId");
        logger.info("insId:" + insId);
        HashMap logoMaps = (HashMap)this.getRequest().getSession().getAttribute("logoMaps");
        logger.info("logoMaps:" + logoMaps);
        if (logoMaps != null) {
            logoMaps.remove(insId);
        }
        this.getRequest().getSession().setAttribute("logoMaps", (Object)logoMaps);
        this.writeData("result", result);
        return null;
    }

    public String bgModeChange() throws Exception {
        String resultErr = "";
        try {
            HashMap<String, String> logoMap;
            String result = "\u64cd\u4f5c\u6210\u529f";
            resultErr = "\u64cd\u4f5c\u5931\u8d25";
            String insId = this.getRequest().getParameter("insId");
            String lang = this.getRequest().getParameter("lang");
            String bgMode = this.getRequest().getParameter("bgMode");
            logger.info("insId:" + insId + ",lang:" + lang + ",bgMode:" + bgMode);
            HashMap<String, HashMap<String, String>> logoMaps = (HashMap<String, HashMap<String, String>>)this.getRequest().getSession().getAttribute("logoMaps");
            if (logoMaps == null) {
                logoMaps = new HashMap<String, HashMap<String, String>>();
            }
            if ((logoMap = (HashMap<String, String>)logoMaps.get(insId)) == null) {
                logoMap = new HashMap<String, String>();
            }
            logoMap.put("bgMode_" + lang, bgMode);
            logoMaps.put(insId, logoMap);
            this.getRequest().getSession().setAttribute("logoMaps", logoMaps);
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String langChange() throws Exception {
        String resultErr = "";
        try {
            String result = "\u64cd\u4f5c\u6210\u529f";
            resultErr = "\u64cd\u4f5c\u5931\u8d25";
            String insId = this.getRequest().getParameter("insId");
            String lang = this.getRequest().getParameter("lang");
            logger.info("insId:" + insId + ",lang:" + lang);
            PortalProfile portalProfile = this.settingService.findPortalProfileByConfigItem("default_portal_bgMode_" + lang);
            String bgMode = portalProfile.getConfigValue();
            HashMap logoMaps = (HashMap)this.getRequest().getSession().getAttribute("logoMaps");
            logger.info("logoMaps:" + logoMaps);
            if (logoMaps != null) {
                String tempBgMode;
                HashMap logoMap = (HashMap)logoMaps.get(insId);
                logger.info("logoMap:" + logoMap + ",insId:" + insId);
                if (logoMap != null && (tempBgMode = (String)logoMap.get("bgMode_" + lang)) != null) {
                    bgMode = tempBgMode;
                }
            }
            logger.info("langChange bgMode: " + bgMode);
            this.writeLangChangeResult(bgMode);
        }
        catch (Exception E) {
            logger.error(E.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    private String getFileName(String filePath) {
        filePath = filePath.replaceAll("\\\\", "/");
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        logger.info("getFileName:" + fileName);
        return fileName;
    }

    private void clearSession(String insId) {
        HashMap logoMaps = (HashMap)this.getRequest().getSession().getAttribute("logoMaps");
        if (logoMaps != null) {
            logoMaps.remove(insId);
        }
    }

    private void copySessionLogos(String insId, String dataCenter) {
        HashMap logoMaps = (HashMap)this.getRequest().getSession().getAttribute("logoMaps");
        logger.info("logoMaps:" + logoMaps);
        if (logoMaps != null) {
            HashMap logoMap = (HashMap)logoMaps.get(insId);
            logger.info("logoMap:" + logoMap + ",insId:" + insId);
            if (logoMap != null) {
                String bgMode3;
                String bgMode2;
                int i;
                int j;
                for (j = 0; j < this.types.length; ++j) {
                    for (i = 0; i < this.langs.length; ++i) {
                        String srcFilePath = (String)logoMap.get(this.types[j] + "Logo_" + this.langs[i]);
                        logger.info("srcFilePath:" + srcFilePath);
                        if (srcFilePath == null || "".equals(srcFilePath)) continue;
                        byte[] imgContent = FileUtil.getByteArrayData((String)srcFilePath);
                        try {
                            String filePath = this.getFilePrePath(this.types[j]);
                            String fileName = this.types[j] + "_logo_" + dataCenter + "_" + this.langs[i] + ".png";
                            File file = new File(filePath + fileName);
                            FileUtils.writeByteArrayToFile((File)file, (byte[])imgContent);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                for (j = 0; j < this.types.length; ++j) {
                    for (i = 0; i < this.langs.length; ++i) {
                        try {
                            String tFile = (String)logoMap.get("del_" + this.types[j] + "Logo_" + this.langs[i]);
                            if (tFile == null || "".equals(tFile) || tFile.indexOf("top_logo_default_" + this.langs[i]) >= 0) continue;
                            this.logoSettingService.deleteLogoSettingByLogoName(this.types[j] + "_logo_" + dataCenter + "_" + this.langs[i] + ".png");
                            continue;
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                PortalProfileModel portalProfile = new PortalProfileModel();
                String bgMode1 = (String)logoMap.get("bgMode_" + this.langs[0]);
                if (bgMode1 != null) {
                    portalProfile.setDefault_portal_bgmode_ch(bgMode1);
                }
                if ((bgMode2 = (String)logoMap.get("bgMode_" + this.langs[1])) != null) {
                    portalProfile.setDefault_portal_bgmode_tw(bgMode2);
                }
                if ((bgMode3 = (String)logoMap.get("bgMode_" + this.langs[2])) != null) {
                    portalProfile.setDefault_portal_bgmode_en(bgMode3);
                }
                try {
                    this.settingService.updatePortalProfile(this.getPortalContext(), portalProfile);
                }
                catch (Exception e) {
                    logger.error("updatePortalProfile error! ", (Throwable)e);
                }
            }
        }
    }

    private void writeData(String skey, String svalue) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private void writeLangChangeResult(String bgMode) {
        HashMap<String, String> ajaxData = new HashMap<String, String>();
        ajaxData.put("bgMode", bgMode);
        this.writeObjectData(JSONUtil.getJson4Object(ajaxData), ResponseContentTypeEnum.JSON);
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }
}

