/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.setting.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.setting.dto.LinksDTO;
import com.kingdee.portal.biz.module.setting.dto.PortalProfileModel;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.JSONUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspensionBtnAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(SuspensionBtnAction.class);
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private SettingService settingService = (SettingService)PortalServiceLocator.getBean((String)"settingService");

    public void saveSecondLink() throws Exception {
        try {
            String secondLinkJSON = this.getRequest().getParameter("secondLink");
            Map map4Json = JSONUtil.getMap4Json((String)secondLinkJSON);
            String parentId = map4Json.get("parentId").toString();
            JSONArray linksArray = (JSONArray)map4Json.get("links");
            List list = JSONArray.toList((JSONArray)linksArray, LinksDTO.class);
            this.settingService.saveSecondLink(secondLinkJSON, parentId, list);
            this.writeData("result", "true");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", "false");
        }
    }

    public void saveFirstBtn() throws Exception {
        try {
            boolean isDisable = "true".equalsIgnoreCase(this.getRequest().getParameter("isDisable"));
            this.updateSuspensionBtnStatus(isDisable);
            String firstBtnJSON = this.getRequest().getParameter("firstBtn");
            Map map4Json = JSONUtil.getMap4Json((String)firstBtnJSON);
            JSONArray personalBtnsArray = (JSONArray)map4Json.get("personalBtns");
            JSONArray defaultBtnsArray = (JSONArray)map4Json.get("defaultBtns");
            List defaultList = JSONArray.toList((JSONArray)defaultBtnsArray, LinksDTO.class);
            List personalList = JSONArray.toList((JSONArray)personalBtnsArray, LinksDTO.class);
            this.settingService.saveFirstBtn(defaultList, personalList);
            this.writeData("result", "true");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", "false");
        }
    }

    public void findFirstBtnConfig() throws Exception {
        try {
            Map mapDefault = this.settingService.findDefaultBtnMap();
            Map mapPersonal = this.settingService.findPersonaBtnMap();
            JSONObject obj = new JSONObject();
            obj.put((Object)"mapPersonal", (Object)mapPersonal);
            obj.put((Object)"mapDefault", (Object)mapDefault);
            obj.put((Object)"isDisable", (Object)this.isDisableSuspensionBtn());
            this.writeAjaxData(true, null, obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", "false");
        }
    }

    public void findSecondLinkConfig() throws Exception {
        try {
            String parentId = this.getRequest().getParameter("parentId");
            Map map = this.settingService.findSecondLinkConfig(parentId);
            JSONObject obj = new JSONObject();
            obj.put((Object)"secondLinks", (Object)map);
            this.writeAjaxData(true, null, obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", "false");
        }
    }

    public void findSuspensionBtnInfo() throws Exception {
        try {
            if (this.isDisableSuspensionBtn()) {
                this.writeData("result", "false");
                return;
            }
            Map mapDefault = this.settingService.findDefaultBtnMapEnable();
            Map mapPersonal = this.settingService.findPersonBtnMapEnable();
            JSONObject obj = new JSONObject();
            obj.put((Object)"mapPersonal", (Object)mapPersonal);
            obj.put((Object)"mapDefault", (Object)mapDefault);
            this.writeAjaxData(true, null, obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.writeData("result", "false");
        }
    }

    private void updateSuspensionBtnStatus(boolean isDisable) throws PortalBizException {
        PortalProfileModel portalProfile = new PortalProfileModel();
        portalProfile.setEnable_suspension_btn(isDisable ? "DISABLE" : "ENABLE");
        this.settingService.updatePortalProfile(this.getPortalContext(), portalProfile);
    }

    private boolean isDisableSuspensionBtn() {
        try {
            PortalProfileModel pf = this.settingService.getPortalProfileModel(this.getPortalContext());
            String enable_suspension_btn = pf.getEnable_suspension_btn();
            return !"ENABLE".equalsIgnoreCase(enable_suspension_btn);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return true;
        }
    }

    private void writeData(String skey, String svalue) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }
}

