/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.tfv.module.tfv.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.tfv.DVCommonStatusEnum;
import com.kingdee.eas.cp.tfv.DocumentViewFactory;
import com.kingdee.eas.cp.tfv.DocumentViewReceiversFactory;
import com.kingdee.eas.cp.tfv.DocumentViewReceiversInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.tfv.module.tfv.dto.DocumentViewDTO;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;

public class InboxAction
extends BaseAction {
    public void inboxList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String title = this.getRequest().getParameter("title");
        String sendPersonId = this.getRequest().getParameter("sendPersonId");
        String urgency = this.getRequest().getParameter("urgency");
        String beginDate = this.getRequest().getParameter("beginDate");
        String endDate = this.getRequest().getParameter("endDate");
        String viewStatus = this.getRequest().getParameter("viewStatus");
        String orderByField = "docView.sentTime";
        String orderType = SortType.DESCEND.toString();
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer sb = new StringBuffer(" #0 and #1 and ( #2 or #3 ) ");
        if (userInfo.getPerson() == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("DOCUMENTVIEWRECEIVERS.person.id", (Object)"false", CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("DOCUMENTVIEWRECEIVERS.person.id", (Object)userInfo.getPerson().getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"availability", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("docView.status", (Object)"availability", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("docView.status", (Object)"deleted", CompareType.EQUALS));
        int queryCount = 0;
        if (!StringUtil.isEmpty((String)title)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("docView.title", (Object)("%" + title + "%"), CompareType.LIKE));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)sendPersonId)) {
            String[] sendPersonIdArr = sendPersonId.split(";");
            HashSet<String> sendPersonIdSet = new HashSet<String>();
            for (String id : sendPersonIdArr) {
                sendPersonIdSet.add(id);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", sendPersonIdSet, CompareType.INCLUDE));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)urgency)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("docView.urgency", (Object)urgency, CompareType.EQUALS));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)beginDate)) {
            beginDate = beginDate + " 00:00:00.0";
            filterInfo.getFilterItems().add(new FilterItemInfo("docView.sentTime", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)endDate)) {
            endDate = endDate + " 23:59:59.9";
            filterInfo.getFilterItems().add(new FilterItemInfo("docView.sentTime", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)viewStatus)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("viewStatus", (Object)viewStatus, CompareType.EQUALS));
            ++queryCount;
        }
        for (int i = 0; i < queryCount; ++i) {
            sb.append(" and #").append(i + 4);
        }
        filterInfo.setMaskString(sb.toString());
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.tfv.app", "DocViewReceiversQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            exec.option().isAutoTranslateEnum = false;
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<DocumentViewDTO> list = new ArrayList<DocumentViewDTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    DocumentViewDTO documentViewDTO = new DocumentViewDTO();
                    documentViewDTO.setDocViewReceiveId(rowSet.getString("id"));
                    documentViewDTO.setTitle(rowSet.getString("docView.title"));
                    documentViewDTO.setSendPersonName(rowSet.getString("sendPerson.name"));
                    documentViewDTO.setSendTime(rowSet.getString("docView.sentTime").substring(0, 16));
                    documentViewDTO.setUrgency(rowSet.getString("docView.urgency"));
                    documentViewDTO.setDisplaySize(rowSet.getString("docView.displaySize"));
                    documentViewDTO.setDocViewId(rowSet.getString("docView.id"));
                    documentViewDTO.setViewStatus(rowSet.getString("viewStatus"));
                    list.add(documentViewDTO);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFileView() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean succ = false;
        LocalErr localErr = null;
        String docViewReceicerIds = this.getRequest().getParameter("ids");
        String docViewIdS = this.getRequest().getParameter("docViewIdS");
        String[] docViewReceicerIdsArr = docViewReceicerIds.split(",");
        String[] docViewIdSArr = docViewIdS.split(",");
        try {
            int j = docViewReceicerIdsArr.length;
            for (int i = 0; i < j; ++i) {
                if (this.isLastReceivers(docViewIdSArr[i], docViewReceicerIdsArr[i])) {
                    DocumentViewFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(docViewIdSArr[i]));
                    continue;
                }
                ObjectUuidPK tempPK = new ObjectUuidPK(docViewReceicerIdsArr[i]);
                DocumentViewReceiversInfo docViewReceiversInfo = DocumentViewReceiversFactory.getLocalInstance((Context)ctx).getDocumentViewReceiversInfo((IObjectPK)tempPK);
                docViewReceiversInfo.setStatus(DVCommonStatusEnum.DELETED);
                DocumentViewReceiversFactory.getLocalInstance((Context)ctx).update((IObjectPK)tempPK, (CoreBaseInfo)docViewReceiversInfo);
            }
            IFMEService service = FMEServiceFactory.getServiceInstance((Context)ctx);
            service.deleteFile(docViewIdSArr);
            succ = true;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void markView() {
        String ids = this.getRequest().getParameter("ids");
        String view = this.getRequest().getParameter("view");
        LocalErr localErr = null;
        boolean succ = false;
        succ = this.turnViewStatus(DVCommonStatusEnum.getEnum((String)view), ids);
        this.writeAjaxData(succ, localErr, null);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private boolean turnViewStatus(DVCommonStatusEnum viewStatus, String ids) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean succ = false;
        try {
            String[] idArr;
            for (String id : idArr = ids.split(",")) {
                ObjectUuidPK tempPK = new ObjectUuidPK(id);
                DocumentViewReceiversInfo docViewReceiversInfo = DocumentViewReceiversFactory.getLocalInstance((Context)ctx).getDocumentViewReceiversInfo((IObjectPK)tempPK);
                docViewReceiversInfo.setViewStatus(viewStatus);
                docViewReceiversInfo.setViewTime(new Timestamp(new Date().getTime()));
                DocumentViewReceiversFactory.getLocalInstance((Context)ctx).update((IObjectPK)tempPK, (CoreBaseInfo)docViewReceiversInfo);
            }
            succ = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return succ;
    }

    private boolean isLastReceivers(String docViewID, String docViewReceiverID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean isLast = true;
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from T_TFV_DocViewReceivers ");
        sql.append(" where fdocviewID = ?  and fid != ?  and fstatus=? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{docViewID, docViewReceiverID, "availability"});
            if (rowSet != null && rowSet.next()) {
                isLast = false;
            }
            if (isLast) {
                sql = new StringBuffer();
                sql.append(" select fstatus from T_TFV_DocumentView where fid=? and fstatus = ? ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{docViewID, "availability"});
                if (rowSet != null && rowSet.next()) {
                    isLast = false;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isLast;
    }
}

