/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.tfv.module.tfv.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.tfv.DVCommonStatusEnum;
import com.kingdee.eas.cp.tfv.DocumentViewFactory;
import com.kingdee.eas.cp.tfv.DocumentViewInfo;
import com.kingdee.eas.cp.tfv.DocumentViewReceiversCollection;
import com.kingdee.eas.cp.tfv.DocumentViewReceiversFactory;
import com.kingdee.eas.cp.tfv.DocumentViewReceiversInfo;
import com.kingdee.eas.cp.tfv.IDocumentView;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.tfv.module.tfv.dto.DocumentViewDTO;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class MyboxAction
extends BaseAction {
    public void myboxList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String title = this.getRequest().getParameter("title");
        String receiversId = this.getRequest().getParameter("receiversId");
        String urgency = this.getRequest().getParameter("urgency");
        String beginDate = this.getRequest().getParameter("beginDate");
        String endDate = this.getRequest().getParameter("endDate");
        String sendStatus = this.getRequest().getParameter("sendStatus");
        String orderByField = "sentTime";
        String orderType = SortType.DESCEND.toString();
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer sb = new StringBuffer(" #0 and #1 ");
        if ("draft".equals(sendStatus)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)DVCommonStatusEnum.DRAFT.getValue(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)DVCommonStatusEnum.AVAILABILITY.getValue(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)userInfo.getPerson().getId().toString(), CompareType.EQUALS));
        int queryCount = 0;
        if (!StringUtil.isEmpty((String)title)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("title", (Object)("%" + title + "%"), CompareType.LIKE));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)receiversId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.transUser(receiversId), CompareType.INNER));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)urgency)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("urgency", (Object)urgency, CompareType.EQUALS));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)beginDate)) {
            beginDate = beginDate + " 00:00:00.0";
            filterInfo.getFilterItems().add(new FilterItemInfo("sentTime", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS));
            ++queryCount;
        }
        if (!StringUtil.isEmpty((String)endDate)) {
            endDate = endDate + " 23:59:59.9";
            filterInfo.getFilterItems().add(new FilterItemInfo("sentTime", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS));
            ++queryCount;
        }
        for (int i = 0; i < queryCount; ++i) {
            sb.append(" and #").append(i + 2);
        }
        filterInfo.setMaskString(sb.toString());
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.tfv.app", "DocumentViewQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            exec.option().isAutoTranslateEnum = false;
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<DocumentViewDTO> list = new ArrayList<DocumentViewDTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    DocumentViewDTO documentViewDTO = new DocumentViewDTO();
                    documentViewDTO.setDocViewId(rowSet.getString("id"));
                    documentViewDTO.setTitle(rowSet.getString("title"));
                    documentViewDTO.setSendTime(rowSet.getString("sentTime").substring(0, 16));
                    documentViewDTO.setUrgency(rowSet.getString("urgency"));
                    documentViewDTO.setDisplaySize(rowSet.getString("displaySize"));
                    list.add(documentViewDTO);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReceivers() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String docViewId = this.getRequest().getParameter("docViewId");
        StringBuffer receivers = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        boolean succ = false;
        LocalErr localErr = null;
        sql.append(" select \"us\".fname_l2 as name ");
        sql.append(" from T_TFV_DocViewReceivers as \"fr\" inner join ");
        sql.append(" T_BD_Person as \"us\" on \"fr\".FPersonID=\"us\".fid ");
        sql.append(" where \"fr\".FDocViewID = ? order by FPersonFlag ASC");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{docViewId});
            if (rowSet != null) {
                while (rowSet.next()) {
                    receivers.append(rowSet.getString("name")).append(";");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int index = receivers.lastIndexOf(";");
        if (index > 0) {
            succ = true;
        }
        this.writeAjaxData(succ, localErr, receivers.substring(0, index).toString());
    }

    public String getReceivers(String docViewId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        StringBuffer receivers = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(" select \"us\".fname_l2 as name ");
        sql.append(" from T_TFV_DocViewReceivers as \"fr\" inner join ");
        sql.append(" T_BD_Person as \"us\" on \"fr\".FPersonID=\"us\".fid ");
        sql.append(" where \"fr\".FDocViewID = ? order by FPersonFlag ASC");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{docViewId});
            if (rowSet != null) {
                while (rowSet.next()) {
                    receivers.append(rowSet.getString("name")).append(";");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int index = receivers.lastIndexOf(";");
        if (index > 0) {
            // empty if block
        }
        return receivers.substring(0, index).toString();
    }

    public void deleteDocView() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sendStatus = this.getRequest().getParameter("sendStatus");
        String ids = this.getRequest().getParameter("ids");
        String[] idsArr = ids.split(",");
        IDocumentView documentView = null;
        boolean succ = false;
        LocalErr localErr = null;
        IFMEService service = FMEServiceFactory.getServiceInstance((Context)ctx);
        try {
            documentView = DocumentViewFactory.getLocalInstance((Context)ctx);
            if ("draft".equals(sendStatus)) {
                for (String id : idsArr) {
                    documentView.delete((IObjectPK)new ObjectUuidPK(id));
                }
                service.deleteFile(idsArr);
                succ = true;
            } else if ("sended".equals(sendStatus)) {
                for (String id : idsArr) {
                    if (this.hasNoDeleteReceivers(ctx, id)) {
                        DocumentViewInfo docViewInfo = documentView.getDocumentViewInfo((IObjectPK)new ObjectUuidPK(id));
                        docViewInfo.setStatus(DVCommonStatusEnum.DELETED);
                        documentView.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)docViewInfo);
                        continue;
                    }
                    documentView.delete((IObjectPK)new ObjectUuidPK(id));
                }
                service.deleteFile(idsArr);
                succ = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            localErr = this.handleErr(e);
            succ = false;
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void docViewDetail() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String id = this.getRequest().getParameter("id");
        String sendType = this.getRequest().getParameter("sendType");
        IDocumentView documentView = null;
        DocumentViewDTO info = new DocumentViewDTO();
        boolean succ = false;
        LocalErr localErr = null;
        try {
            documentView = DocumentViewFactory.getLocalInstance((Context)ctx);
            DocumentViewInfo docViewInfo = documentView.getDocumentViewInfo((IObjectPK)new ObjectUuidPK(id));
            info.setDocViewId(docViewInfo.getId().toString());
            info.setTitle(docViewInfo.getTitle());
            info.setUrgency(docViewInfo.getUrgency().getAlias());
            info.setSendTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(docViewInfo.getSentTime()));
            info.setSendPersonName(PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(docViewInfo.getSendPerson().getId().toString())).getName());
            info.setReceverName(this.getReceivers(id));
            info.setIsMarkView(String.valueOf(docViewInfo.isIsMarkView()));
            info.setIsSendMsg(String.valueOf(docViewInfo.isIsSendMsg()));
            info.setIsSendUrgentMsg(String.valueOf(docViewInfo.isIsSendUrgentMsg()));
            if (this.existsAttachmentId(ctx, docViewInfo.getId().toString())) {
                AttachmentInfo attachInfo = this.getAttacheByBizID(ctx, docViewInfo.getId().toString());
                if (attachInfo != null && null != attachInfo.getFile()) {
                    info.setBodyContent(new String(attachInfo.getFile()));
                }
            } else {
                info.setBodyContent(docViewInfo.getText());
            }
            if ("receive".equals(sendType)) {
                String viewState = this.getRequest().getParameter("viewState");
                if ("unview".equals(viewState)) {
                    this.setReceiverViewStatus(ctx, docViewInfo);
                }
            } else if ("sended".equals(sendType)) {
                this.setReadStatus(docViewInfo, info);
            }
            succ = true;
        }
        catch (BOSException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
        }
        this.writeAjaxData(succ, localErr, info);
    }

    private void setReadStatus(DocumentViewInfo docView, DocumentViewDTO info) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        if (docView != null && docView.isIsMarkView()) {
            DocumentViewReceiversCollection receivers = docView.getReceivers();
            try {
                IPerson ipreson = PersonFactory.getLocalInstance((Context)ctx);
                if (receivers != null) {
                    int size = receivers.size();
                    StringBuffer hasRead = new StringBuffer();
                    StringBuffer notRead = new StringBuffer();
                    for (int i = 0; i < size; ++i) {
                        DocumentViewReceiversInfo receiverInfo = receivers.get(i);
                        if (DVCommonStatusEnum.VIEWED.equals((Object)receiverInfo.getViewStatus())) {
                            Timestamp tempTime = receiverInfo.getViewTime();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                            String personName = ipreson.getPersonInfo((IObjectPK)new ObjectUuidPK(receiverInfo.getPerson().getId().toString())).getName();
                            hasRead.append(personName).append("(").append(format.format(tempTime)).append(")").append(";");
                            continue;
                        }
                        if (!DVCommonStatusEnum.UNVIEW.equals((Object)receiverInfo.getViewStatus())) continue;
                        String personName = ipreson.getPersonInfo((IObjectPK)new ObjectUuidPK(receiverInfo.getPerson().getId().toString())).getName();
                        notRead.append(personName).append(";");
                    }
                    String personOfHasRead = hasRead.toString();
                    String personOfNotRead = notRead.toString();
                    if (personOfHasRead.lastIndexOf(";") > 0) {
                        personOfHasRead = personOfHasRead.substring(0, personOfHasRead.lastIndexOf(";"));
                    }
                    if (personOfNotRead.lastIndexOf(";") > 0) {
                        personOfNotRead = personOfNotRead.substring(0, personOfNotRead.lastIndexOf(";"));
                    }
                    info.setPersonOfHasRead(personOfHasRead);
                    info.setPersonOfNotRead(personOfNotRead);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private void setReceiverViewStatus(Context ctx, DocumentViewInfo model) {
        if (model == null || model.getId() == null) {
            return;
        }
        if (DVCommonStatusEnum.DRAFT.equals((Object)model.getStatus())) {
            return;
        }
        DocumentViewReceiversCollection receiversCols = model.getReceivers();
        if (receiversCols != null) {
            Iterator ite = receiversCols.iterator();
            PersonInfo currentPerson = this.getUserInfo(ctx).getPerson();
            while (ite.hasNext()) {
                DocumentViewReceiversInfo tempReceiverInfo = (DocumentViewReceiversInfo)ite.next();
                PersonInfo tempPerson = tempReceiverInfo.getPerson();
                if (tempPerson == null || currentPerson == null || !tempPerson.getId().toString().equals(currentPerson.getId().toString())) continue;
                if (!DVCommonStatusEnum.UNVIEW.equals((Object)tempReceiverInfo.getViewStatus())) break;
                tempReceiverInfo.setViewStatus(DVCommonStatusEnum.VIEWED);
                tempReceiverInfo.setViewTime(this.getTime());
                try {
                    DocumentViewReceiversFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(tempReceiverInfo.getId()), (CoreBaseInfo)tempReceiverInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean existsAttachmentId(Context ctx, String documentViewID) {
        boolean isExist = false;
        try {
            IBoAttchAsso boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            String oql = "select attachment.id where boID='" + documentViewID + "';";
            isExist = boAtt.exists(oql);
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage());
        }
        catch (EASBizException e) {
            this.logger.error(e.getMessage());
        }
        return isExist;
    }

    private AttachmentInfo getAttacheByBizID(Context ctx, String seleID) {
        AttachmentInfo attachInfo = null;
        try {
            BOSUuid attachID = this.getAttachBOSId(ctx, seleID);
            attachInfo = (AttachmentInfo)AttachmentFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(attachID));
            if (attachInfo.getFile() == null) {
                byte[] files = AttachmentManagerFacadeFactory.getRemoteInstance().downLoad(attachID.toString());
                attachInfo.setFile(files);
            }
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage());
        }
        catch (EASBizException e) {
            this.logger.error(e.getMessage());
        }
        return attachInfo;
    }

    private BOSUuid getAttachBOSId(Context ctx, String seleID) {
        BOSUuid attachID = null;
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        try {
            boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            cols = boAtt.getBoAttchAssoCollection(ev);
            if (cols != null && cols.size() > 0) {
                info = cols.get(0);
            }
            if (info == null) {
                return null;
            }
            attachID = info.getAttachment().getId();
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return attachID;
    }

    private boolean hasNoDeleteReceivers(Context ctx, String docViewID) throws BOSException, SQLException {
        boolean hasNoDeleteReceivers = true;
        StringBuffer sql = new StringBuffer();
        sql.append(" select \"rec\".fid from T_TFV_DocViewReceivers as \"rec\" ");
        sql.append(" inner join T_TFV_DocumentView as \"doc\" on \"rec\".fdocviewid=\"doc\".fid ");
        sql.append(" where \"rec\".fstatus = ? and \"doc\".fid=?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{"availability", docViewID});
        hasNoDeleteReceivers = rowSet != null && rowSet.next();
        return hasNoDeleteReceivers;
    }

    private String transUser(String userId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        int i = 0;
        StringBuffer temp = null;
        String sql = " SELECT  distinct fdocviewid  FROM T_TFV_DocViewReceivers where fpersonid= ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{userId});
            if (rowSet != null) {
                temp = new StringBuffer();
                while (rowSet.next()) {
                    if (i == 0) {
                        temp.append("'").append(rowSet.getString("fdocviewid")).append("'");
                    } else {
                        temp.append(",'").append(rowSet.getString("fdocviewid")).append("'");
                    }
                    ++i;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (i > 0) {
            return temp.toString();
        }
        return null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private UserInfo getUserInfo(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

