/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import javax.portlet.ActionResponse;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletStateAwareResponseContext;
import org.apache.pluto.container.ResourceURLProvider;
import org.apache.pluto.container.impl.StateAwareResponseImpl;
import org.apache.pluto.container.util.ArgumentUtility;

public class ActionResponseImpl
extends StateAwareResponseImpl
implements ActionResponse {
    private boolean stateChanged;
    protected boolean redirected;

    public ActionResponseImpl(PortletActionResponseContext responseContext) {
        super((PortletStateAwareResponseContext)responseContext);
    }

    protected void checkSetRedirected() {
        if (this.stateChanged) {
            throw new IllegalStateException("sendRedirect no longer allowed after navigational state changes");
        }
        if (this.redirected) {
            throw new IllegalStateException("sendRedirect already called");
        }
        this.redirected = true;
    }

    @Override
    protected void checkSetStateChanged() {
        if (this.redirected) {
            throw new IllegalStateException("State change no longer allowed after a sendRedirect");
        }
        this.stateChanged = true;
    }

    protected String getRedirectLocation(String location) {
        ArgumentUtility.validateNotEmpty("location", location);
        ResourceURLProvider provider = this.getResponseContext().getResourceURLProvider();
        if (location.indexOf("://") != -1) {
            provider.setAbsoluteURL(location);
        } else {
            provider.setFullPath(location);
        }
        location = this.getServletResponse().encodeRedirectURL(provider.toString());
        if (location.indexOf("/") == -1) {
            throw new IllegalArgumentException("There is a relative path given, an IllegalArgumentException must be thrown.");
        }
        return location;
    }

    public void sendRedirect(String location) throws IOException {
        location = this.getRedirectLocation(location);
        this.checkSetRedirected();
        ((PortletActionResponseContext)this.getResponseContext()).setRedirect(location);
    }

    public void sendRedirect(String location, String renderUrlParamName) throws IOException {
        ArgumentUtility.validateNotEmpty("renderUrlParamName", renderUrlParamName);
        location = this.getRedirectLocation(location);
        if (!this.redirected) {
            this.stateChanged = false;
        }
        this.checkSetRedirected();
        ((PortletActionResponseContext)this.getResponseContext()).setRedirect(location, renderUrlParamName);
    }
}

