/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.impl.PortletRequestDispatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletPortletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletPortletRequestWrapper.class);
    protected static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    protected static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    protected static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    protected static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    protected static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    protected static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    protected static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    protected static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    protected static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    protected static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    protected static final String[] PATH_ATTRIBUTE_INCLUDE_NAMES = new String[]{"javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path"};
    protected static final String[] PATH_ATTRIBUTE_FORWARD_NAMES = new String[]{"javax.servlet.forward.context_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path"};
    protected static final String[] PATH_ATTRIBUTE_NAMES = new String[]{"javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path", "javax.servlet.forward.context_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path"};
    protected static final HashSet<String> PATH_ATTRIBUTE_NAMES_SET = new HashSet<String>(Arrays.asList(PATH_ATTRIBUTE_NAMES));
    static volatile DispatchDetection dispatchDetection = DispatchDetection.CHECK_STATE;
    protected static final HashMap<String, Long> dateHeaderParseCache = new HashMap();
    protected SimpleDateFormat[] dateHeaderFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected Map<String, Object> currPathAttributeValues = new HashMap<String, Object>();
    protected Map<String, Object> dispPathAttributeValues = new HashMap<String, Object>();
    protected Map<String, Object> pathAttributeValues = new HashMap<String, Object>();
    protected Map<String, Object> pathAttributeCache = new HashMap<String, Object>();
    protected PathMethodValues currPathMethodValues = new PathMethodValues();
    protected PathMethodValues dispPathMethodValues = new PathMethodValues();
    protected PathMethodValues pathMethodValues = new PathMethodValues();
    protected PathMethodValues initPathMethodValues;
    protected boolean attributeIncludeValuesModified;
    protected boolean attributeForwardValuesModified;
    protected boolean methodValuesModified;
    protected boolean namedDispatch;
    protected boolean forwarded;
    protected boolean dispatched;
    protected boolean nested;
    protected int requestWrapperStackSize;
    protected Map<String, String[]> origParameterMap;
    protected Map<String, String[]> currParameterMap;
    protected Map<String, String[]> parameterMap;
    protected final ServletContext servletContext;
    protected final PortletRequest portletRequest;
    protected final ClientDataRequest clientDataRequest;
    protected final String lifecyclePhase;
    protected final boolean renderPhase;
    protected HttpSession session;

    public HttpServletPortletRequestWrapper(HttpServletRequest request, ServletContext servletContext, HttpSession session, PortletRequest portletRequest, boolean included, boolean namedDispatch) {
        super(request);
        this.servletContext = servletContext;
        this.session = session;
        this.portletRequest = portletRequest;
        this.lifecyclePhase = (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
        this.clientDataRequest = "ACTION_PHASE".equals(this.lifecyclePhase) || "RESOURCE_PHASE".equals(this.lifecyclePhase) ? (ClientDataRequest)portletRequest : null;
        this.renderPhase = "RENDER_PHASE".equals(this.lifecyclePhase);
        this.forwarded = !included;
        this.namedDispatch = namedDispatch;
        this.origParameterMap = new HashMap<String, String[]>(request.getParameterMap());
        this.currParameterMap = this.origParameterMap;
        for (String name : PATH_ATTRIBUTE_NAMES) {
            this.currPathAttributeValues.put(name, request.getAttribute(name));
        }
        this.currPathMethodValues.contextPath = request.getContextPath();
        this.currPathMethodValues.servletPath = request.getServletPath();
        this.currPathMethodValues.pathInfo = request.getPathInfo();
        this.currPathMethodValues.queryString = request.getQueryString();
        this.currPathMethodValues.requestURI = request.getRequestURI();
        if (dispatchDetection != DispatchDetection.CHECK_STATE) {
            HttpServletPortletRequestWrapper currentRequest = this;
            while (currentRequest.getRequest() instanceof HttpServletRequestWrapper) {
                ++this.requestWrapperStackSize;
                currentRequest = (HttpServletRequestWrapper)currentRequest.getRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parseDateHeader(String value) {
        Long dateValue = null;
        try {
            dateValue = dateHeaderParseCache.get(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dateValue == null) {
            for (int i = 0; i < this.dateHeaderFormats.length; ++i) {
                try {
                    Date date = this.dateHeaderFormats[i].parse(value);
                    dateValue = new Long(date.getTime());
                    continue;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (dateValue != null) {
                HashMap<String, Long> hashMap = dateHeaderParseCache;
                synchronized (hashMap) {
                    if (dateHeaderParseCache.size() > 1000) {
                        dateHeaderParseCache.clear();
                    }
                    dateHeaderParseCache.put(value, dateValue);
                }
            } else {
                throw new IllegalArgumentException(value);
            }
        }
        return dateValue;
    }

    boolean isForwardingPossible() {
        return !this.renderPhase;
    }

    boolean isForwarded() {
        return this.forwarded;
    }

    boolean isNamedDispatch() {
        return this.namedDispatch;
    }

    Map<String, Object> getPathAttributeValues() {
        return new HashMap<String, Object>(this.dispPathAttributeValues);
    }

    PathMethodValues getInitPathMethodValues() {
        return this.initPathMethodValues != null ? new PathMethodValues().copy(this.initPathMethodValues) : null;
    }

    void setNestedForward() {
        this.dispatched = false;
        this.forwarded = true;
        this.namedDispatch = false;
    }

    void restoreFromNestedForward(boolean forwarded, boolean namedDispatch, PathMethodValues pathMethodValues, Map<String, Object> pathAttributeValues) {
        this.forwarded = forwarded;
        this.namedDispatch = namedDispatch;
        this.dispPathAttributeValues.clear();
        this.dispPathAttributeValues.putAll(pathAttributeValues);
        this.updateRequestPathState();
    }

    protected void updateRequestPathState() {
        this.syncDispatcherPathValues();
        if (this.checkDispatcherPathValuesChanged()) {
            if (!this.dispatched) {
                this.initFirstDispatchPathValues();
            } else {
                this.checkNestedDispatch();
            }
            if (!this.nested) {
                this.setupFirstDispatchPathValues();
            } else {
                this.setupNestedDispatchPathValues();
            }
        }
    }

    private static boolean compareAttributes(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    private static String asString(Object o) {
        return o != null ? o.toString() : null;
    }

    protected void syncDispatcherPathValues() {
        Object attrValue;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        this.attributeIncludeValuesModified = false;
        this.attributeForwardValuesModified = false;
        this.methodValuesModified = false;
        for (String name : PATH_ATTRIBUTE_INCLUDE_NAMES) {
            attrValue = this.pathAttributeCache.get(name);
            if (attrValue == null) {
                attrValue = request.getAttribute(name);
            }
            this.attributeIncludeValuesModified = !this.attributeIncludeValuesModified ? !HttpServletPortletRequestWrapper.compareAttributes(this.currPathAttributeValues.get(name), attrValue) : true;
            this.currPathAttributeValues.put(name, attrValue);
        }
        for (String name : PATH_ATTRIBUTE_FORWARD_NAMES) {
            attrValue = this.pathAttributeCache.get(name);
            if (attrValue == null) {
                attrValue = request.getAttribute(name);
            }
            this.attributeForwardValuesModified = !this.attributeForwardValuesModified ? !HttpServletPortletRequestWrapper.compareAttributes(this.currPathAttributeValues.get(name), attrValue) : true;
            this.currPathAttributeValues.put(name, attrValue);
        }
        String methodValue = request.getContextPath();
        this.methodValuesModified = this.methodValuesModified ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.currPathMethodValues.contextPath, methodValue);
        this.currPathMethodValues.contextPath = methodValue;
        methodValue = request.getServletPath();
        this.methodValuesModified = this.methodValuesModified ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.currPathMethodValues.servletPath, methodValue);
        this.currPathMethodValues.servletPath = methodValue;
        methodValue = request.getPathInfo();
        this.methodValuesModified = this.methodValuesModified ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.currPathMethodValues.pathInfo, methodValue);
        this.currPathMethodValues.pathInfo = methodValue;
        methodValue = request.getQueryString();
        this.methodValuesModified = this.methodValuesModified ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.currPathMethodValues.queryString, methodValue);
        this.currPathMethodValues.queryString = methodValue;
        methodValue = request.getRequestURI();
        this.methodValuesModified = this.methodValuesModified ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.currPathMethodValues.requestURI, methodValue);
        this.currPathMethodValues.requestURI = methodValue;
    }

    protected boolean checkDispatcherPathValuesChanged() {
        if (this.methodValuesModified && this.currPathMethodValues.servletPath == null) {
            this.methodValuesModified = false;
        }
        if (this.attributeIncludeValuesModified && this.currPathAttributeValues.get(INCLUDE_SERVLET_PATH) == null) {
            this.attributeIncludeValuesModified = false;
        }
        if (this.attributeForwardValuesModified && this.currPathAttributeValues.get(FORWARD_SERVLET_PATH) == null) {
            this.attributeForwardValuesModified = false;
        }
        return this.attributeIncludeValuesModified || this.attributeForwardValuesModified || this.methodValuesModified;
    }

    protected void initFirstDispatchPathValues() {
        this.dispatched = true;
        this.dispPathMethodValues.copy(this.currPathMethodValues);
        this.dispPathAttributeValues.putAll(this.currPathAttributeValues);
    }

    protected void checkNestedDispatch() {
        this.nested = false;
        for (String name : PATH_ATTRIBUTE_NAMES) {
            if (HttpServletPortletRequestWrapper.compareAttributes(this.dispPathAttributeValues.get(name), this.currPathAttributeValues.get(name))) continue;
            this.nested = true;
            break;
        }
        boolean bl = this.nested ? true : (this.nested = !HttpServletPortletRequestWrapper.compareAttributes(this.dispPathMethodValues.contextPath, this.currPathMethodValues.contextPath));
        boolean bl2 = this.nested ? true : (this.nested = !HttpServletPortletRequestWrapper.compareAttributes(this.dispPathMethodValues.servletPath, this.currPathMethodValues.servletPath));
        boolean bl3 = this.nested ? true : (this.nested = !HttpServletPortletRequestWrapper.compareAttributes(this.dispPathMethodValues.pathInfo, this.currPathMethodValues.pathInfo));
        boolean bl4 = this.nested ? true : (this.nested = !HttpServletPortletRequestWrapper.compareAttributes(this.dispPathMethodValues.queryString, this.currPathMethodValues.queryString));
        this.nested = this.nested ? true : !HttpServletPortletRequestWrapper.compareAttributes(this.dispPathMethodValues.requestURI, this.currPathMethodValues.requestURI);
    }

    protected void setupFirstDispatchPathValues() {
        this.pathAttributeValues.clear();
        if (this.namedDispatch) {
            this.pathMethodValues.contextPath = this.dispPathMethodValues.contextPath;
        } else {
            if (!this.forwarded || !this.isForwardingPossible()) {
                if (this.initPathMethodValues != null) {
                    this.pathMethodValues.copy(this.initPathMethodValues);
                } else {
                    this.pathMethodValues.contextPath = HttpServletPortletRequestWrapper.asString(this.dispPathAttributeValues.get(INCLUDE_CONTEXT_PATH));
                    this.pathMethodValues.servletPath = HttpServletPortletRequestWrapper.asString(this.dispPathAttributeValues.get(INCLUDE_SERVLET_PATH));
                    this.pathMethodValues.pathInfo = HttpServletPortletRequestWrapper.asString(this.dispPathAttributeValues.get(INCLUDE_PATH_INFO));
                    this.pathMethodValues.queryString = HttpServletPortletRequestWrapper.asString(this.dispPathAttributeValues.get(INCLUDE_QUERY_STRING));
                    this.pathMethodValues.requestURI = HttpServletPortletRequestWrapper.asString(this.dispPathAttributeValues.get(INCLUDE_REQUEST_URI));
                }
            } else {
                this.pathMethodValues.copy(this.dispPathMethodValues);
            }
            if (this.initPathMethodValues == null && this.pathMethodValues.servletPath != null) {
                this.initPathMethodValues = new PathMethodValues().copy(this.pathMethodValues);
            }
            if (!this.forwarded) {
                this.pathAttributeValues.put(INCLUDE_CONTEXT_PATH, this.dispPathAttributeValues.get(INCLUDE_CONTEXT_PATH));
                this.pathAttributeValues.put(INCLUDE_SERVLET_PATH, this.dispPathAttributeValues.get(INCLUDE_SERVLET_PATH));
                this.pathAttributeValues.put(INCLUDE_PATH_INFO, this.dispPathAttributeValues.get(INCLUDE_PATH_INFO));
                this.pathAttributeValues.put(INCLUDE_QUERY_STRING, this.dispPathAttributeValues.get(INCLUDE_QUERY_STRING));
                this.pathAttributeValues.put(INCLUDE_REQUEST_URI, this.dispPathAttributeValues.get(INCLUDE_REQUEST_URI));
            } else if (this.initPathMethodValues != null) {
                this.pathAttributeValues.put(FORWARD_CONTEXT_PATH, this.initPathMethodValues.contextPath);
                this.pathAttributeValues.put(FORWARD_SERVLET_PATH, this.initPathMethodValues.servletPath);
                this.pathAttributeValues.put(FORWARD_PATH_INFO, this.initPathMethodValues.pathInfo);
                this.pathAttributeValues.put(FORWARD_QUERY_STRING, this.initPathMethodValues.queryString);
                this.pathAttributeValues.put(FORWARD_REQUEST_URI, this.initPathMethodValues.requestURI);
            } else if (this.forwarded && this.isForwardingPossible()) {
                this.pathAttributeValues.put(FORWARD_CONTEXT_PATH, this.dispPathMethodValues.contextPath);
                this.pathAttributeValues.put(FORWARD_SERVLET_PATH, this.dispPathMethodValues.servletPath);
                this.pathAttributeValues.put(FORWARD_PATH_INFO, this.dispPathMethodValues.pathInfo);
                this.pathAttributeValues.put(FORWARD_QUERY_STRING, this.dispPathMethodValues.queryString);
                this.pathAttributeValues.put(FORWARD_REQUEST_URI, this.dispPathMethodValues.requestURI);
            } else {
                this.pathAttributeValues.put(FORWARD_CONTEXT_PATH, this.dispPathAttributeValues.get(INCLUDE_CONTEXT_PATH));
                this.pathAttributeValues.put(FORWARD_SERVLET_PATH, this.dispPathAttributeValues.get(INCLUDE_SERVLET_PATH));
                this.pathAttributeValues.put(FORWARD_PATH_INFO, this.dispPathAttributeValues.get(INCLUDE_PATH_INFO));
                this.pathAttributeValues.put(FORWARD_QUERY_STRING, this.dispPathAttributeValues.get(INCLUDE_QUERY_STRING));
                this.pathAttributeValues.put(FORWARD_REQUEST_URI, this.dispPathAttributeValues.get(INCLUDE_REQUEST_URI));
            }
        }
    }

    protected void setupNestedDispatchPathValues() {
        if (this.namedDispatch) {
            this.pathMethodValues.contextPath = this.dispPathMethodValues.contextPath;
        } else if (!this.forwarded || !this.isForwardingPossible()) {
            this.pathMethodValues.copy(this.initPathMethodValues);
        } else {
            this.pathMethodValues.copy(this.dispPathMethodValues);
        }
        this.pathAttributeValues.put(INCLUDE_CONTEXT_PATH, this.currPathAttributeValues.get(INCLUDE_CONTEXT_PATH));
        this.pathAttributeValues.put(INCLUDE_SERVLET_PATH, this.currPathAttributeValues.get(INCLUDE_SERVLET_PATH));
        this.pathAttributeValues.put(INCLUDE_PATH_INFO, this.currPathAttributeValues.get(INCLUDE_PATH_INFO));
        this.pathAttributeValues.put(INCLUDE_QUERY_STRING, this.currPathAttributeValues.get(INCLUDE_QUERY_STRING));
        this.pathAttributeValues.put(INCLUDE_REQUEST_URI, this.currPathAttributeValues.get(INCLUDE_REQUEST_URI));
        if (this.attributeForwardValuesModified && this.currPathAttributeValues.get(FORWARD_CONTEXT_PATH) != null) {
            this.pathAttributeValues.put(FORWARD_CONTEXT_PATH, this.currPathAttributeValues.get(FORWARD_CONTEXT_PATH));
            this.pathAttributeValues.put(FORWARD_SERVLET_PATH, this.currPathAttributeValues.get(FORWARD_SERVLET_PATH));
            this.pathAttributeValues.put(FORWARD_PATH_INFO, this.currPathAttributeValues.get(FORWARD_PATH_INFO));
            this.pathAttributeValues.put(FORWARD_QUERY_STRING, this.currPathAttributeValues.get(FORWARD_QUERY_STRING));
            this.pathAttributeValues.put(FORWARD_REQUEST_URI, this.currPathAttributeValues.get(FORWARD_REQUEST_URI));
        }
    }

    protected boolean isRequestWrapperStackChanged() {
        HttpServletPortletRequestWrapper currentRequest = this;
        int currentRequestWrapperStackSize = 0;
        while (currentRequest.getRequest() instanceof HttpServletRequestWrapper) {
            ++currentRequestWrapperStackSize;
            currentRequest = (HttpServletRequestWrapper)currentRequest.getRequest();
        }
        if (currentRequestWrapperStackSize != this.requestWrapperStackSize) {
            this.requestWrapperStackSize = currentRequestWrapperStackSize;
            return true;
        }
        return false;
    }

    public Map<String, String[]> getParameterMap() {
        boolean dispatchDetected = false;
        HashMap newParameterMap = null;
        if (dispatchDetection == DispatchDetection.CHECK_REQUEST_WRAPPER_STACK) {
            if (this.isRequestWrapperStackChanged()) {
                dispatchDetected = true;
            }
        } else {
            if (dispatchDetection == DispatchDetection.EVALUATE && this.isRequestWrapperStackChanged()) {
                dispatchDetected = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("DispatchDetection: changing from EVALUATE to CHECK_WEBCONTAINER_REQUEST");
                }
                dispatchDetection = DispatchDetection.CHECK_REQUEST_WRAPPER_STACK;
            }
            if (!dispatchDetected) {
                newParameterMap = this.getRequest().getParameterMap();
                if (newParameterMap.size() != this.currParameterMap.size()) {
                    dispatchDetected = true;
                } else {
                    for (Map.Entry entry : newParameterMap.entrySet()) {
                        String[] newValues = (String[])entry.getValue();
                        String[] currValues = this.currParameterMap.get(entry.getKey());
                        if (currValues != null && newValues.length == currValues.length) continue;
                        dispatchDetected = true;
                        break;
                    }
                }
                if (dispatchDetected && dispatchDetection == DispatchDetection.EVALUATE) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DispatchDetection: changing from EVALUATE to CHECK_STATE");
                    }
                    dispatchDetection = DispatchDetection.CHECK_STATE;
                }
            }
        }
        if (dispatchDetected || this.parameterMap == null) {
            if (newParameterMap == null) {
                newParameterMap = this.getRequest().getParameterMap();
            }
            if (dispatchDetection != DispatchDetection.CHECK_REQUEST_WRAPPER_STACK) {
                this.currParameterMap = new HashMap<String, String[]>(newParameterMap);
            }
            HashMap diffParameterMap = new HashMap();
            for (Map.Entry entry : newParameterMap.entrySet()) {
                String[] values = (String[])entry.getValue();
                String[] original = this.origParameterMap.get(entry.getKey());
                String[] diff = null;
                if (original == null) {
                    diff = (String[])values.clone();
                } else if (values.length > original.length) {
                    diff = new String[values.length - original.length];
                    System.arraycopy(values, 0, diff, 0, values.length - original.length);
                }
                if (diff == null) continue;
                diffParameterMap.put(entry.getKey(), diff);
            }
            if (!diffParameterMap.isEmpty()) {
                newParameterMap = new HashMap(this.portletRequest.getParameterMap());
                for (Map.Entry entry : diffParameterMap.entrySet()) {
                    String[] diff = (String[])entry.getValue();
                    String[] curr = (String[])newParameterMap.get(entry.getKey());
                    if (curr == null) {
                        newParameterMap.put(entry.getKey(), diff);
                        continue;
                    }
                    String[] copy = new String[curr.length + diff.length];
                    System.arraycopy(diff, 0, copy, 0, diff.length);
                    System.arraycopy(curr, 0, copy, diff.length, curr.length);
                    newParameterMap.put(entry.getKey(), copy);
                }
                this.parameterMap = Collections.unmodifiableMap(newParameterMap);
            }
        }
        if (this.parameterMap == null) {
            this.parameterMap = this.portletRequest.getParameterMap();
        }
        return this.parameterMap;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        return values != null ? values[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getContextPath() {
        this.updateRequestPathState();
        return this.pathMethodValues.contextPath;
    }

    public String getPathInfo() {
        this.updateRequestPathState();
        return this.pathMethodValues.pathInfo;
    }

    public String getPathTranslated() {
        this.updateRequestPathState();
        if (this.pathMethodValues.pathInfo != null && this.pathMethodValues.contextPath.equals(this.portletRequest.getContextPath())) {
            return this.servletContext.getRealPath(this.pathMethodValues.pathInfo);
        }
        return null;
    }

    public String getQueryString() {
        this.updateRequestPathState();
        return this.pathMethodValues.queryString;
    }

    public String getRequestURI() {
        this.updateRequestPathState();
        return this.pathMethodValues.requestURI;
    }

    public String getServletPath() {
        this.updateRequestPathState();
        return this.pathMethodValues.servletPath;
    }

    public Object getAttribute(String name) {
        if (PATH_ATTRIBUTE_NAMES_SET.contains(name)) {
            this.updateRequestPathState();
            return this.pathAttributeValues.get(name);
        }
        Object value = this.getRequest().getAttribute(name);
        return value != null ? value : this.portletRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        if (PATH_ATTRIBUTE_NAMES_SET.contains(name)) {
            this.pathAttributeCache.put(name, o);
        } else {
            this.portletRequest.setAttribute(name, o);
        }
    }

    public void removeAttribute(String name) {
        if (PATH_ATTRIBUTE_NAMES_SET.contains(name)) {
            this.pathAttributeCache.remove(name);
        } else {
            this.portletRequest.removeAttribute(name);
        }
    }

    public Enumeration<String> getAttributeNames() {
        HashSet names = new HashSet();
        Enumeration e = this.getRequest().getAttributeNames();
        while (e.hasMoreElements()) {
            try {
                names.add(e.nextElement());
            }
            catch (NoSuchElementException nse) {}
        }
        e = this.portletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            try {
                names.add(e.nextElement());
            }
            catch (NoSuchElementException nse) {}
        }
        this.updateRequestPathState();
        for (String name : PATH_ATTRIBUTE_NAMES) {
            if (this.pathAttributeValues.get(name) != null) {
                names.add(name);
                continue;
            }
            names.remove(name);
        }
        return Collections.enumeration(names);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher;
        if (path != null && (dispatcher = super.getRequestDispatcher(path)) != null) {
            if (!this.dispatched) {
                this.updateRequestPathState();
            }
            if (this.forwarded && this.isForwardingPossible()) {
                return dispatcher;
            }
            return new PortletRequestDispatcherImpl(dispatcher, false);
        }
        return null;
    }

    public long getDateHeader(String name) {
        String value = this.portletRequest.getProperty(name);
        if (value == null) {
            return -1L;
        }
        return this.parseDateHeader(value);
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.portletRequest.getCookies();
    }

    public String getHeader(String name) {
        return this.portletRequest.getProperty(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.portletRequest.getPropertyNames();
    }

    public Enumeration<String> getHeaders(String name) {
        return this.portletRequest.getProperties(name);
    }

    public int getIntHeader(String name) {
        String property = this.portletRequest.getProperty(name);
        if (property == null) {
            return -1;
        }
        return Integer.parseInt(property);
    }

    public String getMethod() {
        return this.renderPhase ? "GET" : super.getMethod();
    }

    public HttpSession getSession() {
        return this.session != null ? this.session : super.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.session != null ? this.session : super.getSession(create);
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.portletRequest.getRequestedSessionId();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdValid() {
        return this.portletRequest.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public String getCharacterEncoding() {
        return this.clientDataRequest != null ? this.clientDataRequest.getCharacterEncoding() : null;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.clientDataRequest != null) {
            this.clientDataRequest.setCharacterEncoding(enc);
        }
    }

    public int getContentLength() {
        return this.clientDataRequest != null ? this.clientDataRequest.getContentLength() : 0;
    }

    public String getContentType() {
        return this.clientDataRequest != null ? this.clientDataRequest.getContentType() : null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.clientDataRequest != null ? (ServletInputStream)this.clientDataRequest.getPortletInputStream() : null;
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.portletRequest.getLocales();
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        return this.clientDataRequest != null ? this.clientDataRequest.getReader() : null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getScheme() {
        return this.portletRequest.getScheme();
    }

    public String getServerName() {
        return this.portletRequest.getServerName();
    }

    public int getServerPort() {
        return this.portletRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.portletRequest.isSecure();
    }

    static enum DispatchDetection {
        CHECK_STATE,
        CHECK_REQUEST_WRAPPER_STACK,
        EVALUATE;

    }

    protected static final class PathMethodValues {
        String contextPath;
        String servletPath;
        String pathInfo;
        String queryString;
        String requestURI;

        PathMethodValues() {
        }

        PathMethodValues copy(PathMethodValues pmv) {
            this.contextPath = pmv.contextPath;
            this.servletPath = pmv.servletPath;
            this.pathInfo = pmv.pathInfo;
            this.queryString = pmv.queryString;
            this.requestURI = pmv.requestURI;
            return this;
        }
    }
}

