/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ccpp.Profile;
import javax.portlet.CacheControl;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletEnvironmentService;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletPreferencesImpl;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.util.ArgumentUtility;
import org.apache.pluto.container.util.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortletRequestImpl
implements PortletRequest {
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final Logger LOG = LoggerFactory.getLogger(PortletRequestImpl.class);
    private static final StringManager EXCEPTIONS = StringManager.getManager(PortletRequestImpl.class.getPackage().getName());
    private static final List<String> EMPTY_STRING_LIST = Collections.unmodifiableList(new ArrayList(0));
    private PortalContext portalContext;
    private PortletRequestContext requestContext;
    private PortletResponseContext responseContext;
    private PortletSession portletSession;
    private ArrayList<String> contentTypes;
    private PortletPreferences portletPreferences;
    private Map<String, String[]> parameters;
    private Map<String, String[]> requestProperties;
    private List<String> requestPropertyNames;
    private Cookie[] requestCookies;
    private Map<String, String> userInfo;
    private Profile ccppProfile;
    private String contextPath;
    private final String lifecyclePhase;

    public PortletRequestImpl(PortletRequestContext requestContext, PortletResponseContext responseContext, String lifecyclePhase) {
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.lifecyclePhase = lifecyclePhase;
        this.portalContext = this.getPortletContainer().getContainerServices().getPortalContext();
    }

    private void retrieveRequestProperties() {
        Map properties = this.requestContext.getProperties();
        this.requestPropertyNames = new ArrayList<String>(properties.size());
        this.requestProperties = new HashMap<String, String[]>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            this.requestPropertyNames.add((String)entry.getKey());
            this.requestProperties.put(((String)entry.getKey()).toLowerCase(), (String[])entry.getValue());
        }
    }

    private void checkInitParameterMap() {
        if (this.parameters == null) {
            this.parameters = this.initParameterMap();
        }
    }

    protected static Map<String, String[]> cloneParameterMap(Map<String, String[]> map) {
        if (!map.isEmpty()) {
            HashMap<String, Object> result = new HashMap<String, Object>(map.size());
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put(entry.getKey(), entry.getValue().clone());
            }
            return Collections.unmodifiableMap(result);
        }
        return Collections.emptyMap();
    }

    protected Map<String, String[]> initParameterMap() {
        String[] values = null;
        HashMap parameters = this.requestContext.getPrivateParameterMap();
        Map publicParameters = this.requestContext.getPublicParameterMap();
        if (!publicParameters.isEmpty()) {
            parameters = new HashMap(parameters);
            for (Map.Entry entry : publicParameters.entrySet()) {
                values = (String[])parameters.get(entry.getKey());
                if (values == null) {
                    parameters.put(entry.getKey(), ((String[])entry.getValue()).clone());
                    continue;
                }
                String[] copy = new String[values.length + ((String[])entry.getValue()).length];
                System.arraycopy(values, 0, copy, 0, values.length);
                System.arraycopy(entry.getValue(), 0, copy, values.length, ((String[])entry.getValue()).length);
                parameters.put(entry.getKey(), copy);
            }
        }
        return parameters;
    }

    protected PortletRequestContext getRequestContext() {
        return this.requestContext;
    }

    protected PortletContext getPortletContext() {
        return this.requestContext.getPortletConfig().getPortletContext();
    }

    protected PortletWindow getPortletWindow() {
        return this.requestContext.getPortletWindow();
    }

    protected PortletContainer getPortletContainer() {
        return this.requestContext.getContainer();
    }

    protected HttpServletRequest getServletRequest() {
        return this.requestContext.getServletRequest();
    }

    protected String getMimeRequestProperty(String name, CacheControl cacheControl) {
        if ("portlet.ETag".equals(name)) {
            return cacheControl.getETag();
        }
        if ("portlet.cache-scope".equals(name)) {
            return cacheControl.isPublicScope() ? "portlet.public-scope" : "portlet.private-scope";
        }
        if ("portlet.use-cached-content".equals(name)) {
            return cacheControl.useCachedContent() ? "true" : null;
        }
        if ("portlet.expiration-cache".equals(name)) {
            return Integer.toString(cacheControl.getExpirationTime());
        }
        return null;
    }

    public Object getAttribute(String name) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if (name.equals("javax.portlet.lifecycle_phase")) {
            return this.lifecyclePhase;
        }
        if (name.equals("javax.portlet.userinfo")) {
            if (this.userInfo == null) {
                try {
                    this.userInfo = this.getPortletContainer().getContainerServices().getUserInfoService().getUserInfo((PortletRequest)this, this.getPortletWindow());
                }
                catch (Exception e) {
                    this.userInfo = Collections.emptyMap();
                }
            }
            return this.userInfo;
        }
        if (name.equals(PortletInvokerService.REQUEST_CONTEXT)) {
            return this.requestContext;
        }
        if (name.equals(PortletInvokerService.RESPONSE_CONTEXT)) {
            return this.responseContext;
        }
        if (name.equals("javax.portlet.ccpp")) {
            if (this.ccppProfile == null) {
                this.ccppProfile = this.getPortletContainer().getContainerServices().getCCPPProfileService().getCCPPProfile(this.getServletRequest());
            }
            return this.ccppProfile;
        }
        return this.requestContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.requestContext.getAttributeNames();
    }

    public String getAuthType() {
        return this.getServletRequest().getAuthType();
    }

    public String getContextPath() {
        if (this.contextPath == null) {
            this.contextPath = this.requestContext.getPortletWindow().getPortletDefinition().getApplication().getContextPath();
        }
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        if (this.requestCookies == null) {
            this.requestCookies = this.requestContext.getCookies();
            if (this.requestCookies == null) {
                this.requestCookies = new Cookie[0];
            }
        }
        return this.requestCookies.length > 0 ? (Cookie[])this.requestCookies.clone() : null;
    }

    public Locale getLocale() {
        return this.requestContext.getPreferredLocale();
    }

    public Enumeration<Locale> getLocales() {
        Locale preferredLocale = this.getLocale();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(preferredLocale);
        Enumeration e = this.getServletRequest().getLocales();
        while (e.hasMoreElements()) {
            Locale locale = (Locale)e.nextElement();
            if (locale.equals(preferredLocale)) continue;
            locales.add(locale);
        }
        return Collections.enumeration(locales);
    }

    public String getParameter(String name) {
        ArgumentUtility.validateNotNull("parameterName", name);
        this.checkInitParameterMap();
        String[] values = this.parameters.get(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Map<String, String[]> getParameterMap() {
        this.checkInitParameterMap();
        return PortletRequestImpl.cloneParameterMap(this.parameters);
    }

    public Enumeration<String> getParameterNames() {
        this.checkInitParameterMap();
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        ArgumentUtility.validateNotNull("parameterName", name);
        this.checkInitParameterMap();
        String[] values = this.parameters.get(name);
        return values != null ? (String[])values.clone() : null;
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public PortletMode getPortletMode() {
        return this.getPortletWindow().getPortletMode();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retreiving portlet session (create=" + create + ")");
        }
        if (this.getPortletContext() == null) {
            throw new IllegalStateException(EXCEPTIONS.getString("error.session.illegalState"));
        }
        HttpSession httpSession = this.getServletRequest().getSession(create);
        if (httpSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The underlying HttpSession is not available: no session will be returned.");
            }
            return null;
        }
        if (this.portletSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new portlet session...");
            }
            ContainerServices containerServices = this.getPortletContainer().getContainerServices();
            PortletEnvironmentService portletEnvironmentService = containerServices.getPortletEnvironmentService();
            this.portletSession = portletEnvironmentService.createPortletSession(this.getPortletContext(), this.getPortletWindow(), httpSession);
        }
        return this.portletSession;
    }

    public PortletPreferences getPreferences() {
        if (this.portletPreferences == null) {
            this.portletPreferences = new PortletPreferencesImpl(this.getPortletContainer(), this.getPortletWindow(), this);
        }
        return this.portletPreferences;
    }

    public Map<String, String[]> getPrivateParameterMap() {
        return PortletRequestImpl.cloneParameterMap(this.requestContext.getPrivateParameterMap());
    }

    public Enumeration<String> getProperties(String name) {
        String[] properties;
        ArgumentUtility.validateNotNull("propertyName", name);
        if (ACCEPT_LANGUAGE.equalsIgnoreCase(name)) {
            Locale preferredLocale = this.getLocale();
            ArrayList<String> locales = new ArrayList<String>();
            locales.add(preferredLocale.toString());
            Enumeration e = this.getServletRequest().getLocales();
            while (e.hasMoreElements()) {
                Locale locale = (Locale)e.nextElement();
                if (locale.equals(preferredLocale)) continue;
                locales.add(locale.toString());
            }
            return Collections.enumeration(locales);
        }
        if (this.requestProperties == null) {
            this.retrieveRequestProperties();
        }
        if ((properties = this.requestProperties.get(name.toLowerCase())) == null) {
            return Collections.enumeration(EMPTY_STRING_LIST);
        }
        return Collections.enumeration(Arrays.asList(properties));
    }

    public String getProperty(String name) {
        ArgumentUtility.validateNotNull("name", name);
        if (ACCEPT_LANGUAGE.equalsIgnoreCase(name)) {
            return this.getLocale().toString();
        }
        if (this.requestProperties == null) {
            this.retrieveRequestProperties();
        }
        String property = null;
        String[] properties = this.requestProperties.get(name.toLowerCase());
        if (properties != null && properties.length > 0) {
            property = properties[0];
        }
        return property;
    }

    public Enumeration<String> getPropertyNames() {
        if (this.requestProperties == null) {
            this.retrieveRequestProperties();
        }
        return Collections.enumeration(this.requestPropertyNames);
    }

    public Map<String, String[]> getPublicParameterMap() {
        return PortletRequestImpl.cloneParameterMap(this.requestContext.getPublicParameterMap());
    }

    public String getRemoteUser() {
        return this.getServletRequest().getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.getServletRequest().getRequestedSessionId();
    }

    public String getResponseContentType() {
        return this.getResponseContentTypes().nextElement();
    }

    public Enumeration<String> getResponseContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList();
            PortletDefinition dd = this.getPortletWindow().getPortletDefinition();
            for (Supports sup : dd.getSupports()) {
                this.contentTypes.add(sup.getMimeType());
            }
            if (this.contentTypes.isEmpty()) {
                this.contentTypes.add("text/html");
            }
        }
        return Collections.enumeration(this.contentTypes);
    }

    public String getScheme() {
        return this.getServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getServletRequest().getServerName();
    }

    public int getServerPort() {
        return this.getServletRequest().getServerPort();
    }

    public Principal getUserPrincipal() {
        return this.getServletRequest().getUserPrincipal();
    }

    public String getWindowID() {
        return this.getPortletWindow().getId().getStringId();
    }

    public WindowState getWindowState() {
        return this.getPortletWindow().getWindowState();
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        if (PortletMode.VIEW.equals((Object)mode)) {
            return true;
        }
        String modeName = mode.toString();
        PortletDefinition dd = this.getPortletWindow().getPortletDefinition();
        for (Supports sup : dd.getSupports()) {
            for (String m : sup.getPortletModes()) {
                if (!m.equalsIgnoreCase(modeName)) continue;
                CustomPortletMode cpm = dd.getApplication().getCustomPortletMode(modeName);
                if (cpm != null && !cpm.isPortalManaged()) {
                    return true;
                }
                Enumeration supportedModes = this.portalContext.getSupportedPortletModes();
                while (supportedModes.hasMoreElements()) {
                    if (!((PortletMode)supportedModes.nextElement()).equals((Object)mode)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return this.getServletRequest().isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.getServletRequest().isSecure();
    }

    public boolean isUserInRole(String roleName) {
        PortletDefinition def = this.getPortletWindow().getPortletDefinition();
        String link = roleName;
        for (SecurityRoleRef r : def.getSecurityRoleRefs()) {
            if (!r.getRoleName().equals(roleName)) continue;
            if (r.getRoleLink() == null) break;
            link = r.getRoleLink();
            break;
        }
        return this.getServletRequest().isUserInRole(link);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        Enumeration en = this.portalContext.getSupportedWindowStates();
        while (en.hasMoreElements()) {
            if (!((WindowState)en.nextElement()).toString().equalsIgnoreCase(state.toString())) continue;
            return true;
        }
        return false;
    }

    public void setAttribute(String name, Object value) {
        ArgumentUtility.validateNotEmpty("name", name);
        this.requestContext.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ArgumentUtility.validateNotEmpty("name", name);
        this.requestContext.setAttribute(name, null);
    }
}

