/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathScanner.class);

    public static List<URL> scan(String path) throws IOException {
        List<URL> list = ClasspathScanner.scan(path, ClasspathScanner.class.getClassLoader());
        list.addAll(ClasspathScanner.scan(path, Thread.currentThread().getContextClassLoader()));
        list.add(ClasspathScanner.class.getResource(path));
        if (LOG.isInfoEnabled()) {
            LOG.info("Found " + list.size() + " resources for path '" + path + "'.");
        }
        return list;
    }

    public static List<URL> scan(String path, ClassLoader loader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        if (loader == null) {
            return list;
        }
        Enumeration<URL> enumeration = loader.getResources(path);
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static List findConfiguredImplementations(Class implemented) throws IOException {
        ArrayList classes = new ArrayList();
        List<URL> resources = ClasspathScanner.scan("/META-INF/pluto.properties");
        Iterator<URL> i = resources.iterator();
        Properties p = new Properties();
        while (i.hasNext()) {
            URL url = i.next();
            p.load(url.openStream());
            String impl = p.getProperty(implemented.getName());
            if (impl != null) {
                StringTokenizer st = new StringTokenizer(impl, ",", false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    try {
                        classes.add(Class.forName(token));
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOG.warn("Unable to find configured implementation " + impl + " of interface " + implemented.getName());
                    }
                }
            }
            p.clear();
        }
        return classes;
    }
}

