/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalDriverFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PortalDriverFilter.class);
    private ServletContext servletContext;
    protected PortletContainer container;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
    }

    public void destroy() {
        this.container = null;
        this.servletContext = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            boolean actionRequestProcessed;
            HttpServletRequest req = (HttpServletRequest)request;
            if (PortalRequestContext.getContext(req) == null && (actionRequestProcessed = this.doPortletPrepare(req, (HttpServletResponse)response))) {
                return;
            }
            String path = req.getServletPath();
            int idx = path.indexOf(".jsp");
            if (!path.endsWith(".jsp") && idx > 0) {
                String realPath = path.substring(0, idx + ".jsp".length());
                if (realPath.startsWith(req.getContextPath())) {
                    realPath = realPath.substring(req.getContextPath().length());
                }
                LOG.info("Forwarding to realPath: " + realPath);
                request.getRequestDispatcher(realPath).forward(request, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public boolean doPortletPrepare(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortletWindowConfig actionWindowConfig;
        boolean actionRequestProcessed = false;
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = portalRequestContext.getRequestedPortalURL();
        String actionWindowId = portalURL.getActionWindow();
        PortletWindowConfig portletWindowConfig = actionWindowConfig = actionWindowId == null ? null : PortletWindowConfig.fromId(actionWindowId);
        if (actionWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, actionWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing action request for window: " + portletWindow.getId().getStringId());
            }
            try {
                this.container.doAction((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action request processed.\n\n");
            }
            actionRequestProcessed = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Render Path: " + portalURL.getRenderPath());
            LOG.debug("Servlet Path: " + portalURL.getServletPath());
        }
        return actionRequestProcessed;
    }
}

