/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalDriverServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PortalDriverServlet.class);
    private ServletContext servletContext = null;
    public static final String DEFAULT_PAGE_URI = "/WEB-INF/themes/pluto-default-theme.jsp";
    protected PortletContainer container = null;
    private String contentType = "";

    public String getServletInfo() {
        return "Pluto Portal Driver Servlet";
    }

    public void init() {
        this.servletContext = this.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
        String charset = this.getServletConfig().getInitParameter("charset");
        if (charset != null && charset.length() > 0) {
            this.contentType = "text/html; charset=" + charset;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start of PortalDriverServlet.doGet() to process portlet request . . .");
        }
        if (this.contentType != "") {
            response.setContentType(this.contentType);
        }
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = null;
        try {
            portalURL = portalRequestContext.getRequestedPortalURL();
        }
        catch (Exception ex) {
            String msg = "Cannot handle request for portal URL. Problem: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        String actionWindowId = portalURL.getActionWindow();
        String resourceWindowId = portalURL.getResourceWindow();
        PortletWindowConfig actionWindowConfig = null;
        PortletWindowConfig resourceWindowConfig = null;
        if (resourceWindowId != null) {
            resourceWindowConfig = PortletWindowConfig.fromId(resourceWindowId);
        } else if (actionWindowId != null) {
            actionWindowConfig = PortletWindowConfig.fromId(actionWindowId);
        }
        if (actionWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, actionWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing action request for window: " + portletWindow.getId().getStringId());
            }
            try {
                this.container.doAction((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action request processed.\n\n");
            }
        } else if (resourceWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, resourceWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing resource Serving request for window: " + portletWindow.getId().getStringId());
            }
            try {
                this.container.doServeResource((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource serving request processed.\n\n");
            }
        } else {
            String uri;
            PageConfig pageConfig;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing render request.");
            }
            if ((pageConfig = portalURL.getPageConfig(this.servletContext)) == null) {
                String renderPath = portalURL == null ? "" : portalURL.getRenderPath();
                String msg = "PageConfig for render path [" + renderPath + "] could not be found.";
                LOG.error(msg);
                throw new ServletException(msg);
            }
            request.setAttribute("currentPage", (Object)pageConfig);
            String string = uri = pageConfig.getUri() != null ? pageConfig.getUri() : DEFAULT_PAGE_URI;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching to: " + uri);
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(uri);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Render request processed.\n\n");
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

