/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import java.text.DecimalFormat;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.driver.PortalDriverServlet;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCKDriverServlet
extends PortalDriverServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TCKDriverServlet.class);
    private int pageCounter = 0;

    public String getServletInfo() {
        return "Pluto TCK Driver Servlet";
    }

    public void init() {
        super.init();
        ServletContext servletContext = this.getServletContext();
        this.container = (PortletContainer)servletContext.getAttribute("portletContainer");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] portletNames = request.getParameterValues("portletName");
        if (portletNames != null && portletNames.length > 0) {
            this.debugWithName("Initializing new TCK page...");
            this.doSetup(request, response);
        } else {
            this.debugWithName("No portlet names specified. Continue as normal.");
            super.doGet(request, response);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse response) throws IOException, ServletException {
        super.doGet(req, response);
    }

    private void doSetup(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] portletNames = request.getParameterValues("portletName");
        String pageName = request.getParameter("pageName");
        if (pageName != null) {
            this.debugWithName("Retrieved page name from request: " + pageName);
        } else {
            this.debugWithName("Creating page name...");
            AdminConfiguration adminConfig = (AdminConfiguration)this.getServletContext().getAttribute("driverAdminConfig");
            if (adminConfig == null) {
                throw new ServletException("Invalid configuration: an AdminConfiguration must be specified to run the TCK.");
            }
            pageName = new DecimalFormat("TCK00000").format(this.pageCounter++);
            PageConfig pageConfig = new PageConfig();
            pageConfig.setName(pageName);
            pageConfig.setUri("/WEB-INF/themes/pluto-default-theme.jsp");
            for (int i = 0; i < portletNames.length; ++i) {
                this.debugWithName("Processing portlet name: " + portletNames[i]);
                int index = portletNames[i].indexOf("/");
                String contextPath = "/" + portletNames[i].substring(0, index);
                String portletName = portletNames[i].substring(index + 1);
                pageConfig.addPortlet(contextPath, portletName);
            }
            adminConfig.getRenderConfigAdminService().addPage(pageConfig);
            this.debugWithName("Created TCK Page: " + pageName);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(request.getRequestURL().toString());
        if (!request.getRequestURL().toString().endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(pageName);
        this.debugWithName("Sending redirect to: " + buffer.toString());
        response.sendRedirect(buffer.toString());
    }

    private void debugWithName(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[Pluto TCK Driver] " + message);
        }
    }
}

