/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.pluto.driver.container.ApplicationIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationIdResolver
implements ApplicationIdResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationIdResolver.class);
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String JNDI_PREFIX = "jndi:/";

    public String resolveApplicationId(ServletContext context) {
        try {
            URL webXmlUrl = context.getResource(WEB_XML);
            String path = webXmlUrl.toExternalForm();
            path = path.substring(0, path.indexOf(WEB_XML));
            int slash = path.lastIndexOf(47);
            path = slash < JNDI_PREFIX.length() && path.startsWith(JNDI_PREFIX) ? "" : path.substring(slash);
            int id = path.indexOf(".war");
            if (id > 0) {
                path = path.substring(0, id);
            }
            return path;
        }
        catch (MalformedURLException e) {
            LOG.warn("Error retrieving web.xml from ServletContext. Unable to derive contextPath.");
            return null;
        }
    }

    public int getAuthority() {
        return 3;
    }
}

