/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.util.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPortletInvokerService
implements PortletInvokerService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPortletInvokerService.class);
    private static final StringManager EXCEPTIONS = StringManager.getManager((String)DefaultPortletInvokerService.class.getPackage().getName());
    private static final String PREFIX = "/PlutoInvoker/";
    private PortletContextService portletContextService;

    public DefaultPortletInvokerService(PortletContextService portletContextService) {
        this.portletContextService = portletContextService;
    }

    public void action(PortletRequestContext context, ActionRequest request, ActionResponse response, FilterManager filterManager) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Action Invocation");
        }
        this.invoke(context, (PortletRequest)request, (PortletResponse)response, filterManager, PortletInvokerService.METHOD_ACTION);
    }

    public void render(PortletRequestContext context, RenderRequest request, RenderResponse response, FilterManager filterManager) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Render Invocation");
        }
        this.invoke(context, (PortletRequest)request, (PortletResponse)response, filterManager, PortletInvokerService.METHOD_RENDER);
    }

    public void event(PortletRequestContext context, EventRequest request, EventResponse response, FilterManager filterManager) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Render Invocation");
        }
        this.invoke(context, (PortletRequest)request, (PortletResponse)response, filterManager, PortletInvokerService.METHOD_EVENT);
    }

    public void serveResource(PortletRequestContext context, ResourceRequest request, ResourceResponse response, FilterManager filterManager) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Resource Invocation");
        }
        this.invoke(context, (PortletRequest)request, (PortletResponse)response, filterManager, PortletInvokerService.METHOD_RESOURCE);
    }

    public void load(PortletRequestContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Load Invocation.");
        }
        this.invoke(context, request, response, PortletInvokerService.METHOD_LOAD);
    }

    public void admin(PortletRequestContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException, PortletContainerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Admin Invocation.");
        }
        this.invoke(context, request, response, PortletInvokerService.METHOD_ADMIN);
    }

    private final void invoke(PortletRequestContext context, PortletRequest request, PortletResponse response, Integer methodID) throws PortletException, IOException, PortletContainerException {
        this.invoke(context, request, response, null, methodID);
    }

    protected final void invoke(PortletRequestContext context, PortletRequest request, PortletResponse response, FilterManager filterManager, Integer methodID) throws PortletException, IOException, PortletContainerException {
        RequestDispatcher dispatcher;
        PortletWindow portletWindow = context.getPortletWindow();
        String appName = portletWindow.getPortletDefinition().getApplication().getName();
        ServletContext servletContext = this.portletContextService.getPortletContext(appName).getServletContext();
        String uri = PREFIX + portletWindow.getPortletDefinition().getPortletName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching to portlet servlet at: " + uri);
        }
        if ((dispatcher = servletContext.getRequestDispatcher(uri)) != null) {
            HttpServletRequest containerRequest = context.getContainerRequest();
            HttpServletResponse containerResponse = context.getContainerResponse();
            try {
                containerRequest.setAttribute("org.apache.pluto.core.method", (Object)methodID);
                containerRequest.setAttribute("javax.portlet.request", (Object)request);
                containerRequest.setAttribute("javax.portlet.response", (Object)response);
                containerRequest.setAttribute("FilterManager", (Object)filterManager);
                if (methodID.equals(PortletInvokerService.METHOD_RESOURCE)) {
                    dispatcher.forward((ServletRequest)containerRequest, (ServletResponse)containerResponse);
                }
                dispatcher.include((ServletRequest)containerRequest, (ServletResponse)containerResponse);
            }
            catch (javax.servlet.UnavailableException ex) {
                int seconds = ex.isPermanent() ? -1 : ex.getUnavailableSeconds();
                String message = EXCEPTIONS.getString("error.portlet.invoker.unavailable", (Object)uri, (Object)new String[]{String.valueOf(seconds)});
                if (LOG.isErrorEnabled()) {
                    LOG.error(message, (Throwable)ex);
                }
                throw new UnavailableException(message, seconds);
            }
            catch (ServletException ex) {
                String message = EXCEPTIONS.getString("error.portlet.invoker");
                if (LOG.isErrorEnabled()) {
                    LOG.error(message);
                }
                if (ex.getRootCause() != null && ex.getRootCause() instanceof PortletException) {
                    throw (PortletException)ex.getRootCause();
                }
                if (ex.getRootCause() != null) {
                    throw new PortletException(ex.getRootCause());
                }
                throw new PortletException((Throwable)ex);
            }
            finally {
                containerRequest.removeAttribute("org.apache.pluto.core.method");
                containerRequest.removeAttribute("javax.portlet.request");
                containerRequest.removeAttribute("javax.portlet.response");
                containerRequest.removeAttribute("FilterManager");
            }
        } else {
            String msg = EXCEPTIONS.getString("error.portlet.invoker.dispatcher", (Object[])new String[]{servletContext.getServletContextName(), uri});
            if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
            throw new PortletException(msg);
        }
    }
}

