/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import com.kingdee.portal.biz.core.PortletRuntimeDataLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.PortletPreferencesService;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletPreferenceImpl;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPortletPreferencesService
implements PortletPreferencesService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPortletPreferencesService.class);
    private Map<String, Map<String, PortletPreference>> storage = new HashMap<String, Map<String, PortletPreference>>();
    private Map<PortletDefinition, PreferencesValidator> cache = new HashMap<PortletDefinition, PreferencesValidator>();

    public Map<String, PortletPreference> getDefaultPreferences(PortletWindow portletWindow, PortletRequest request) throws PortletContainerException {
        HashMap<String, PortletPreferenceImpl> preferences = null;
        PortletDefinition portlet = portletWindow.getPortletDefinition();
        Preferences prefs = portlet.getPortletPreferences();
        if (prefs != null && prefs.getPortletPreferences() != null) {
            preferences = new HashMap<String, PortletPreferenceImpl>(prefs.getPortletPreferences().size());
            for (Preference pref : prefs.getPortletPreferences()) {
                String[] values = null;
                if (pref.getValues() != null && pref.getValues().size() > 0) {
                    values = pref.getValues().toArray(new String[pref.getValues().size()]);
                }
                preferences.put(pref.getName(), new PortletPreferenceImpl(pref.getName(), values, pref.isReadOnly()));
            }
        }
        return preferences;
    }

    public Map<String, PortletPreference> getStoredPreferences(PortletWindow portletWindow, PortletRequest request) throws PortletContainerException {
        PortletWindowConfig portletWindowConfig = PortletWindowConfig.fromId(portletWindow.getId().getStringId());
        String metaInfo = portletWindowConfig.getMetaInfo();
        Map preferenceMap = PortletRuntimeDataLoader.findStoredPreferences((PortletSession)request.getPortletSession(), (String)metaInfo);
        Map<String, PortletPreference> preferences = DefaultPortletPreferencesService.convMap4Preferences(preferenceMap);
        if (preferences == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No portlet preferences found for: " + portletWindowConfig.getId());
            }
            return Collections.emptyMap();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got " + preferences.size() + " stored preferences.");
        }
        return preferences;
    }

    public void store(PortletWindow portletWindow, PortletRequest request, Map<String, PortletPreference> preferences) throws PortletContainerException {
        PortletWindowConfig portletWindowConfig = PortletWindowConfig.fromId(portletWindow.getId().getStringId());
        String metaInfo = portletWindowConfig.getMetaInfo();
        PortletRuntimeDataLoader.storePortletPreferences((PortletSession)request.getPortletSession(), (String)metaInfo, preferences);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Portlet preferences stored for: " + portletWindowConfig.getId());
        }
    }

    private static Map<String, PortletPreference> convMap4Preferences(Map<String, List<String>> preferences) {
        HashMap<String, PortletPreferenceImpl> preferenceMap = null;
        if (preferences != null && !preferences.isEmpty()) {
            preferenceMap = new HashMap<String, PortletPreferenceImpl>(preferences.keySet().size());
            for (String preferenceName : preferences.keySet()) {
                String[] values = null;
                if (preferences.get(preferenceName) != null && preferences.get(preferenceName).size() > 0) {
                    values = preferences.get(preferenceName).toArray(new String[preferences.get(preferenceName).size()]);
                }
                preferenceMap.put(preferenceName, new PortletPreferenceImpl(preferenceName, values, false));
            }
        }
        return preferenceMap;
    }

    private String getFormattedKey(PortletWindow portletWindow, PortletRequest request) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("user=").append(request.getRemoteUser()).append(";");
        buffer.append("portletName=").append(portletWindow.getPortletDefinition().getPortletName());
        return buffer.toString();
    }

    private Map<String, PortletPreference> clonePreferences(Map<String, PortletPreference> preferences) {
        if (preferences == null) {
            return null;
        }
        HashMap<String, PortletPreference> copy = new HashMap<String, PortletPreference>(preferences.size());
        for (PortletPreference p : preferences.values()) {
            copy.put(p.getName(), p.clone());
        }
        return copy;
    }

    public PreferencesValidator getPreferencesValidator(PortletDefinition portletDD) throws ValidatorException {
        String className;
        PreferencesValidator validator = this.cache.get(portletDD);
        if (validator != null) {
            return validator;
        }
        Preferences portletPreferencesDD = portletDD.getPortletPreferences();
        if (portletPreferencesDD != null && (className = portletPreferencesDD.getPreferencesValidator()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating preferences validator: " + className);
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = loader.loadClass(className);
                validator = (PreferencesValidator)clazz.newInstance();
                this.cache.put(portletDD, validator);
            }
            catch (InstantiationException ex) {
                LOG.error("Error instantiating validator.", (Throwable)ex);
                throw new ValidatorException((Throwable)ex, null);
            }
            catch (IllegalAccessException ex) {
                LOG.error("Error instantiating validator.", (Throwable)ex);
                throw new ValidatorException((Throwable)ex, null);
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Error instantiating validator.", (Throwable)ex);
                throw new ValidatorException((Throwable)ex, null);
            }
            catch (ClassCastException ex) {
                LOG.error("Error casting instance to PreferencesValidator.", (Throwable)ex);
                throw new ValidatorException((Throwable)ex, null);
            }
        }
        return validator;
    }
}

