/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.util.StringManager;

public class PortletDescriptorRegistry {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String PORTLET_XML = "/WEB-INF/portlet.xml";
    private static final StringManager EXCEPTIONS = StringManager.getManager((String)PortletDescriptorRegistry.class.getPackage().getName());
    private final PortletAppDescriptorService portletDDService;
    private final Map<ServletContext, PortletApplicationDefinition> cache = new WeakHashMap<ServletContext, PortletApplicationDefinition>();

    PortletDescriptorRegistry(PortletAppDescriptorService portletDDService) {
        this.portletDDService = portletDDService;
    }

    public PortletApplicationDefinition getPortletAppDD(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = this.cache.get(servletContext);
        if (portletApp == null) {
            portletApp = this.createDefinition(servletContext, name, contextPath);
            this.cache.put(servletContext, portletApp);
        }
        return portletApp;
    }

    private PortletApplicationDefinition createDefinition(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = null;
        try {
            InputStream paIn = servletContext.getResourceAsStream(PORTLET_XML);
            InputStream webIn = servletContext.getResourceAsStream(WEB_XML);
            if (paIn == null) {
                throw new PortletContainerException("Cannot find '/WEB-INF/portlet.xml'. Are you sure it is in the deployed package?");
            }
            if (webIn == null) {
                throw new PortletContainerException("Cannot find '/WEB-INF/web.xml'. Are you sure it is in the deployed package?");
            }
            portletApp = this.portletDDService.read(name, contextPath, paIn);
            this.portletDDService.mergeWebDescriptor(portletApp, webIn);
        }
        catch (Exception ex) {
            throw new PortletContainerException(EXCEPTIONS.getString("error.context.descriptor.load", (Object[])new String[]{servletContext.getServletContextName()}), (Throwable)ex);
        }
        return portletApp;
    }
}

