/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.core;

import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.PortletWindowID;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.PortletType;
import org.apache.pluto.driver.core.PortletWindowIDImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletWindowImpl
implements PortletWindow {
    private static final Logger LOG = LoggerFactory.getLogger(PortletWindowImpl.class);
    private PortletWindowConfig config;
    private PortalURL portalURL;
    private PortletWindowIDImpl objectIdImpl;
    private PortletDefinition portlet;

    public PortletWindowImpl(PortletContainer container, PortletWindowConfig config, PortalURL portalURL) {
        this.config = config;
        this.portalURL = portalURL;
        try {
            String applicationName = config.getContextPath();
            this.portlet = PlutoServices.getServices().getPortletRegistryService().getPortlet(applicationName, config.getPortletName());
            this.portlet = this.copyPortletDefinition(this.portlet);
        }
        catch (PortletContainerException ex) {
            String message = "Unable to load Portlet App Deployment Descriptor:" + ex.getMessage();
            ex.printStackTrace();
            LOG.error(message, (Throwable)ex);
            throw new RuntimeException(message);
        }
    }

    private PortletDefinition copyPortletDefinition(PortletDefinition portlet) {
        PortletType portletType = new PortletType();
        portletType.setApplication(portlet.getApplication());
        portletType.setCacheScope(portlet.getCacheScope());
        portletType.setExpirationCache(portlet.getExpirationCache());
        portletType.setPortletClass(portlet.getPortletClass());
        portletType.setPortletName(portlet.getPortletName());
        portletType.setResourceBundle(portlet.getResourceBundle());
        portletType.getPortletInfo().setTitle(portlet.getPortletInfo().getTitle());
        portletType.getPortletInfo().setShortTitle(portlet.getPortletInfo().getShortTitle());
        portletType.getPortletInfo().setKeywords(portlet.getPortletInfo().getKeywords());
        List displayNames = portlet.getDisplayNames();
        for (DisplayName displayName : displayNames) {
            portletType.addDisplayName(displayName.getLang()).setDisplayName(displayName.getDisplayName());
        }
        List initParams = portlet.getInitParams();
        for (InitParam initParam : initParams) {
            portletType.addInitParam(initParam.getParamName()).setParamValue(initParam.getParamValue());
        }
        List preferences = portlet.getPortletPreferences().getPortletPreferences();
        for (Preference preference : preferences) {
            portletType.getPortletPreferences().addPreference(preference.getName()).getValues().addAll(preference.getValues());
        }
        List containerRuntimeOptions = portlet.getContainerRuntimeOptions();
        for (ContainerRuntimeOption containerRuntimeOption : containerRuntimeOptions) {
            portletType.addContainerRuntimeOption(containerRuntimeOption.getName()).getValues().addAll(containerRuntimeOption.getValues());
        }
        List supportedLocales = portlet.getSupportedLocales();
        for (String supportedLocale : supportedLocales) {
            portletType.addSupportedLocale(supportedLocale);
        }
        List supportsList = portlet.getSupports();
        for (Supports supports : supportsList) {
            Supports defintionSupports = portletType.addSupports(supports.getMimeType());
            List modes = supports.getPortletModes();
            for (String mode : modes) {
                defintionSupports.addPortletMode(mode);
            }
        }
        List processingEvents = portlet.getSupportedProcessingEvents();
        for (EventDefinitionReference event : processingEvents) {
            portletType.addSupportedProcessingEvent(event.getQName());
        }
        List publishingEvents = portlet.getSupportedPublishingEvents();
        for (EventDefinitionReference event : publishingEvents) {
            portletType.addSupportedPublishingEvent(event.getQName());
        }
        List renderParams = portlet.getSupportedPublicRenderParameters();
        for (String renderParam : renderParams) {
            portletType.addSupportedPublicRenderParameter(renderParam);
        }
        return portletType;
    }

    public String getContextPath() {
        return this.config.getContextPath();
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public WindowState getWindowState() {
        return this.portalURL.getWindowState(this.getId().getStringId());
    }

    public PortletMode getPortletMode() {
        return this.portalURL.getPortletMode(this.getId().getStringId());
    }

    public PortletWindowID getId() {
        if (this.objectIdImpl == null) {
            this.objectIdImpl = PortletWindowIDImpl.createFromString(this.config.getId());
        }
        return this.objectIdImpl;
    }

    public PortletDefinition getPortletDefinition() {
        return this.portlet;
    }
}

