/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RenderConfig.class);
    private Map pages = new HashMap();
    private String defaultPageId;
    private int orderNumberCounter = 0;
    private Comparator pageComparator = new Comparator(){

        public int compare(Object a, Object b) {
            PageConfig pa = (PageConfig)a;
            PageConfig pb = (PageConfig)b;
            if (pa.getOrderNumber() > pb.getOrderNumber()) {
                return 1;
            }
            if (pa.getOrderNumber() == pb.getOrderNumber()) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object a) {
            return false;
        }
    };

    public String getDefaultPageId() {
        return this.defaultPageId;
    }

    public void setDefaultPageId(String defaultPageId) {
        this.defaultPageId = defaultPageId;
    }

    public List getPages() {
        ArrayList col = new ArrayList(this.pages.values());
        Collections.sort(col, this.pageComparator);
        return col;
    }

    public PageConfig getPageConfig(String pageId) {
        PageConfig retval;
        if (pageId == null || "".equals(pageId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requested page is null.  Returning default: " + this.defaultPageId);
            }
            pageId = this.defaultPageId;
        }
        if ((retval = (PageConfig)this.pages.get(pageId)) == null && pageId.startsWith("/") && pageId.length() > 2) {
            retval = (PageConfig)this.pages.get(pageId.substring(1));
        }
        if (retval == null) {
            LOG.warn("Couldn't find a PageConfig for page ID: [" + pageId + "]");
            retval = (PageConfig)this.pages.get(this.defaultPageId);
            if (retval != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning default page ID: [" + this.defaultPageId + "]");
                }
            } else {
                LOG.error("Could not find default page Id for render config!");
            }
        }
        return retval;
    }

    public void addPage(PageConfig config) {
        config.setOrderNumber(this.orderNumberCounter++);
        this.pages.put(config.getName(), config);
    }

    public void removePage(PageConfig config) {
        this.pages.remove(config.getName());
    }
}

