/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import javax.portlet.PortletMode;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.tags.PortletTag;
import org.apache.pluto.driver.tags.ToolTips;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletModeAnchorTag
extends BodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PortletModeAnchorTag.class);
    private String portletMode = null;
    private String portletId = null;
    private String evaluatedPortletId = null;

    public int doStartTag() throws JspException {
        PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, PortletTag.class);
        if (parentTag == null) {
            throw new JspException("Portlet window controls may only reside within a pluto:portlet tag.");
        }
        this.portletId = parentTag.getPortletId();
        this.evaluatePortletId();
        ServletContext servletContext = this.pageContext.getServletContext();
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
        if (this.isPortletModeAllowed(driverConfig, this.portletMode)) {
            PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)this.pageContext.getRequest());
            PortalURL portalUrl = portalEnv.createPortalURL();
            portalUrl.setPortletMode(this.evaluatedPortletId, new PortletMode(this.portletMode));
            StringBuffer tag = new StringBuffer();
            tag.append("<a title=\"");
            tag.append(ToolTips.forMode(new PortletMode(this.portletMode)));
            tag.append("\" ");
            tag.append("href=\"" + ((Object)portalUrl).toString() + "\">");
            tag.append("<span class=\"" + this.portletMode + "\"></span>");
            tag.append("</a>");
            try {
                JspWriter out = this.pageContext.getOut();
                out.print(tag.toString());
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 1;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    private void evaluatePortletId() throws JspException {
        Object obj = ExpressionEvaluatorManager.evaluate((String)"portletId", (String)this.portletId, String.class, (Tag)this, (PageContext)this.pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated portletId to: " + obj);
        }
        this.evaluatedPortletId = (String)obj;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    private boolean isPortletModeAllowed(DriverConfiguration config, String mode) {
        LOG.debug("Testing if PortletWindowConfig [" + this.getEvaluatedPortletId() + "] supports mode [" + mode + "]");
        return config.isPortletModeSupported(this.getEvaluatedPortletId(), mode);
    }
}

