/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.tags.PortletTag;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletModeDropDownTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletModeDropDownTag.class);
    private String portletMode = null;
    private String portletId = null;
    private String evaluatedPortletId = null;

    public int doStartTag() throws JspException {
        PortletWindowImpl window;
        PortalURL requestedPortalUrl;
        PortalRequestContext portalEnv;
        DriverConfiguration driverConfig;
        block13: {
            PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, PortletTag.class);
            if (parentTag == null) {
                throw new JspException("Portlet window controls may only reside within a pluto:portlet tag.");
            }
            this.portletId = parentTag.getPortletId();
            this.evaluatePortletId();
            ServletContext servletContext = this.pageContext.getServletContext();
            driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
            portalEnv = PortalRequestContext.getContext((HttpServletRequest)this.pageContext.getRequest());
            requestedPortalUrl = portalEnv.getRequestedPortalURL();
            PortletWindowConfig windowConfig = PortletWindowConfig.fromId(this.evaluatedPortletId);
            PortletContainer container = (PortletContainer)servletContext.getAttribute("portletContainer");
            window = null;
            try {
                window = new PortletWindowImpl(container, windowConfig, requestedPortalUrl);
            }
            catch (RuntimeException ex) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug("The portlet " + windowConfig.getPortletName() + " is not available. Is already deployed?");
            }
        }
        StringBuffer tag = new StringBuffer();
        if (window != null) {
            PortletMode currentMode = requestedPortalUrl.getPortletMode(window.getId().getStringId());
            tag.append("<form action=\"\" name=\"modeSelectionForm\" style=\"display:inline\"><select onchange=\"self.location=this.options[this.selectedIndex].value\">");
            Set<PortletMode> modeSet = null;
            try {
                modeSet = driverConfig.getSupportedPortletModes(this.evaluatedPortletId);
            }
            catch (PortletContainerException e) {
                throw new JspException((Throwable)e);
            }
            if (modeSet != null) {
                for (PortletMode mode : modeSet) {
                    PortalURL portalUrl = portalEnv.createPortalURL();
                    portalUrl.setPortletMode(this.evaluatedPortletId, mode);
                    tag.append("<option value=\"" + ((Object)portalUrl).toString() + "\"");
                    if (mode.equals((Object)currentMode)) {
                        tag.append(" selected=\"true\"");
                    }
                    tag.append(">");
                    if (driverConfig.isPortletManagedMode(this.evaluatedPortletId, mode.toString())) {
                        tag.append(this.getCustomModeDecorationName(driverConfig, mode));
                    } else {
                        tag.append(mode.toString().toUpperCase());
                    }
                    tag.append("</option>");
                }
            }
            tag.append("</select></form>");
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(tag.toString());
        }
        catch (IOException ex) {
            throw new JspException((Throwable)ex);
        }
        return 1;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    private void evaluatePortletId() throws JspException {
        Object obj = ExpressionEvaluatorManager.evaluate((String)"portletId", (String)this.portletId, String.class, (Tag)this, (PageContext)this.pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated portletId to: " + obj);
        }
        this.evaluatedPortletId = (String)obj;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    private boolean isPortletModeAllowed(DriverConfiguration config, String mode) {
        LOG.debug("Testing if PortletWindowConfig [" + this.getEvaluatedPortletId() + "] supports mode [" + mode + "]");
        return config.isPortletModeSupported(this.getEvaluatedPortletId(), mode);
    }

    private String getCustomModeDecorationName(DriverConfiguration driverConfig, PortletMode mode) {
        String decorationName = mode.toString().toUpperCase();
        try {
            PortletConfig config = driverConfig.getPortletConfig(this.evaluatedPortletId);
            ServletRequest request = this.pageContext.getRequest();
            Locale defaultLocale = request.getLocale();
            ResourceBundle bundle = config.getResourceBundle(defaultLocale);
            StringBuffer res = new StringBuffer();
            res.append("javax.portlet.app.custom-portlet-mode.");
            res.append(mode.toString());
            res.append(".decoration-name");
            decorationName = bundle.getString(res.toString());
        }
        catch (Exception e) {
            LOG.debug("Problem finding decoration-name for custom mode: " + mode.toString());
        }
        return decorationName;
    }
}

