/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortalServletResponse;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.tags.el.ExpressionEvaluatorProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletTag
extends BodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PortletTag.class);
    public static final int FAILED = 0;
    public static final int SUCCESS = 1;
    private String portletId;
    private String evaluatedPortletId;
    private PortalServletResponse response;
    private int status;
    private Throwable throwable;

    public String getPortletId() {
        return this.portletId;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public int doStartTag() throws JspException {
        PortletWindowImpl window;
        PortletContainer container;
        PortalURL portalURL;
        PortletWindowConfig windowConfig;
        block7: {
            this.evaluatePortletId();
            ServletContext servletContext = this.pageContext.getServletContext();
            windowConfig = PortletWindowConfig.fromId(this.evaluatedPortletId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rendering Portlet Window: " + windowConfig);
            }
            PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)this.pageContext.getRequest());
            portalURL = portalEnv.getRequestedPortalURL();
            container = (PortletContainer)servletContext.getAttribute("portletContainer");
            window = null;
            try {
                window = new PortletWindowImpl(container, windowConfig, portalURL);
            }
            catch (RuntimeException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("The portlet " + windowConfig.getPortletName() + " is not available. Is already deployed?");
            }
        }
        PortalServletResponse portalResponse = new PortalServletResponse((HttpServletResponse)this.pageContext.getResponse());
        if (window != null) {
            Map<String, WindowState> windowStates = portalURL.getWindowStates();
            for (String windowId : windowStates.keySet()) {
                WindowState windowState = windowStates.get(windowId);
                if (!WindowState.MAXIMIZED.equals((Object)windowState) || window.getId().getStringId().equals(windowId)) continue;
                return 0;
            }
        }
        try {
            container.doRender((PortletWindow)window, (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)portalResponse);
            this.response = portalResponse;
            this.status = 1;
        }
        catch (Throwable th) {
            this.status = 0;
            this.throwable = th;
        }
        this.pageContext.getRequest().setAttribute("_portletMode", (Object)window.getPortletMode().toString());
        this.pageContext.getRequest().setAttribute("_portletInsId", (Object)windowConfig.getPortletInsId());
        return 1;
    }

    int getStatus() {
        return this.status;
    }

    PortalServletResponse getPortalServletResponse() {
        return this.response;
    }

    Throwable getThrowable() {
        return this.throwable;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    private void evaluatePortletId() throws JspException {
        ExpressionEvaluatorProxy proxy = ExpressionEvaluatorProxy.getProxy();
        String obj = proxy.evaluate(this.portletId, this.pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated portletId to: " + obj);
        }
        this.evaluatedPortletId = obj;
    }
}

