/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.tags.PortletTag;
import org.apache.pluto.driver.tags.ToolTips;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletWindowStateAnchorTag
extends BodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PortletWindowStateAnchorTag.class);
    private String state;
    private String icon;
    private String portletId;
    private String evaluatedPortletId;

    public int doStartTag() throws JspException {
        PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, PortletTag.class);
        if (parentTag == null) {
            throw new JspException("Portlet window controls may only reside within a pluto:portlet tag.");
        }
        this.portletId = parentTag.getPortletId();
        this.evaluatePortletId();
        ServletContext servletContext = this.pageContext.getServletContext();
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
        if (this.isWindowStateAllowed(driverConfig, this.state)) {
            PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)this.pageContext.getRequest());
            PortalURL portalUrl = portalEnv.createPortalURL();
            portalUrl.setWindowState(this.evaluatedPortletId, new WindowState(this.state));
            StringBuffer tag = new StringBuffer();
            tag.append("<a title=\"");
            tag.append(ToolTips.forWindowState(new WindowState(this.state)));
            tag.append("\" ");
            tag.append("href=\"" + ((Object)portalUrl).toString() + "\">");
            tag.append("<img border=\"0\" src=\"" + this.icon + "\" />");
            tag.append("</a>");
            try {
                JspWriter out = this.pageContext.getOut();
                out.print(tag.toString());
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 1;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    private void evaluatePortletId() throws JspException {
        Object obj = ExpressionEvaluatorManager.evaluate((String)"portletId", (String)this.portletId, String.class, (Tag)this, (PageContext)this.pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated portletId to: " + obj);
        }
        this.evaluatedPortletId = (String)obj;
    }

    public String getWindowState() {
        return this.state;
    }

    public void setWindowState(String state) {
        this.state = state;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    private boolean isWindowStateAllowed(DriverConfiguration config, String state) {
        LOG.debug("Testing if PortletWindowConfig [" + this.getEvaluatedPortletId() + "] supports window state [" + state + "]");
        return config.isWindowStateSupported(this.getEvaluatedPortletId(), state);
    }
}

