/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.config.impl;

import java.util.Collection;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreferencesService;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.apache.pluto.driver.services.portal.SupportedModesService;
import org.apache.pluto.driver.services.portal.SupportedWindowStateService;
import org.apache.pluto.driver.url.PortalURLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfigurationImpl
implements DriverConfiguration {
    private final PortalURLParser portalUrlParser;
    private final PropertyConfigService propertyService;
    private final RenderConfigService renderService;
    private final SupportedModesService supportedModesService;
    private final SupportedWindowStateService supportedWindowStateService;
    private PortletPreferencesService portletPreferencesService;

    public DriverConfigurationImpl(PortalURLParser portalUrlParser, PropertyConfigService propertyService, RenderConfigService renderService, SupportedModesService supportedModesService, SupportedWindowStateService supportedWindowStateService) {
        this.portalUrlParser = portalUrlParser;
        this.propertyService = propertyService;
        this.renderService = renderService;
        this.supportedModesService = supportedModesService;
        this.supportedWindowStateService = supportedWindowStateService;
    }

    public String getPortalName() {
        return this.propertyService.getPortalName();
    }

    public String getPortalVersion() {
        return this.propertyService.getPortalVersion();
    }

    public String getContainerName() {
        return this.propertyService.getContainerName();
    }

    public Collection getSupportedPortletModes() {
        return this.propertyService.getSupportedPortletModes();
    }

    public Collection getSupportedWindowStates() {
        return this.propertyService.getSupportedWindowStates();
    }

    public Collection getPages() {
        return this.renderService.getPages();
    }

    public PageConfig getPageConfig(String pageId) {
        return this.renderService.getPage(pageId);
    }

    public boolean isPortletModeSupportedByPortal(String mode) {
        return this.supportedModesService.isPortletModeSupportedByPortal(mode);
    }

    public boolean isPortletModeSupportedByPortlet(String portletId, String mode) {
        return this.supportedModesService.isPortletModeSupportedByPortlet(portletId, mode);
    }

    public boolean isPortletModeSupported(String portletId, String mode) {
        return this.supportedModesService.isPortletModeSupported(portletId, mode);
    }

    public PortalURLParser getPortalUrlParser() {
        return this.portalUrlParser;
    }

    public PortletPreferencesService getPortletPreferencesService() {
        return this.portletPreferencesService;
    }

    public void setPortletPreferencesService(PortletPreferencesService portletPreferencesService) {
        this.portletPreferencesService = portletPreferencesService;
    }

    public boolean isWindowStateSupported(String portletId, String windowState) {
        return this.supportedWindowStateService.isWindowStateSupported(portletId, windowState);
    }

    public boolean isWindowStateSupportedByPortal(String windowState) {
        return this.supportedWindowStateService.isWindowStateSupportedByPortal(windowState);
    }

    public boolean isWindowStateSupportedByPortlet(String portletId, String windowState) {
        return this.supportedWindowStateService.isWindowStateSupportedByPortlet(portletId, windowState);
    }

    public RenderConfigService getRenderConfigService() {
        return this.renderService;
    }

    public Set<PortletMode> getSupportedPortletModes(String portletId) throws PortletContainerException {
        return this.supportedModesService.getSupportedPortletModes(portletId);
    }

    public boolean isPortletManagedMode(String portletId, String mode) {
        return this.supportedModesService.isPortletManagedMode(portletId, mode);
    }

    public PortletConfig getPortletConfig(String portletId) throws PortletContainerException {
        return this.supportedModesService.getPortletConfig(portletId);
    }
}

