/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.pluto.container.EventCoordinationService;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.container.EventImpl;
import org.apache.pluto.driver.services.container.PortletWindowThread;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.impl.PortalURLParserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCoordinationServiceImpl
implements EventCoordinationService {
    private static final Logger LOG = LoggerFactory.getLogger(EventCoordinationServiceImpl.class);
    private static final long WAITING_CYCLE = 100L;
    private final PortletRegistryService portletRegistry;
    private final PortletContextService portletContextService;

    public EventCoordinationServiceImpl(PortletRegistryService portletRegistry, PortletContextService portletContextService) {
        this.portletRegistry = portletRegistry;
        this.portletContextService = portletContextService;
    }

    public void processEvents(PortletContainer container, PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response, List<Event> events) {
        ServletContext containerServletContext = PortalRequestContext.getContext((HttpServletRequest)request).getServletContext();
        DriverConfiguration driverConfig = (DriverConfiguration)containerServletContext.getAttribute("driverConfig");
        PortalURL portalURL = PortalURLParserImpl.getParser().parse(request);
        for (Event event : events) {
            List<String> portletNames = this.getAllPortletsRegisteredForEvent(event, driverConfig, containerServletContext);
            Collection<PortletWindowConfig> portlets = this.getAllPortlets(driverConfig);
            for (PortletWindowConfig config : portlets) {
                PortletWindowImpl window = new PortletWindowImpl(container, config, portalURL);
                if (portletNames == null) continue;
                for (String portlet : portletNames) {
                    if (!portlet.equals(config.getId())) continue;
                    this.doEvent(container, (PortletWindow)window, event, request, response);
                }
            }
        }
    }

    protected void doEvent(PortletContainer container, PortletWindow portletWindow, Event event, HttpServletRequest request, HttpServletResponse response) {
        try {
            Serializable value = event.getValue();
            XMLStreamReader xml = null;
            try {
                if (value instanceof String) {
                    String in = (String)((Object)value);
                    xml = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(in));
                }
            }
            catch (XMLStreamException e1) {
                throw new IllegalStateException(e1);
            }
            catch (FactoryConfigurationError e1) {
                throw new IllegalStateException(e1);
            }
            if (xml != null) {
                try {
                    EventDefinition eventDefinitionDD = this.getEventDefintion(portletWindow, event.getQName());
                    ClassLoader loader = this.portletContextService.getClassLoader(portletWindow.getPortletDefinition().getApplication().getName());
                    Class<Serializable> clazz = loader.loadClass(eventDefinitionDD.getValueType()).asSubclass(Serializable.class);
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    JAXBElement result = unmarshaller.unmarshal(xml, clazz);
                    event = new EventImpl(event.getQName(), (Serializable)result.getValue());
                }
                catch (JAXBException e) {
                    throw new IllegalStateException(e);
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (PortletContainerException e) {
                    throw new IllegalStateException(e);
                }
            }
            container.doEvent(portletWindow, request, response, event);
        }
        catch (PortletException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        catch (PortletContainerException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private EventDefinition getEventDefintion(PortletWindow portletWindow, QName name) {
        PortletApplicationDefinition appDD = portletWindow.getPortletDefinition().getApplication();
        for (EventDefinition def : appDD.getEventDefinitions()) {
            QName tmp;
            if (!(def.getQName() != null ? def.getQName().equals(name) : (tmp = new QName(appDD.getDefaultNamespace(), def.getName())).equals(name))) continue;
            return def;
        }
        throw new IllegalStateException();
    }

    private List<String> getAllPortletsRegisteredForEvent(Event event, DriverConfiguration driverConfig, ServletContext containerServletContext) {
        HashSet<String> resultSet = new HashSet<String>();
        ArrayList<String> resultList = new ArrayList<String>();
        QName eventName = event.getQName();
        Collection<PortletWindowConfig> portlets = this.getAllPortlets(driverConfig);
        for (PortletWindowConfig portlet : portlets) {
            String contextPath;
            String applicationName = contextPath = portlet.getContextPath();
            PortletApplicationDefinition portletAppDD = null;
            try {
                portletAppDD = this.portletRegistry.getPortletApplication(applicationName);
                List portletDDs = portletAppDD.getPortlets();
                List<QName> aliases = this.getAllAliases(eventName, portletAppDD);
                for (PortletDefinition portletDD : portletDDs) {
                    List processingEvents = portletDD.getSupportedProcessingEvents();
                    if (this.isEventSupported(processingEvents, eventName, portletAppDD.getDefaultNamespace())) {
                        if (!portletDD.getPortletName().equals(portlet.getPortletName())) continue;
                        resultSet.add(portlet.getId());
                        continue;
                    }
                    if (processingEvents == null) continue;
                    for (EventDefinitionReference ref : processingEvents) {
                        QName name = ref.getQualifiedName(portletAppDD.getDefaultNamespace());
                        if (name == null) continue;
                        if (name.toString().endsWith(".") && eventName.toString().startsWith(name.toString()) && portletDD.getPortletName().equals(portlet.getPortletName())) {
                            resultSet.add(portlet.getId());
                        }
                        if (aliases != null) {
                            for (QName alias : aliases) {
                                if (!alias.toString().equals(name.toString()) || !portletDD.getPortletName().equals(portlet.getPortletName())) continue;
                                resultSet.add(portlet.getId());
                            }
                        }
                        if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) continue;
                        String defaultNamespace = portletAppDD.getDefaultNamespace();
                        QName qname = new QName(defaultNamespace, name.getLocalPart());
                        if (!eventName.toString().equals(qname.toString()) || !portletDD.getPortletName().equals(portlet.getPortletName())) continue;
                        resultSet.add(portlet.getId());
                    }
                }
            }
            catch (PortletContainerException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        for (String name : resultSet) {
            resultList.add(name);
        }
        return resultList;
    }

    private boolean isEventSupported(List<? extends EventDefinitionReference> supportedEvents, QName eventName, String defaultNamespace) {
        if (supportedEvents != null) {
            for (EventDefinitionReference eventDefinitionReference : supportedEvents) {
                QName refQName = eventDefinitionReference.getQualifiedName(defaultNamespace);
                if (refQName == null || !refQName.equals(eventName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<QName> getAllAliases(QName eventName, PortletApplicationDefinition portletAppDD) {
        if (portletAppDD.getEventDefinitions() != null) {
            for (EventDefinition def : portletAppDD.getEventDefinitions()) {
                QName defQName = def.getQualifiedName(portletAppDD.getDefaultNamespace());
                if (defQName == null || !defQName.equals(eventName)) continue;
                return def.getAliases();
            }
        }
        return null;
    }

    private PortletWindowThread getPortletWindowThread(Map<String, PortletWindowThread> portletWindowThreads, ThreadGroup threadGroup, PortletContainer container, PortletWindowConfig config, PortletWindow window, HttpServletRequest req, HttpServletResponse res, ServletContext containerServletContext) {
        String windowID = window.getId().getStringId();
        PortletWindowThread portletWindowThread = portletWindowThreads.get(windowID);
        if (portletWindowThread == null) {
            portletWindowThread = new PortletWindowThread(threadGroup, config.getId(), container, window, req, res, this.portletContextService);
            portletWindowThreads.put(windowID, portletWindowThread);
        } else {
            try {
                portletWindowThread.join();
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            portletWindowThreads.remove(windowID);
            portletWindowThread = new PortletWindowThread(threadGroup, config.getId(), container, window, req, res, this.portletContextService);
            portletWindowThreads.put(windowID, portletWindowThread);
        }
        return portletWindowThread;
    }

    private void waitForEventExecution(ThreadGroup threadGroup) {
        long counter = 0L;
        while (threadGroup.activeCount() > 0) {
            try {
                counter = 100L;
                if (counter > 500L) {
                    threadGroup.stop();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Collection<PortletWindowConfig> getAllPortlets(DriverConfiguration driverConfig) {
        ArrayList<PortletWindowConfig> portlets = new ArrayList<PortletWindowConfig>();
        Collection pages = driverConfig.getPages();
        if (pages != null) {
            for (PageConfig pageConfig : pages) {
                Collection portletIDs = pageConfig.getPortletIds();
                if (portletIDs == null) continue;
                Iterator iPortletIDs = portletIDs.iterator();
                while (iPortletIDs.hasNext()) {
                    portlets.add(PortletWindowConfig.fromId((String)iPortletIDs.next().toString()));
                }
            }
        }
        return portlets;
    }
}

