/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.pluto.container.EventProvider;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.driver.services.container.EventImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProviderImpl
implements EventProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EventProviderImpl.class);
    private PortletWindow portletWindow;
    private PortletRegistryService portletRegistry;

    public EventProviderImpl(PortletWindow portletWindow, PortletRegistryService portletRegistry) {
        this.portletWindow = portletWindow;
        this.portletRegistry = portletRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event createEvent(QName qname, Serializable value) throws IllegalArgumentException {
        if (this.isDeclaredAsPublishingEvent(qname)) {
            if (value != null && !this.isValueInstanceOfDefinedClass(qname, value)) {
                throw new IllegalArgumentException("Payload class (" + value.getClass().getCanonicalName() + ") does not have the right class, check your defined event types in portlet.xml.");
            }
            try {
                if (value == null) {
                    return new EventImpl(qname, value);
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                StringWriter out = new StringWriter();
                Class<?> clazz = value.getClass();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Marshaller marshaller = jc.createMarshaller();
                    JAXBElement element = new JAXBElement(qname, clazz, (Object)value);
                    marshaller.marshal((Object)element, (Writer)out);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                return new EventImpl(qname, (Serializable)((Object)((Object)out).toString()));
            }
            catch (JAXBException e) {
                LOG.error("Event handling failed", (Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isDeclaredAsPublishingEvent(QName qname) {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)this.portletWindow.getId().getStringId());
        String portletName = PortletWindowConfig.parsePortletName((String)this.portletWindow.getId().getStringId());
        List events = null;
        try {
            events = this.portletRegistry.getPortlet(applicationName, portletName).getSupportedPublishingEvents();
        }
        catch (PortletContainerException e1) {
            e1.printStackTrace();
        }
        if (events != null) {
            String defaultNamespace = this.portletWindow.getPortletDefinition().getApplication().getDefaultNamespace();
            for (EventDefinitionReference ref : events) {
                QName name = ref.getQualifiedName(defaultNamespace);
                if (name == null || !qname.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValueInstanceOfDefinedClass(QName qname, Serializable value) {
        PortletApplicationDefinition app = this.portletWindow.getPortletDefinition().getApplication();
        List events = app.getEventDefinitions();
        if (events != null) {
            for (EventDefinition def : events) {
                QName tmp;
                if (!(def.getQName() != null ? def.getQName().equals(qname) : (tmp = new QName(app.getDefaultNamespace(), def.getName())).equals(qname))) continue;
                return value.getClass().getName().equals(def.getValueType());
            }
        }
        return true;
    }
}

