/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.driver.services.container.FilterConfigImpl;

public class FilterChainImpl
implements FilterChain {
    private List<Filter> filterList = new ArrayList<Filter>();
    private String lifeCycle;
    Portlet portlet;
    EventPortlet eventPortlet;
    ResourceServingPortlet resourceServingPortlet;
    ClassLoader loader;
    PortletContext portletContext;
    int filterListIndex = 0;

    public FilterChainImpl(String lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void processFilter(EventRequest req, EventResponse res, EventPortlet eventPortlet, PortletContext portletContext) throws IOException, PortletException {
        this.eventPortlet = eventPortlet;
        this.loader = Thread.currentThread().getContextClassLoader();
        this.portletContext = portletContext;
        this.doFilter(req, res);
    }

    public void processFilter(ResourceRequest req, ResourceResponse res, ResourceServingPortlet resourceServingPortlet, PortletContext portletContext) throws IOException, PortletException {
        this.resourceServingPortlet = resourceServingPortlet;
        this.loader = Thread.currentThread().getContextClassLoader();
        this.portletContext = portletContext;
        this.doFilter(req, res);
    }

    public void processFilter(ActionRequest req, ActionResponse res, Portlet portlet, PortletContext portletContext) throws IOException, PortletException {
        this.portlet = portlet;
        this.loader = Thread.currentThread().getContextClassLoader();
        this.portletContext = portletContext;
        this.doFilter(req, res);
    }

    public void processFilter(RenderRequest req, RenderResponse res, Portlet portlet, PortletContext portletContext) throws IOException, PortletException {
        this.portlet = portlet;
        this.loader = Thread.currentThread().getContextClassLoader();
        this.portletContext = portletContext;
        this.doFilter(req, res);
    }

    public void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    public void doFilter(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            Filter filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            try {
                ActionFilter actionFilter = (ActionFilter)this.loader.loadClass(filter.getFilterClass()).newInstance();
                FilterConfigImpl filterConfig = new FilterConfigImpl(filter.getFilterName(), filter.getInitParams(), this.portletContext);
                actionFilter.init((FilterConfig)filterConfig);
                actionFilter.doFilter(request, response, (FilterChain)this);
                actionFilter.destroy();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.portlet.processAction(request, response);
        }
    }

    public void doFilter(EventRequest request, EventResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            Filter filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            try {
                EventFilter eventFilter = (EventFilter)this.loader.loadClass(filter.getFilterClass()).newInstance();
                FilterConfigImpl filterConfig = new FilterConfigImpl(filter.getFilterName(), filter.getInitParams(), this.portletContext);
                eventFilter.init((FilterConfig)filterConfig);
                eventFilter.doFilter(request, response, (FilterChain)this);
                eventFilter.destroy();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.eventPortlet.processEvent(request, response);
        }
    }

    public void doFilter(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            Filter filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            try {
                RenderFilter renderFilter = (RenderFilter)this.loader.loadClass(filter.getFilterClass()).newInstance();
                FilterConfigImpl filterConfig = new FilterConfigImpl(filter.getFilterName(), filter.getInitParams(), this.portletContext);
                renderFilter.init((FilterConfig)filterConfig);
                renderFilter.doFilter(request, response, (FilterChain)this);
                renderFilter.destroy();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.portlet.render(request, response);
        }
    }

    public void doFilter(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            Filter filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            try {
                ResourceFilter resourceFilter = (ResourceFilter)this.loader.loadClass(filter.getFilterClass()).newInstance();
                FilterConfigImpl filterConfig = new FilterConfigImpl(filter.getFilterName(), filter.getInitParams(), this.portletContext);
                resourceFilter.init((FilterConfig)filterConfig);
                resourceFilter.doFilter(request, response, (FilterChain)this);
                resourceFilter.destroy();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.resourceServingPortlet.serveResource(request, response);
        }
    }
}

