/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.container.PortletStateAwareResponseContextImpl;
import org.apache.pluto.driver.url.PortalURL;

public class PortletActionResponseContextImpl
extends PortletStateAwareResponseContextImpl
implements PortletActionResponseContext {
    private boolean redirect;
    private String redirectLocation;
    private String renderURLParamName;

    public PortletActionResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window) {
        super(container, containerRequest, containerResponse, window);
    }

    public String getResponseURL() {
        if (!this.isReleased()) {
            this.close();
            if (!this.redirect || this.renderURLParamName != null) {
                PortalURL url = PortalRequestContext.getContext((HttpServletRequest)this.getServletRequest()).createPortalURL();
                if (this.redirect) {
                    try {
                        return this.redirectLocation + "?" + URLEncoder.encode(this.renderURLParamName, "UTF-8") + "=" + URLEncoder.encode(url.toURL(true), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }
                return url.toURL(false);
            }
            return this.redirectLocation;
        }
        return null;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(String location) {
        this.setRedirect(location, null);
    }

    public void setRedirect(String location, String renderURLParamName) {
        if (!this.isClosed()) {
            this.redirectLocation = location;
            this.renderURLParamName = renderURLParamName;
            this.redirect = true;
        }
    }
}

