/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestContextImpl
implements PortletRequestContext {
    private PortletContainer container;
    private HttpServletRequest containerRequest;
    private HttpServletResponse containerResponse;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private PortletWindow window;
    private PortalURL url;
    private PortletConfig portletConfig;
    private ServletContext servletContext;
    private Cookie[] cookies;
    private boolean useRequestParameters;

    public PortletRequestContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, boolean useRequestParameters) {
        this.container = container;
        this.containerRequest = containerRequest;
        this.containerResponse = containerResponse;
        this.window = window;
        this.useRequestParameters = useRequestParameters;
        this.url = PortalRequestContext.getContext((HttpServletRequest)containerRequest).createPortalURL();
    }

    protected boolean isReservedAttributeName(String name) {
        return name.startsWith("javax.servlet.");
    }

    protected String encodeAttributeName(String name) {
        if (this.isReservedAttributeName(name)) {
            return name;
        }
        return this.container.getContainerServices().getNamespaceMapper().encode(this.window.getId(), name);
    }

    protected String decodeAttributeName(String name) {
        if (this.isReservedAttributeName(name)) {
            return name;
        }
        String result = this.container.getContainerServices().getNamespaceMapper().decode(this.window.getId(), name);
        return result != null ? result : name;
    }

    protected Map<String, String[]> getPrivateRenderParameterMap() {
        return Collections.emptyMap();
    }

    protected PortalURL getPortalURL() {
        return this.url;
    }

    protected boolean isPublicRenderParameter(String name) {
        List publicRenderParameterNames = this.window.getPortletDefinition().getSupportedPublicRenderParameters();
        return publicRenderParameterNames.isEmpty() ? false : publicRenderParameterNames.contains(name);
    }

    public void init(PortletConfig portletConfig, ServletContext servletContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.portletConfig = portletConfig;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public Object getAttribute(String name) {
        Object value = this.servletRequest.getAttribute(this.encodeAttributeName(name));
        return value != null ? value : this.servletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.servletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(this.decodeAttributeName((String)e.nextElement()));
        }
        return Collections.enumeration(names);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.servletRequest.removeAttribute(this.encodeAttributeName(name));
        } else {
            this.servletRequest.setAttribute(this.encodeAttributeName(name), value);
        }
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = this.servletRequest.getCookies();
            if (this.cookies == null) {
                this.cookies = new Cookie[0];
            }
        }
        return this.cookies.length > 0 ? (Cookie[])this.cookies.clone() : null;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public Locale getPreferredLocale() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.servletRequest);
        if (portalContext != null) {
            return portalContext.getLocale();
        }
        return this.servletRequest.getLocale();
    }

    public Map<String, String[]> getPrivateParameterMap() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        if (this.useRequestParameters) {
            parameters.putAll(this.servletRequest.getParameterMap());
        }
        for (Map.Entry<String, String[]> entry : this.getPrivateRenderParameterMap().entrySet()) {
            String[] values = (String[])parameters.get(entry.getKey());
            if (values == null) {
                parameters.put(entry.getKey(), entry.getValue());
                continue;
            }
            String[] copy = new String[values.length + entry.getValue().length];
            System.arraycopy(values, 0, copy, 0, values.length);
            System.arraycopy(entry.getValue(), 0, copy, values.length, entry.getValue().length);
            parameters.put(entry.getKey(), copy);
        }
        String windowId = this.window.getId().getStringId();
        for (PortalURLParameter parm : this.url.getParameters()) {
            if (!windowId.equals(parm.getWindowId())) continue;
            String[] values = parameters.get(parm.getName());
            if (values == null) {
                parameters.put(parm.getName(), parm.getValues());
                continue;
            }
            String[] copy = new String[values.length + parm.getValues().length];
            System.arraycopy(values, 0, copy, 0, values.length);
            System.arraycopy(parm.getValues(), 0, copy, values.length, parm.getValues().length);
            parameters.put(parm.getName(), copy);
        }
        return parameters;
    }

    public Map<String, String[]> getProperties() {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        Enumeration names = this.servletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = new ArrayList();
            Enumeration headers = this.servletRequest.getHeaders(name);
            while (headers.hasMoreElements()) {
                values.add(headers.nextElement());
            }
            int size = values.size();
            if (size <= 0) continue;
            properties.put(name, values.toArray(new String[size]));
        }
        return properties;
    }

    public Map<String, String[]> getPublicParameterMap() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        for (Map.Entry entry : this.url.getPublicParameters().entrySet()) {
            if (!this.isPublicRenderParameter((String)entry.getKey())) continue;
            parameters.put((String)entry.getKey(), (String[])entry.getValue());
        }
        return parameters;
    }

    public HttpServletRequest getContainerRequest() {
        return this.containerRequest;
    }

    public HttpServletResponse getContainerResponse() {
        return this.containerResponse;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }
}

