/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletURLGenerationListener;
import org.apache.pluto.container.PortletURLListenerService;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLListenerServiceImpl
implements PortletURLListenerService {
    private static final Logger LOG = LoggerFactory.getLogger(PortletURLListenerServiceImpl.class);

    public List<PortletURLGenerationListener> getPortletURLGenerationListeners(PortletApplicationDefinition app) {
        ArrayList<PortletURLGenerationListener> listeners = new ArrayList<PortletURLGenerationListener>();
        List portletURLFilterList = app.getListeners();
        if (portletURLFilterList != null) {
            for (Listener listener : portletURLFilterList) {
                String message;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(listener.getListenerClass());
                    if (clazz == null) continue;
                    listeners.add((PortletURLGenerationListener)clazz.newInstance());
                }
                catch (ClassNotFoundException e) {
                    message = "The class isn't found.";
                    LOG.error(message);
                }
                catch (InstantiationException e) {
                    message = "The instantiation fail.";
                    LOG.error(message);
                }
                catch (IllegalAccessException e) {
                    message = "IllegalAccessException";
                    LOG.error(message);
                }
            }
        }
        return listeners;
    }
}

