/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLProviderImpl
implements PortletURLProvider {
    private final PortalURL url;
    private final PortletURLProvider.TYPE type;
    private final String window;
    private PortletMode portletMode;
    private WindowState windowState;
    private String cacheLevel;
    private String resourceID;
    private Map<String, String[]> renderParameters;
    private Map<String, String[]> publicRenderParameters;
    private Map<String, List<String>> properties;

    public PortletURLProviderImpl(PortalURL url, PortletURLProvider.TYPE type, PortletWindow portletWindow) {
        this.url = url;
        this.type = type;
        this.window = portletWindow.getId().getStringId();
    }

    public PortalURL apply() {
        PortalURL url = this.url.clone();
        if (PortletURLProvider.TYPE.ACTION == this.type) {
            url.setActionWindow(this.window);
            url.setResourceWindow(null);
            url.clearParameters(this.window);
        } else if (PortletURLProvider.TYPE.RESOURCE == this.type) {
            url.setActionWindow(null);
            url.setResourceWindow(this.window);
            if (!"cacheLevelFull".equals(this.cacheLevel)) {
                for (PortalURLParameter portalURLParameter : url.getParameters()) {
                    if (!this.window.equals(portalURLParameter.getWindowId())) continue;
                    url.getPrivateRenderParameters().put(portalURLParameter.getName(), portalURLParameter.getValues());
                }
            }
            url.clearParameters(this.window);
        } else {
            url.setResourceWindow(null);
            url.setActionWindow(null);
            url.clearParameters(this.window);
        }
        if (this.portletMode != null) {
            url.setPortletMode(this.window, this.portletMode);
        }
        if (this.windowState != null) {
            url.setWindowState(this.window, this.windowState);
        }
        if (this.renderParameters != null) {
            for (Map.Entry entry : this.renderParameters.entrySet()) {
                if (this.publicRenderParameters != null && this.publicRenderParameters.containsKey(entry.getKey())) continue;
                url.addParameter(new PortalURLParameter(this.window, (String)entry.getKey(), (String[])entry.getValue()));
            }
        }
        if (this.publicRenderParameters != null) {
            for (Map.Entry entry : this.publicRenderParameters.entrySet()) {
                String[] stringArray;
                Map map = url.getNewPublicParameters();
                Object k = entry.getKey();
                if (entry.getValue() != null) {
                    stringArray = (String[])entry.getValue();
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = null;
                }
                map.put(k, stringArray);
            }
        }
        url.setResourceID(this.resourceID);
        url.setCacheability(this.cacheLevel);
        return url;
    }

    public PortletURLProvider.TYPE getType() {
        return this.type;
    }

    public void setPortletMode(PortletMode mode) {
        this.portletMode = mode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setWindowState(WindowState state) {
        this.windowState = state;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
    }

    public boolean isSecure() {
        return false;
    }

    public Map<String, String[]> getRenderParameters() {
        if (this.renderParameters == null) {
            this.renderParameters = new HashMap<String, String[]>();
        }
        return this.renderParameters;
    }

    public Map<String, String[]> getPublicRenderParameters() {
        if (this.publicRenderParameters == null) {
            this.publicRenderParameters = new HashMap<String, String[]>();
        }
        return this.publicRenderParameters;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public void setCacheability(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String toURL() {
        return this.toURL(false);
    }

    public String toURL(boolean absolute) {
        return this.apply().toURL(absolute);
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        String result = this.apply().toURL(false);
        if (escapeXML) {
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("'", "&#039;");
            result = result.replaceAll("\"", "&#034;");
        }
        out.write(result);
    }

    public Map<String, List<String>> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        }
        return this.properties;
    }
}

