/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.Event;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.driver.services.container.EventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletWindowThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PortletWindowThread.class);
    private PortletContainer container;
    private PortletWindow portletWindow;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortletContextService portletContextService;
    private List<Event> events = new ArrayList<Event>();

    public PortletWindowThread(ThreadGroup group, String name, PortletContainer container, PortletWindow window, HttpServletRequest request, HttpServletResponse response, PortletContextService portletContextService) {
        super(group, name);
        this.request = request;
        this.response = response;
        this.portletWindow = window;
        this.container = container;
        this.portletContextService = portletContextService;
    }

    public void run() {
        super.run();
        while (this.events.size() > 0) {
            try {
                Event event = this.events.remove(0);
                Serializable value = event.getValue();
                XMLStreamReader xml = null;
                try {
                    if (value instanceof String) {
                        String in = (String)((Object)value);
                        xml = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(in));
                    }
                }
                catch (XMLStreamException e1) {
                    throw new IllegalStateException(e1);
                }
                catch (FactoryConfigurationError e1) {
                    throw new IllegalStateException(e1);
                }
                if (xml != null) {
                    try {
                        EventDefinition eventDefinitionDD = this.getEventDefintion(event.getQName());
                        ClassLoader loader = this.portletContextService.getClassLoader(this.portletWindow.getPortletDefinition().getApplication().getName());
                        Class<Serializable> clazz = loader.loadClass(eventDefinitionDD.getValueType()).asSubclass(Serializable.class);
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                        Unmarshaller unmarshaller = jc.createUnmarshaller();
                        JAXBElement result = unmarshaller.unmarshal(xml, clazz);
                        event = new EventImpl(event.getQName(), (Serializable)result.getValue());
                    }
                    catch (JAXBException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (PortletContainerException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.container.doEvent(this.portletWindow, this.request, this.response, event);
            }
            catch (PortletException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            catch (PortletContainerException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    private EventDefinition getEventDefintion(QName name) {
        PortletApplicationDefinition appDD = this.portletWindow.getPortletDefinition().getApplication();
        for (EventDefinition def : appDD.getEventDefinitions()) {
            QName tmp;
            if (!(def.getQName() != null ? def.getQName().equals(name) : (tmp = new QName(appDD.getDefaultNamespace(), def.getName())).equals(name))) continue;
            return def;
        }
        throw new IllegalStateException();
    }
}

